#include <sys/socket.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include "common.h"

extern int connectlnsh ();
int showdata = 1, HTML;
FILE *f;
#define BUF_LEN 100

struct lnk {
	char *instr;
	unsigned int id;
	short int lid;
	struct lnk *next;
} *first;

int get_link ()
{
	char tmp [BUF_LEN], *c, *k;
	struct lnk *lp;

	if (!fgets (tmp, BUF_LEN, f))
	{
		perror ("links::fgets");
		exit (1);
	}
	switch (tmp [0]) {
	case '-':
		if (!HTML) fprintf (stderr, "Lndbase reply: %s", tmp);
		else printf ("Request fail: %s\n", tmp);
		exit (1);
	case '*':
		return 0;
	default: break;
	}

	if (!first)
		first = lp = (struct lnk*) malloc (sizeof (struct lnk));
	else
	{
		for (lp = first; lp->next; lp = lp->next);
		lp->next = (struct lnk*) malloc (sizeof (struct lnk));
		lp = lp->next;
	}

	// Each link has the form:
	// "group: [id]" or "group: [id] / lid"
	lp->next = NULL;
	lp->instr = (char*) malloc (strlen (tmp));
	tmp [strlen (tmp) - 1] = 0;
	strcpy (lp->instr, tmp);
	c = strchr (lp->instr, ':');
	*++c = 0;
	k = strchr (++c, ']');
	*k++ = 0;
	lp->id = atoi (c + 1);
	lp->lid = (*(k + 1) == '/') ? atoi (k + 3) : 0;
	return 1;
}

/*
 * Get an id and check:
 *  if its a small element.
 *  if its a oneline element.
 *  if its printable.
 */
#define MAX_SHOW 50
char *check_data (unsigned int id)
{
	char tmp [BUF_LEN], *c;
	unsigned int len;

	f = fdopen (connectlnsh (), "r+");
	fprintf (f, "lenof %u\n", id);
	fflush (f);
	fgets (tmp, BUF_LEN, f);
	if (tmp [0] == '-')
	{
		fprintf (stderr, "Unexpected reply: %s", tmp);
		return NULL;
	}
	len = atoi (tmp);
	fgets (tmp, BUF_LEN, f); // the reply status line
	fclose (f);
	if (len > MAX_SHOW)
		return NULL;
	c = (char*) malloc (len + 1);
	f = fdopen (connectlnsh (), "r+");
	fprintf (f, "sh %u\n", id);
	fflush (f);
	fgets (tmp, BUF_LEN, f);
	fread (c, 1, len + 1, f);
	fgets (tmp, BUF_LEN, f);
	c [len--] = 0;
	for (id = 0; id < len; id++)
		if (!isprint (c [id]))
		{
			free (c);
			return NULL;
		}
	return c;
}

void print_link (struct lnk *lp)
{
	char sgrp [] = "%s ";
	char httpgrp [] = "<TR> <TD> <STRONG>%s</STRONG> <TD>";
	char httpdata [] = "<TD> %s";
	char httpdatalink [] = "<TD> <A HREF=/sh/%u> view </A>";
	char sid [] = " [%u]";
	char httpid [] = "<TD> [<A HREF=%u>%u</A>]";
	char *c;

	printf ((HTML) ? httpgrp : sgrp, lp->instr);
	if ((showdata) && (c = check_data (lp->id)))
		printf ((HTML) ? httpdata : sgrp, c);
	else if (HTML)
		printf (httpdatalink, lp->id);

	if (HTML) printf (httpid, lp->id, lp->id);
	else printf (sid, lp->id);

	 /* At this point we implement the linkid bindings.
	  * Theoretically : we should call 'bind (lp->lid)'
	  * which shall return a string which identifies this
	  * linkid. It will have to look it up again in lndbase.
	  */
	if (lp->lid) printf (" / %i\n", lp->lid);
	else puts ("");
}

int main (int argc, char **argv)
{
	int i;
	struct lnk *lp;

	while ((i = getopt (argc, argv, "ih")) != -1)
		switch (i) {
		case 'i':
			showdata = 0;
			break;
		case 'h':
			HTML = 1;
			break;
		default:
			fprintf (stderr, "unknown option\n");
			return 1;
		}
	if (optind == 0)
	{
		fprintf (stderr, "No ID given\n");
		return 1;
	}

	f = fdopen (connectlnsh (), "r+");
	fprintf (f, "links %u\n", i = atoi (argv [optind]));
	fflush (f);

	if (HTML)
		printf ("Content-Type: text/html\r\n\r\n"
			"<HTML><H2><HEAD>"
		      	"<TITLE> Links of element %i"
			"</TITLE></HEAD><BODY><TABLE>\n", i);

	while (get_link ());
	fclose (f);

	for (lp = first; lp; lp = lp->next)
		print_link (lp);
	if (HTML) puts ("</TABLE></BODDY></H2></HTML>");

	return 0;
}
