#include <sys/stat.h>
#include <sys/socket.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include "common.h"

extern int connectlnsh ();

FILE *f;
char *c = NULL;

void F2F (FILE *from, FILE *to)
{
#define BUF_LEN 2048
	char tmp [BUF_LEN];

	do fwrite (tmp, 1, fread (tmp, 1, BUF_LEN, from), to);
	while (!feof (from));
}

int istmp = 0;

char *stdin_tmp ()
{
	FILE *f;
	c = tmpnam (NULL);

	F2F (stdin, f = fopen (c, "w"));
	fclose (f);
	istmp = 1;
	return c;
}

/*
 */
int new_file (char *c)
{
	struct stat buf;
	FILE *cur;
	char reply [100];
	unsigned int id;

	if (stat (c, &buf) == -1)
	{
		perror ("stat");
		fprintf (stderr, "Error Opening: %s\n", c);
		return 1;
	}

	if (!(cur = fopen (c, "r")))
	{
		perror ("fopen");
		fprintf (stderr, "Error Opening: %s\n", c);
		return 1;
	}
	fprintf (f, "newcl %lu\n", buf.st_size);
	F2F (cur, f);
	fputs ("\n", f);
	fflush (f);
	fclose (cur);
	if (istmp) if (c) unlink (c);

	if (!fgets (reply, 100, f))
	{
		perror ("lnshinsert:fgets");
		return 1;
	}
	if (reply [0] == '-')
	{
		fprintf (stderr, "Failure: %s", reply);
		return 1;
	}
	id = atoi (reply);
	fgets (reply, 100, f);
	printf ("%u\n", id);
	return reply [0] == '-';
}

int main (int argc, char **argv)
{
	int i = 1;

	if (argc == 3)
	{
		char cmd [100];
		sprintf (cmd, LNSH_CD, argv [1]);
		if (system (cmd) != 0)
		{
			fprintf (stderr, "Changing to group: %s failed\n",
				 argv [1]);
			return 1;
		}
		i = 2;
	}
	f = fdopen (connectlnsh (), "r+");
	return (argc == 1) ? new_file (stdin_tmp ())
		: new_file (argv [i][0] == '-' ? stdin_tmp () : argv [i]);
}
