#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "common.h"

int connectlnsh ()
{
	int sock;
	struct sockaddr_un addr;

	if (!getenv (LNSH_ENV))
	{
		fprintf (stderr, "Can't find " LNSH_ENV " environment "
				 "variable, not connected ?\n");
		exit (1);
	}

	sock = socket (AF_UNIX, SOCK_STREAM, 0);
	addr.sun_family = AF_UNIX;
	sprintf (addr.sun_path, getenv (LNSH_ENV));
	if (connect (sock, (struct sockaddr*)&addr, sizeof addr) == -1)
	{
		perror ("Can't connect");
		exit (1);
	}

	return sock;
}
