#include <sys/stat.h>
#include <sys/socket.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include "common.h"

extern int connectlnsh ();

FILE *f;
char *c = NULL;

void F2F (FILE *from, FILE *to)
{
#define BUF_LEN 2048
	char tmp [BUF_LEN];

	do fwrite (tmp, 1, fread (tmp, 1, BUF_LEN, from), to);
	while (!feof (from));
}

char *stdin_tmp ()
{
	FILE *f;
	c = tmpnam (NULL);

	F2F (stdin, f = fopen (c, "w"));
	fclose (f);
	return c;
}

void altid_file (unsigned int i, char *c)
{
	struct stat buf;
	FILE *cur;

	if (stat (c, &buf) == -1)
	{
		perror ("stat");
		fprintf (stderr, "Error Opening: %s\n", c);
		exit (1);
	}

	if (!(cur = fopen (c, "r")))
	{
		perror ("fopen");
		fprintf (stderr, "Error Opening: %s\n", c);
		exit (1);
	}
	f = fdopen (connectlnsh (), "r+");
	fprintf (f, "altcl %u %lu\n", i, buf.st_size);
	F2F (cur, f);
	fputs ("\n", f);
	fflush (f);
	fclose (cur);
	if (c) unlink (c);
}

void altid_str (unsigned int i, char *c)
{
	f = fdopen (connectlnsh (), "r+");
	fprintf (f, "altcl %u %u\n%s\n", i, strlen (c), c);
	fflush (f);
}

int check_reply ()
{
	char reply [100];

	if (!fgets (reply, 100, f))
	{
		perror ("fgets");
		return 1;
	}
	if (reply [0] != '-' && reply [0] != '*')
	{
		fprintf (stderr, "An element with this content "
			 "already exists and has ID %s", reply);
		fgets (reply, 100, f);
		return 1;
	}

	return 0;
}

int main (int argc, char **argv)
{
	if (argc < 2)
	{
		fprintf (stderr, "Usage: lnshaltid ID [-s] STRING\n");
		return 1;
	}
	else if (argc == 2)
		altid_file (atoi (argv [1]), stdin_tmp ());
	else if (getopt (argc, argv, "s:") == -1)
		altid_file (atoi (argv [1]), argv [2]);
	else
		altid_str (atoi (argv [1]), optarg);

	return check_reply ();
}
