/******************************************************************************
	sysutil.c

	system/library calls transparency to our project.
	plain C
******************************************************************************/
/**************************************************************************
 Copyright (C) 2000 Stelios Xantkakis
**************************************************************************/

#include <sys/stat.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

/*
 * Read/write files
 */

int filesize (char *fn)
{
	struct stat statbuf;

	if (stat (fn, &statbuf) == -1) return -1;

	return statbuf.st_size;
}

int readfile (char *fn, char *b, int bs)
{
	FILE *f;

	if (!(f = fopen (fn, "r"))) return -1;

	fread (b, 1, bs, f);

	fclose (f);

	return 0;
}

/* Write files to exports/ only */
static char exportdir [] = "exports/";

static FILE *exportsfopen (char *path, char *mode)
{
	char *t;

	if (strrchr (path, '/')) path = strrchr (path, '/') + 1;

	t = (char*) alloca (sizeof (exportdir) + strlen (path) + 1);

	strcat (strcpy (t, exportdir), path);

	return fopen (t, mode);
}

int exportsize (char *fn)
{
	struct stat statbuf;
	FILE *f;

	if (!(f = exportsfopen (fn, "r"))) return -1;
	if (fstat (fileno (f), &statbuf) == -1) {
		fclose (f);
		return -1;
	}
	fclose (f);

	return statbuf.st_size;
}

int readexport (char *fn, char *b, int bs)
{
	FILE *f;

	if (!(f = exportsfopen (fn, "r"))) return -1;

	fread (b, 1, bs, f);

	fclose (f);

	return 0;
}

int writefile (char *fn, char *b, int bs)
{
	FILE *f;

	if (!(f = exportsfopen (fn, "w"))) return -1;

	fwrite (b, 1, bs, f);

	fclose (f);

	return 0;
}

/*
 * Text fitting (irrelevant)
 */

static void space_for_the_papa (char *c, int n)
{
	while (n--) *c++ = ' ';
}

void fit_text (char adj, char *s, int sz, char *dest)
{
	int i = strlen (s);

	memset (dest, 0, sz + 1);

	if (i <= sz) switch (adj) {
		case 'r':
			space_for_the_papa (dest, sz - i);
			strcpy (dest + sz - i, s);
			break;
		case 'l':
			strcpy (dest, s);
			space_for_the_papa (dest + i, sz - i);
			break;
		case 'c':
		default:
			space_for_the_papa (dest, (sz - i) / 2);
			strcpy (dest + (sz - i) / 2, s);
			space_for_the_papa (dest + (sz + i) / 2, (sz - i) / 2);
	} else switch (adj) {
		case 'l':
			strncpy (dest, s, sz);
			break;
		case 'r':
			strncpy (dest, s + (sz - i), sz);
			break;
		case 'c':
		default:
			strncpy (dest, s + (sz - i) / 2, sz);
	}
}

/*
 * Automatic configdir fopen
 */
static char shhm [] = "/.eShell/";

void init_shome (char *c)
{
	struct stat statbuf;
	char *sHome;

	if (c == NULL) {
		sHome = (char*) alloca (strlen (getenv ("HOME")) + sizeof shhm);
		strcat (strcpy (sHome, getenv ("HOME")), shhm);
	} else sHome = c;

	if (chdir (sHome) == -1) {
		fprintf (stderr, "Invalid shell home directory: \"%s\"\n",
			 sHome);
		exit (1);
	}

	if (stat (exportdir, &statbuf) == -1) { //breaindead implementation
	if (mkdir (exportdir, S_IRUSR + S_IWUSR + S_IXUSR) == -1) goto Else;
	} else if (!S_ISDIR(statbuf.st_mode)) {
Else:
		fprintf (stderr, "No %s directory in %s\n", exportdir, sHome);
		exit (1);
	}
}

/*
 * alloca friendly, const friendly, mm
 */

#include "arch.h"

int isdata (void *x)
{
	char automatique;

	return (x DATASTACK (void*)&automatique);
}

int candelete (void *ptr)
{
	static void* dthresh = NULL;

	if (ptr == NULL) return 0;

	if (dthresh == NULL)
		dthresh = ptr;

	return isdata (ptr) && dthresh SD_DATA ptr;
}
