#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/time.h>

/**************************************************************************
 Copyright (C) 2000 Stelios Xantkakis
**************************************************************************/

//

#include "projectlog.h"

#include "dbstree.h"
#include "epil.h"
#include "INIT.h"
#include "sysutil.h"

//**************************************************
// epilException::std() is called before the stack
// unrolls and things like the backtrace are auto
// destructed.
// ExceptionCleanups() is called right after the
// stack unroll after the catch. This is the global
// cleanup function -- no partial cleanup to a
// previous execution point.
// Zexec_unit () is supposed to execute epil macro
// code and return to a zero-point on exception.
//**************************************************

void epilException::std ()
{
	Logprintf ("Exception : %s\n", epilExceptionText);
	fprintf (stderr, "Exception : %s\n", epilExceptionText);
	backtrace_onexception ();
}

void ExceptionCleanups ()
{
	Logprintf ("%u arguments to the stack\n", ep_argstack);
}

int Zexec_unit (char *c)
{
	int i = 0;
	try {
		exec_unit (c);
	} catch (epilException) {
		i = 1;
		ExceptionCleanups ();
	}
	ep_cleancommas ();
	return i;
}

//*****************************************************
// 			Main
//*****************************************************

static void parser (unsigned int, char**);
static char *initrun = "init";

int main (int argc, char **argv)
{
	candelete (new char [1]);

	srand (time (NULL));

	puts ("Lndbase eShell v0.1");

	parser (argc - 1, argv + 1);

	init_epil ();
	stdm ();
	priv ();
	iServ ();
	lnshell ();
	library ();

	CODED(startx);
	CODED(starttty);

	ep_optimize_macrotree ();

	runfile (initrun);
}

#ifdef EFENCE
// ###### Electric Fence ######
// These activate efence on our C++ allocations.
// May Bruce Perens be with us.
// #############################################

void *operator new (size_t s)
{
	return malloc (s);
}

void operator delete (void *p)
{
	free (p);
}

void *operator new[] (size_t s)
{
	return malloc (s);
}

void operator delete[] (void *p)
{
	free (p);
}

#endif

//*********************************************************************

#define TYPE_BOOL 0
#define TYPE_INT 1
#define TYPE_STRING 2

#define OPTNUM sizeof options / sizeof (struct option)

static char defsys [] = "syscmd";
extern char *fsyscmd;

static void parser (unsigned int argc, char **argv)
{
	char *shell_home = NULL;

	fsyscmd = defsys;

	struct option {
		char *opt_name;
		int type;
		int invoked;
		union {
			char **str;
			unsigned int *num;
		} val_un; 
	} options [] = {
		{ "-i",	TYPE_STRING, 0, { &initrun } },
		{ "-d",	TYPE_STRING, 0, { &shell_home } },
		{ "-uf", TYPE_BOOL, 0, { NULL } },
		{ "-s",	TYPE_STRING, 0, { &fsyscmd } }
#if 0
		 * The CORRECT code is included here to
		 * replace the WRONG code when the
		 * warning is disabled from gcc.
		 */
		"-i",	TYPE_STRING,	0, &initrun,
		"-d",	TYPE_STRING,	0, &shell_home,
		"-uf",	TYPE_BOOL,	0, NULL,
		"-s",	TYPE_STRING,	0, &fsyscmd
#endif
	};
	unsigned int i, j;

	for (i = 0; i < argc; i++)
	{
		for (j = 0; j < OPTNUM; j++)
			if (!strcmp (argv [i], options [j].opt_name))
				break;

		if (j == OPTNUM)
		{
			fprintf (stderr, "Unknown option %s\n", argv [i]);
			exit (1);
		}
		options [j].invoked = 1;
		if (options [j].type == TYPE_BOOL)
			continue;
		++i;
		if (i == argc)
		{
			fprintf (stderr, "Incomplete option %s\n",
				 argv [i - 1]);
			exit (1);
		}
		if (options [j].type == TYPE_INT)
			*(options [j].val_un.num) = strtol (argv [i], NULL, 10);
		else
			*(options [j].val_un.str) = argv [i];
	}

	if (options [2].invoked) uf ();

	init_shome (shell_home);
}
