/******************************************************************************
	readline++
******************************************************************************/

#ifndef READLINE_INCLUDED

#define READLINE_INCLUDED

#include "dLIST.h"

extern char *iStrDup (char*);
extern void iStrDelete (char*);

// :::::::::::::::::::::::::::::::::::::::::::
// Special values to the important keys
// :::::::::::::::::::::::::::::::::::::::::::

#define K_SKIP		1000
#define K_UP		1001
#define K_DOWN		1002
#define K_LEFT		1003
#define K_RIGHT		1004
#define K_DEL		1005
#define K_END		1006
#define K_HOME		1007
#define K_PGUP		1009
#define K_PGDOWN	1010
#define K_ESC		1011

// ::::::::::::::::::::::::::::::::::::::::::
// Each readline has such a dynamic structure
// ::::::::::::::::::::::::::::::::::::::::::

class line_struct {
	int allocd;
   public:
	line_struct ();
	int cursor;
	char *line;
	int linelen;
	void add_char (char);
	void del ();
	void deltoend ();
	void backspace ();
	void word_left ();
	void word_right ();
	void reset (char* = NULL);
	void Strcat (char*);
	~line_struct ();
};

// ::::::::::::::::::::::::::::::::::::::::::
// Basic readline interface. All the virtual
// things may vary among various readlines++
// We wish to make an editor seem as one big
// readline someday.
// The main property of readline is do_char
// ::::::::::::::::::::::::::::::::::::::::::

class breadline {
	int max_len;
   protected:
	int cc;
virtual	void fix_vcur	();
virtual	void do_tab	() = 0;
virtual	void do_varrow	() = 0;
virtual	void do_harrow	();
virtual	void do_enter	() = 0;
virtual	void do_bsdel	();
virtual	void do_pg	();
virtual	void do_hoend	();
virtual	void do_cchar	();
virtual	void present	();
   public:
	breadline (char *c = NULL, int = 1024);
	line_struct line;
	char *prompt;
	int Width, Vcur;
	void do_char (int);
virtual	~breadline ()	{ iStrDelete (prompt); }
};

// ::::::::::::::::::::::::::::::::::::::::::
// In contrast to a readline with completions
// this is the property of a normal <TAB>
// ::::::::::::::::::::::::::::::::::::::::::

class normtab : virtual protected breadline
{
   protected:
	void do_tab ();
};

// ::::::::::::::::::::::::::::::::::::::::::
// In contrast to a readline with history
// this is when up-down arrows are ignored
// ::::::::::::::::::::::::::::::::::::::::::

class novarrow : virtual protected breadline
{
   protected:
	void do_varrow ();
};

// ::::::::::::::::::::::::::::::::::::::::::
// This readline takes care of history, keys
// and updating the history on enter (we have
// to call addl() in the ancestor)
// ::::::::::::::::::::::::::::::::::::::::::

class history : virtual protected breadline
{
	int nlines;
	dlistNode *cur;
	dlistAuto<char*> TheList;
	char *eline;
   protected:
	void do_varrow ();
	void addl ();
   public:
	history (int);
	~history ();
};
#endif
