/******************************************************************************
	ln shell C interface
******************************************************************************/

#include "dLIST.h"

#define STYPE_OTHER	0
#define STYPE_LINKS	1
#define STYPE_PLINKS	2
#define STYPE_DIR	3
#define STYPE_TRACE	4

class S;
class E;
class EP;

extern S*		CurrentList;
extern E*		CurrentElement;

extern bool		In (S*, E*);
extern S*		Links (E*, char* = NULL);
extern int		NElements (S*);
extern S*		EmptyS (char* = NULL);
extern unsigned int	Idof (E*);
extern void		Add (S*, E*);
extern void		Kill (S*);
extern E*		EIndex (S*, int);
extern E*		EForID (unsigned int);
extern void		makeCurrent (S*);
extern int		DataSize (E*);
extern char*		GroupOf (E*);
extern bool		IsBin (E*);
extern char*		tDataof (E*);
extern void		setCur (E*);
extern S*		LsGroup (char*);
extern E*		Find (char*);
extern S*		cFind (char*);
extern S*		Dup (S*);
extern char*		SName (S*);
extern void		SOName (S*);

extern dlist		SList;

extern void		sendData (E*, FILE*);
extern void		VoidID (unsigned int);
extern void		renGroupNotify (char*, char*);
extern void		chgrpNotify (E*);
extern void		RemoveCache (E*);

class SLooper : dlistNodeAuto
{
friend	class S;
	EP *ep;
	void RE (EP*);
   public:
	S *s;	
	short int Lid;
	SLooper (S*);
	E *Next ();
	void Reset ();
	~SLooper ();
};
