#ifndef GRAPHICS_INCLUDED
#define GRAPHICS_INCLUDED
class drawable;

#include "readline++.h"

/* Color defs */
#define COL_BLACK	0
#define COL_WHITE	1
#define COL_YELLOW	2
#define COL_SANDYBROWN	3
#define COL_DARKRED	4
#define COL_BLUE	5
#define COL_DARKGREEN	6
#define COL_LIGHTGREY	7
#define COL_DARKGREY	8

/* Display dimensions */
extern int scrX, scrY;

/* flush */
extern void Gflush ();

/* Font info */
extern int fwidth (int);
extern int fheight (int);
extern int twidth (int, char*);

/* Our only tools of graphic output */
extern void DrawLine (int, int, int, int, int);
extern void DrawPoint (int, int, int);
extern void FillRect (int, int, int, int, int);
extern void DrawRect (int, int, int, int, int);
extern void BDrawString (char*, int, int, int, int, int = 0);
extern void DrawString (char*, int, int, int, int);

/* Save Unders */
extern void *SaveUnders (int, int, int, int);
extern void RestoreUnders (void*);
extern void FreeUnders (void*);

/* Input: mouse click point */
extern int clickX, clickY;
extern bool rightButton;

/* Sleep X ms if pointer pressed and not released, return 0 else */
extern int nailPointer ();

/* User events. clicks, keypresses, exposed */
extern void UserEvents (drawable*);



/* Hierarchial, polymorphic encapsulated drawing */

class drawable
{
friend	void coded_crap ();
friend	class radiobox;
friend	class Xreadline;

	void perigram (int, int);
   protected:
	void altperigram (int, int);
	bool checkclick ();
	void uperigram ();
	void dperigram ();
	void hline (int, int, int);
	void fill_block (int);

	/* library instantiation */
	void drawline (int, int, int, int, int);
	void drawpoint (int, int, int);
	void fillrect (int, int, int, int, int);
	void drawrect (int, int, int, int, int);
	void bdrawstring (char*, int, int, int, int, int = 0);
	void drawstring (char*, int, int, int, int);
	void trcursor (int, int, char);
	void setXYd (drawable*, int, int);
   public:
	drawable ();
	drawable (int, int, int, int);
virtual	void draw ();
virtual	bool onclick ();
virtual	void setXY (int, int);
virtual	bool operator == (drawable*);
virtual	~drawable () { }

static	int switchLight ();
static	int Bthick;
	int X, Y, W, H;
	/* X,Y,W,H should be private. The comment from the time before
	  they became pubilc follows */
	/* A very social class indeed */
};

extern drawable *RootD;

namespace JCursor
{
extern	bool PasteNL;
extern	bool On, Flashing;
extern	int font, fg, bg;
extern	int X, Y;
extern	char Symbol [2];
extern	breadline *Readline;
	void readlineDeath ();
	void show ();
	void hide ();
	void transport (int, int, char);
	void changerl (breadline*, int, int, int, bool = false);
	void do_char (int);
}
extern void Paste (int, char*);



/* Containers */

class dcont : public drawable
{
   protected:
	bool peri;
	dlistAuto<drawable*> DList;
virtual	void settle ();
   public:
	dcont ();
	void operator += (drawable*);
	void draw ();
	void setXY (int, int);
	bool onclick ();
	void dcleanup ();
	bool operator == (drawable*);
virtual	~dcont ();
};

class vcont : public dcont
{
   protected:
	void settle ();
   public:
	vcont ();
};

class hcont : public dcont
{
   protected:
	void settle ();
   public:
	hcont ();
};

class acont : public dcont
{
   protected:
	void settle ();
   public:
	acont (int, int);
};




/* Various polymorphic object below here */

class tbutton : public drawable
{
   protected:
	int font;
	char *label;
virtual	void action () { }
   public:
	tbutton (int, char*);
	tbutton (int, char*, int);
	int bcol, fg;
	void draw ();
	bool onclick ();
};

class checkbox : public tbutton
{
   protected:
virtual	void drawstate ();
   public:
	checkbox (int, char*);
	void draw ();
	bool onclick ();

	bool state;
};

class radiobox;

class radioManager
{
friend	class eradiobox;
   protected:
	radiobox *current;
   public:
	radioManager ();
	void setcur (radiobox*);
};

class radiobox : public checkbox
{
friend	class radioManager;
	void drawstate ();
   protected:
	radioManager *M;
   public:
	radiobox (int, char*, radioManager*, bool = false);
	bool onclick ();
};

class vscreen : public drawable
{
friend	class editor;
friend	class rowarea;
friend	class rrowarea;
   protected:
	unsigned int tX, tY, dX, dY;
   public:
	int bg, fg;
	vscreen (int, int, int, int = 0, int = 1);
	void cls ();
	void pcursor (unsigned int, unsigned int, char);
	void puttext (unsigned int, unsigned int, char*, int = -1, bool = true);
	void draw ();

	bool onclick ();
	int cX, cY;
	int font;
};

class Xreadline : virtual public breadline, public drawable
{
	void do_enter ();
   protected:
	int bg1, fg1, bg2, fg2;
   public:
	Xreadline (int, int, int = 7, int = 0, int = 0, int = 1);
	void present ();
	void draw ();
	void setXY (int, int);
	void getCursor ();
	bool onclick ();
	int font;
	drawable DA;
virtual	~Xreadline ();
};

class uparrow : public drawable
{
friend	class scroller;
   public:
	void draw ();
};

class downarrow : public drawable
{
friend	class scroller;
   public:
	void draw ();
};

class scroller : public drawable
{
friend	class rowarea;
   protected:
	int vlen, vwin;
	int barpos, barlen;
static	int scrollFixed;
   public:
	scroller (int);
	void let (int, int);
	void setXY (int, int);
	int c, max;

	downarrow D;
	uparrow U;
};

class vscrollbar : public scroller
{
   public:
	vscrollbar (int, int);
	void draw ();
};

class gsign : public vscreen
{
   protected:
	char *txt;
   public:
	gsign (int, int, int, int, int);
	void draw ();
	~gsign ();
};
#endif
