/*
 * epil.h
 *
 */

#ifndef EPIL_INCLUDED
#define EPIL_INCLUDED

#include "dbstree.h"

class epilException
{
	void std ();			// define at main.C
    public:
	epilException () { std (); }
	epilException (const char*);
	epilException (const char*, const char*);
};
extern int Zexec_unit (char*);		// define at main.C

#define TMP_POP_ALLOC(x) \
	x = (char*) alloca (ep_poplen () + 1);\
	ep_pop (x);
#define DAT_POP_ALLOC(x) \
	x = new char [ep_poplen () + 1];\
	ep_pop (x);
#define POP_OUT \
	ep_poplen ();\
	ep_pop (NULL);

extern char	epilExceptionText [];
extern int	ep_pargs, ep_argstack;
extern bool	etrace, strace;

extern bool	lock_epil;
extern void	ep_check_locked ();

extern bool	ep_isempty ();
extern int	ep_examine_stack (int, char*, int);
extern void	ep_push (char*, int);
extern void	ep_push (char*);
extern int	ep_poplen ();
extern void	ep_pop (char*);
extern char*	ep_pop ();
extern void	ep_repush ();
extern void	ep_clearstack ();
extern void	ep_setSbp ();
extern void	ep_delSbp ();
extern void	ep_cleanSbp ();
extern void	ep_setskips (int);
extern void	ep_setskips (char*);
extern void	ep_setexits (int);
extern void	ep_setexits (char*);
extern void	ep_cleancommas ();
extern char*	ep_quote (char*, char*);
extern void	ep_push_quoted_arg (char*);
extern void	ep_dump_macros (FILE*);

extern void	exec_unit (char*);
extern int	ep_register_ctrl (char, void (*)(char*));

// *--------------------------- From the macro/variable/object addition

class Macro;

extern dbsTree	MacroTree, VarTree, ThisTree;

extern int	ep_register_coded (char*, void (*)(void));
extern void	ep_optimize_macrotree ();
extern void	init_epil ();
extern void	ep_macro (int (*) (const char*));
extern bool	ep_ifdef (char*);
extern bool	ep_iscoded (char*);
extern bool	ep_haveobject (char*);
extern void	ep_call_object (char*);

extern void	backtrace_onexception ();

#define CODED(x) ep_register_coded (#x, coded_ ## x)

class Object;

class SurfaceObject
{
	Object *O;
   protected:
	void appear (char*);
virtual	void activate () = 0;
   public:
	SurfaceObject ();
	void called ();
	void myName ();
	char *oname ();
virtual	~SurfaceObject ();
};

extern SurfaceObject *CurrentSurface;

// *------------------------------- From the stdepil standard macro library

extern bool ep_boolean;

extern void stdm ();
extern void coded_execarg ();
#endif
