/******************************************************************************

	vlog

	A screen were we can scroll back to a 20kB buffer of lines.
	To avoid less/more in the console and log viewing in the X.

	Leaving the messages to stdout and using the xterm scroll back
	facilities _is better. We can even copy text and paste it elsewhere.

	vlog is rather here to be typically correct.

******************************************************************************/
/**************************************************************************
 Copyright (C) 2000 Stelios Xantkakis
**************************************************************************/

#include <string.h>
#include <stdio.h>
#include <stdarg.h>

#include "projectlog.h"
#include "sysutil.h"
#include "dLIST.h"
#include "rows.h"

#define BUFFER_SIZE 23 * 1024

static char *vlog;

static int next_point;

#define SINDEX(x) &vlog[x]

static dlist LList;

struct vline : public dlistNode
{
	int indx;
	vline (int);
	~vline ();
};

vline::vline (int i)
{
	LList.addtoend (this);
	indx = i;
}

vline::~vline ()
{
	LList.dremove (this);
}

#define VLLINE(X) ((vline*)X)

static void release (int s, int e)
{
	while (LList.Start && VLLINE(LList.Start)->indx >= s
	       && VLLINE(LList.Start)->indx < e)
		delete VLLINE(LList.Start);
}

//
// Insert a line of size <= termX
//
static void insert_cline (char *l, int sz)
{
	if (next_point + sz < BUFFER_SIZE) {
		release (next_point, next_point + sz);
		strncpy (SINDEX(next_point), l, sz);
		new vline (next_point);
		next_point += sz;
	} else {
		int i = BUFFER_SIZE - next_point;
		release (next_point, BUFFER_SIZE);
		release (0, 1 + sz - i);
		strncpy (SINDEX(next_point), l, i);
		strncpy (SINDEX(0), l + i, sz - i);
		new vline (next_point);
		next_point = sz - i;
	}
}

static int termX;
static int elines;

//
// Break a newline terminated line into lines <= termX
// passed to insert_cline
//
static void insert_line (char *l)
{
	int i = strlen (l), j = 0;

	if (i == 0)
		if (elines >= 3) return;
		else ++elines;
	else elines = 0;

	while (1)
		if (i > termX) {
			insert_cline (l + j, termX);
			i -= termX;
			j += termX;
		} else {
			insert_cline (l + j, i);
			break;
		}
}

static char *remains;

static void add_remains (char *r)
{
	int rs = strlen (remains);
	int ts = rs + strlen (r);

	if (ts >= termX) {
		strncat (remains, r, termX - rs);
		insert_line (remains);
		strcpy (remains, r + (termX - rs));
	} else strcat (remains, r);
}

static void plus_remains (char *l)
{
	if (remains [0]) {
		char *t = (char*) alloca (strlen (remains) + strlen (l) + 1);
		strcat (strcpy (t, remains), l);
		remains [0] = 0;
		insert_line (t);
	} else insert_line (l);
}

static char *row4vline (vline *v)
{
	static char *current_line = NULL;

	if (!v) return NULL;

	int np = (v->next) ? ((vline*) v->next)->indx : next_point;

	if (!current_line)
		current_line = new char [termX + 2];

	if (v->indx > np) {
		int be;
		strncpy (current_line, SINDEX(v->indx),
			 be = BUFFER_SIZE - v->indx);
		strncpy (current_line + be, SINDEX(0), np);
		current_line [be] = 0;
	} else {
		strncpy (current_line, SINDEX(v->indx), np - v->indx);
		current_line [np - v->indx] = 0;
	}

	return current_line;
}

class logArray : public dlistArray
{
	char *ccache;
	char *cindex (int);
   public:
	logArray ();
	void MOD ();
};

static logArray *clg;

logArray::logArray () : dlistArray (&LList)
{
	ccache = NULL;
}

char *logArray::cindex (int i)
{
	return ccache = row4vline ((vline*) nth_node (i));
}

void logArray::MOD ()
{
	L = NULL;
}

extern void visual_catchup ();

//
// Insert a multiline text.
// lines broken according to newline and passed to insert_line()
//
void insert_nline (char *t)
{
	if (*t == 0) return;

	char *c = t;

	while ((c = strchr (t, '\n'))) {
		*c = 0;
		plus_remains (t);
		*c = '\n';
		t = c + 1;
	}

	if (*t) {
		int i = strlen (t);
		if (i > termX) {
			char k = t [i - i % termX];
			plus_remains (t);
			if (k) {
				t += (i - i % termX);
				*t = k;
				add_remains (t);
			}
		} else add_remains (t);
	}

	clg->MOD ();

	visual_catchup ();
}

// * * * * * * * ************** Project Log *************** * * * * * * *
//
// All other fprintfs in the program will use these
//

static bool fstd;

static bool xsprintf (int sl, const char *fmt, va_list ap)
{
	char *s = (char*) alloca (sl + 1);

	if (vsnprintf (s, sl, fmt, ap) == -1)
		return false;

	insert_nline (s);

	return true;
}

static int vlputs (const char *s)
{
	if (fstd) fputs (s, stderr);

	char *c = (char*) alloca (strlen (s) + 1);
	strcpy (c, s);

	insert_nline (c);

	return 0;
}

static int vlprintf (const char *fmt, ...)
{
	va_list args;
	int i = strlen (fmt) + 30;

	va_start (args, fmt);

	while (!xsprintf (i, fmt, args)) i += 40;

	va_end (args);

	if (fstd) {
		va_start (args, fmt);
		vfprintf (stderr, fmt, args);
		va_end (args);
	}

	return 0;
}

static int (*svprintf) (const char*, ...);
static int (*svputs) (const char*);

Array *ivlog (int tx, bool stde)
{
	termX = tx;
	remains = new char [2 * termX + 2];
	remains [0] = 0;

	Array *Alog = (clg = new logArray);
	vlog = new char [BUFFER_SIZE];

	Logputs ((fstd = stde) ?
		"Fork log stream...\n" : "Leaving current log stream...\n");

	svprintf = Logprintf;
	svputs = Logputs;

	Logprintf = vlprintf;
	Logputs = vlputs;

	Logputs ("Switched to vlog\n");

	return Alog;
}

void term_vlog ()
{
	Logprintf = svprintf;
	Logputs = svputs;
}
