/******************************************************************************

	Row area drawable.
	Using the Array class.

	Various data structures interfaced behind an array class.
	Random access may not be good for those structures but sequential
	access is always at least log(n) == instant.

	If you want to display something in a scrollable rows area, 
	make an Array for it.

******************************************************************************/
/**************************************************************************
 Copyright (C) 2000 Stelios Xantkakis
**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "projectlog.h"
#include "iServ.h"
#include "rows.h"
#include "sysutil.h"
#include "epil.h"

extern int c_scr_bg, c_scr_fg, c_scr_rv;

// :::::::::::::: rowarea
// Includes a scroller, a vscreen and displays an Array.
// virtuallity broken to "way to draw strings" and
// "what to do on click on a row"
// :::::::::::::::::::::::::::::::::::::::::::::::::::::

rowarea::rowarea (int f, int w, int h, Array *a) :
VSCR (f, w, h, c_scr_bg, c_scr_fg), SCRL (VSCR.H, h)
{
	font = f;
	W = SCRL.W + VSCR.W + 4 * Bthick;
	H = VSCR.H + 4 * Bthick + fheight (2);
	A = a;
	iA = 0;
}

void rowarea::rowselect ()
{
	selected = (VSCR.cY + iA < (int) A->total ()) ? VSCR.cY + iA : -1;
}

void rowarea::draw ()
{
	uperigram ();
	fill_block (7);
	VSCR.draw ();
	SCRL.draw ();
	context_draw ();
}

void rowarea::drawtxt (int y, char *t)
{
	if (t) VSCR.puttext (0, y, t);
}

void rowarea::context_draw ()
{
	int i;

	VSCR.draw ();
	if (A->hint () != -1 && (A->hint () > (iA + (int) VSCR.tY) / 2))
		for (i = iA + VSCR.tY - 1; i >= iA; i--)
			drawtxt (i - iA, (*A) [i]);
	else
		for (i = iA; i - iA < (int) VSCR.tY; i++)
			drawtxt (i - iA, (*A) [i]);

	SCRL.let (iA, A->total ());

	char t [11];
	t [10] = 0;
	snprintf (t, 9, "%u/%u      ", iA, A->total ());
	bdrawstring (t, Bthick + 2, 2 * Bthick + SCRL.H + 1, 4, c_scr_fg,
		     c_scr_bg);
}

void rowarea::setXY (int x, int y)
{
	drawable::setXY (x, y);
	setXYd (&VSCR, Bthick, Bthick + 1);
	setXYd (&SCRL, W - SCRL.W - 2 * Bthick, Bthick);
}

void rowarea::gotoend ()
{
	if (iA + 2 * VSCR.tY < A->total ());
		iA = (VSCR.tY > A->total ()) ? 0 : (A->total () - VSCR.tY);
	while (iA + VSCR.tY < A->total ()) {
		++iA;
		context_draw ();
	}
	context_draw ();
}

bool rowarea::onclick ()
{
	if (!checkclick ()) return false;

	if (SCRL.D.onclick ()) {
		do if (iA + VSCR.tY < A->total ()) {
			++iA;
			context_draw ();
		} while (nailPointer ());
	} else if (SCRL.U.onclick ()) {
		do if (iA > 0) {
			--iA;
			context_draw ();
		} while (nailPointer ());
	} else if (SCRL.onclick ()) {
		iA = SCRL.max * (clickY - Y - SCRL.U.H) / SCRL.vlen;
		if (iA > (int) VSCR.tY / 2) iA -= VSCR.tY / 2;
		else iA = 0;
		if (iA + VSCR.tY >= A->total ())
			iA = (A->total () < VSCR.tY) ? 0 :
			     (A->total () - VSCR.tY);
		context_draw ();
	} else if (VSCR.onclick ())
		rowselect ();

	return true;
}


//******************* Array virtual def & arrays *********************

Array::Array ()
{}

char *Array::operator [] (int i)
{
	return ((unsigned int) i < total ()) ? cindex (i) : NULL;
}

int Array::hint ()
{
	return -1;
}

//*******************************************
// A dlist interfaced with Array
//*******************************************

dlistNode *dlistArray::nth_node (int i)
{
	if (i >= D->cnt) return NULL;

	if (L && ((i > lst) ? (i - lst < 30 && i > 30)
			    : (lst - i < 30 && D->cnt - i > 30)))
		if (i > lst)
			while (i > lst) {
				L = D->Next (L);
				++lst;
			}
		else
			while (i < lst) {
				L = D->Prev (L);
				--lst;
			}
	else
		if (i < D->cnt / 2)
			for (L = D->Start, lst = 0; lst < i; lst++)
				L = D->Next (L);
		else
			for (L = D->End, lst = D->cnt - 1; lst > i; lst--)
				L = D->Prev (L);

	return L;
}

dlistArray::dlistArray (dlist *d)
{
	lst = -100;
	D = d;
	L = NULL;
}

unsigned int dlistArray::total ()
{
	return D->cnt;
}

int dlistArray::hint ()
{
	return lst;
}

//*******************************************
// A dbsTree interfaced with Array
//*******************************************

dbsArray::dbsArray (dbsTree *t)
{
	d = t;
	lst = -100;
}

char *dbsArray::cindex (int i)
{
	if (n && !d->mod && ((i > lst) ? (i - lst < 30) : (lst - i < 30)))
		if (i > lst)
			while (i > lst) {
				n = d->dbsNext (n);
				++lst;
			}
		else {
			while (i < lst) {
				n = d->dbsPrev (n);
				--lst;
			}
		}
	else n = (*d) [lst = i];

	d->mod = false;

	if (!n) return NULL;

	return ((dbsNodeStr*) n)->Name;
}

unsigned int dbsArray::total ()
{
	return d->nnodes;
}

int dbsArray::hint ()
{
	return lst;
}
