/******************************************************************************

	Drawables that expand dynamically.

	They must save unders, get private control of UserEvents, check
	their clicks in order and restore everything when closed.

	Pulldown expandleft menus.

******************************************************************************/
/**************************************************************************
 Copyright (C) 2000 Stelios Xantkakis
**************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "graphics.h"
#include "epil.h"
#include "popups.h"
#include "INIT.h"

//**************************************************************************

menu::menu ()
{ }

postdo *menu::P;


class menubreaker : public menu		// John Mayall's
{
	menu *M, *N;
	int from, sepfrom;
   public:
	menubreaker (menu*, int, int, menubreaker*);
	int separator (int);
	char *output (int);
	menu *input (int);
	bool expands (int);
virtual	~menubreaker ();
static	char oNext [];
};

char menubreaker::oNext [] = "More...";

menubreaker::menubreaker (menu *o, int f, int t, menubreaker *nx)
{
	M = o;
	from = f;
	n = t - from;
	N = nx;

	if (nx) {
		n++;
		sepfrom = nx->sepfrom;
		nsep = 1;
	} else {
		sepfrom = o->nsep;
		nsep = 0;
	}
	while (sepfrom && o->separator (--sepfrom) >= from) nsep++;
	if (o->separator (sepfrom) < from || sepfrom) ++sepfrom;

	reconstructable = from == 0;
}

char *menubreaker::output (int i)
{
	if (i < n - (N != NULL))
		return M->output (from + i);
	return oNext;
}

menu *menubreaker::input (int i)
{
	if (i < n - (N != NULL))
		return M->input (from + i);
	return N;
}

bool menubreaker::expands (int i)
{
	if (i < n - (N != NULL))
		return M->expands (from + i);
	return true;
}

int menubreaker::separator (int i)
{
	if (i < nsep - (N != NULL))
		return M->separator (sepfrom + i) - from;
	return n - 2;
}

menubreaker::~menubreaker ()
{
	if (N) delete N;
}



static menu *breakmenu (menu *m, int from, int to, int Segsize)
{
	if (from == 0 && to <= Segsize) return m;

	if (to - from <= Segsize)
		return new menubreaker (m, from, to, NULL);

	return new menubreaker (m, from, from + Segsize - 1,
	(menubreaker*) breakmenu (m, from + Segsize - 1, m->n, Segsize));
}

//**************************************************************************

namespace gLevels {

static dlistAuto<drawable*> LevelList;

void addlevel (drawable *d)
{
	LevelList.add (d);
	JCursor::hide ();
	JCursor::Readline = NULL; 
}

void rmvlevel (drawable *d)
{
	dlistNode *n;

	for (n = LevelList.End; n; n = LevelList.Prev (n))
		if (LevelList.XFor (n) == d) break;

	if (n) LevelList.dremove (n);

	JCursor::hide ();
	JCursor::Readline = NULL; 
}

void tobase ()
{
	while (LevelList.cnt > 1)
		LevelList.dremove (LevelList.End);
}

void levelclick ()
{
	LevelList.XFor (LevelList.End)->onclick ();
}

void drawall ()
{
	dlistNode *n;

	for (n = LevelList.Start; n; n = LevelList.Next (n))
		LevelList.XFor (n)->draw ();
}

drawable *toplev ()
{
	return LevelList.XFor (LevelList.End);
}

}

//**************************************************************************
// glist
//  A vertical display of items.
//  items generated from class menu and separators too.
//  glist does not know what to do, it just sets the static clicked
//  number and returns true onclick(). The menu action will have to
//  be done after the menuhierarchy has closed. class postdo
//
//  Hack: clicked only interests us for the top glist.
//   if top glist not clicked then clicked=-1 and the rest of glists
//   just return. Now the top glist can know it is the topmost
//   and perform the "highlight item" effect with nailPointer().
//**************************************************************************

int glist::clicked;

glist::glist (menu *m, int f)
{
	font = f;
	M = m;
	unders = NULL;

	int i, j, k;
	for (j = i = 0; i < M->n; i++) {
		k = strlen (M->output (i));
		if (k > j) j = k;
	}
	W = fwidth (font) * (j + 2) + 2 * Bthick;
	H = fheight (font) * M->n + 2 * Bthick;
}

void glist::draw ()
{
#define COL_ARROW COL_YELLOW
	if (!unders) unders = SaveUnders (X, Y, W + 1, H + 1);

	if (!unders) {
		// Halt its existance in all dimensions
		W = H = 0;
		return;
	}

	fill_block (COL_LIGHTGREY);
	uperigram ();

	for (int i = 0; i < M->n; i++) {
		int h = fheight (font);
		int w = fwidth (font);
		drawstring (M->output (i), w, Bthick + h * i, font, COL_BLACK);
		if (M->expands (i)) {
			int y = 1 + Bthick + i * h + h / 2;
			int x = W - Bthick - 1;
			drawline (x, y, x - w, y + h / 4, COL_ARROW);
			drawline (x, y, x - w, y - h / 4, COL_ARROW);
		}
	}

	for (int i = 0; i < M->nsep; i++)
		hline (Bthick, 1 + (M->separator (i) + 1) * fheight (font),
		       W - 2 * Bthick);
}

bool glist::onclick ()
{
	if (clicked == -1) return checkclick ();

	if (!checkclick ()) {
		clicked = -1;
		return false;
	}

	int i = clickY - Y;

	if (i <= Bthick) clicked = 0;
	else clicked = (i - Bthick) / fheight (font);

	if (clicked >= M->n) clicked--;

	// highlight effect
	if (!M->expands (clicked)) {
		bdrawstring (M->output (clicked), fwidth (font),
			     Bthick + fheight (font) * clicked,
			     font, COL_YELLOW, COL_BLUE);
		while (nailPointer ());
	}

	return true;
}

glist::~glist ()
{
	if (unders) {
		RestoreUnders (unders);
		FreeUnders (unders);
	}

	if (M->reconstructable) delete M;
}

//**************************************************************************
// For now, menuhierarchy enters the menumode at its construction.
// The more generic way would be to explictly enter menumode.
// This popup is supposed to be allocated as an automatic object
// and all the menu popup procedure will be in the scope of a function.
//**************************************************************************

menuhierarchy::menuhierarchy (menu *m, int x, int y, int w, int h, int f, int ox, int oy) : drawable (x, y, w, h)
{
	glist *g;

	maxY = (H - 2 * Bthick) / fheight (font = f);
	g = new glist (breakmenu (m, 0, m->n, maxY), font);
	if (ox + g->W > X + W) ox = X + W - g->W;
	if (oy + g->H > Y + H) oy = Y + H - g->H;
	g->setXY (ox, oy);
	pathList.add (g);
	Closed = false;
	goleft = false;

	draw ();
	menumode ();
}

void menuhierarchy::menumode ()
{
	Gflush ();

	gLevels::addlevel (this);
	while (!ExitRequested && !Closed)
		UserEvents (this);
	gLevels::rmvlevel (this);

	delete GLIST (pathList.Start);
	pathList.dremove (pathList.Start);

	if (menu::P) menu::P->Do ();

	menu::P = NULL;
}

void menuhierarchy::draw ()
{
	dlistNode *n;
	for (n = pathList.Start; n; n = pathList.Next (n))
		GLIST (n)->draw ();
}

void menuhierarchy::newglist (menu *m)
{
	// other case
	glist *p = GLIST (pathList.End);
	glist *g = new glist (breakmenu (m, 0, m->n, maxY), font);

	int x, y;

	// calculate Y.
	y = p->Y + glist::clicked * fheight (font);
	if (y + g->H > Y + H) {
		y -= g->H - fheight (font);
		if (y < Y) y = Y + (H - g->H) / 2;
	}

	// calculate X.
	if (goleft) {
		x = p->X - g->W;
		if (x < X) {
			x = p->X + p->W - 1;
			goleft = false;
		}
	} else {
		x = p->X + p->W - 1;
		if (x + g->W > X + W) {
			x = p->X - g->W;
			goleft = true;
		}
	}

	g->setXY (x, y);

	pathList.add (g);

	g->draw ();
}

void menuhierarchy::closeto (dlistNode *n)
{
	dlistNode *d = pathList.End;

	while (d != n) {
		delete GLIST (d);
		d = pathList.Prev (d);
		pathList.dremove (pathList.Next (d));
	}
}

bool menuhierarchy::onclick ()
{
	dlistNode *n;
	menu *m;

	// activate highlight hack
	glist::clicked = 0;

	// test glists in order
	for (n = pathList.End; n; n = pathList.Prev (n))
		if (GLIST (n)->onclick ()) break;

	if (!n) {	// none clicked
		Closed = true;
		closeto (pathList.Start);
		return false;
	}

	if (n != pathList.End) {	// no toplevel clicked
		closeto (n);
		return true;
	}
 
	// a menu may state that it expands() but still we need
	// to check the menu* input because of failure to create submenu
	if ((m = GLIST (pathList.End)->M->input (glist::clicked)))
		newglist (m);		// expands submenu
	else {				// action
		Closed = true;
		if (pathList.Start)
			closeto (pathList.Start);
	}

	return true;
}

menuhierarchy::~menuhierarchy ()
{ }
