/*
 * util.c -- support for the Logic Analyser program
 * 
 * Copyrigth (C) 1997 Nuno Sucena ( slug@student.dee.uc.pt )
 * 
 */

#include <asm/io.h>
#include <stdlib.h>
#include <stdio.h>
#include "forms.h"
#include "analyzer.h"
#include "util.h"

int channels = DEFAULT_CHANNELS;
double frequency = DEFAULT_FREQUENCY;
long int port = DEFAULT_PORT ;
short int OK=1;

int get_bit ( int value , int bit )
{
   if (( bit >= 1 ) && ( bit <= 8 )) 
     return ( (value >> ( bit -1 )) & 1);
       else
     return ( 0);
}

int read_port ( int port )
/*
 * port - value which contains the port were the function is goind to read
 *        the data.
 */

{
   int valor;
   /* if ( ioperm ( port,1,1) == -1 )
     *     {
	fprintf(stderr,"Error accessing I/O Port 0x%x !\n", port); */
   if ( OK ) 
     return ( 0 );
   else
     {
	valor = inb ( port );
/*	ioperm ( port,1,0); */
	return ( valor ) ;
     }
}


void shift_values ( float *yy_ee[MAX_PONTOS] )
{
   long int n;
   for ( n = 0 ; n < MAX_PONTOS ; n++)
     {
	yy_ee [n-1] = yy_ee [n];
     }
   yy_ee [ MAX_PONTOS ] = 0 ;
}

void init_values ( float *yy_ee[MAX_PONTOS] )
{
   long int n;
   for ( n = 0 ; n < MAX_PONTOS; n++ ) yy_ee [ n ] = 0;
}

void init_choice (  FD_LAnalyser *form )
/* Inits the Port Choice Object */
{
   long int n;
   char string[10];
   for ( n = MIN_PORT ; n <= MAX_PORT ;n++)
     {
	sprintf ( string , "0x%lx" , n );
	fl_addto_choice( form->Port, string);
     }
}

