/*
 * analyzer_cb.c -- CallBack routines  for the Logic Analyser program
 * 
 * Copyrigth (C) 1997 Nuno Sucena ( slug@student.dee.uc.pt )
 * 
 */

#include "forms.h"
#include "analyzer.h"
#include "util.h"

/* callbacks for form LAnalyser */

void Menu_Port ( FL_OBJECT *ob, long data)
{
   int choice;
   choice= fl_get_choice(ob);
   if ( choice == 0 )
     port = MIN_PORT;
   else
     port = MIN_PORT + choice -1 ; 
}

void Contador(FL_OBJECT *ob, long data)
{
   FD_LAnalyser *fd_temp = ob->form->fdui;
   static int values[MAX_PONTOS];
   static long int counter=0;
   int value, end_value , i_end_value, valor_bit, bit, n;
   char blabla[100];
   float xx[MAX_PONTOS], yy[MAX_PONTOS];
   fl_freeze_form( fd_temp->LAnalyser);
   if ( ob == fd_temp->Contador )
     {
	fl_clear_browser(fd_temp->Texto);
	value = read_port ( port );
	for ( n = 0 ; n < MAX_PONTOS ; n++) 
	  {
	     xx[n] = n + 1; /* inicializa as coordenadas no eixo dos X's */
	     if ( n < ( MAX_PONTOS -1 )) values[n] = values [ n + 1 ]; /* deslocamento para a esquerda dos valores lidos do porto de entrada */
	  }
	values[ MAX_PONTOS -1 ] = value ;
	sprintf ( blabla, "Port : %ld ( 0x%lx )\nInput  : %03d ( 0x%02x )\n!Input : %03d ( 0x%02x )\nCount : %ld\n",
		 port, port , value , value ,  255 - value ,  255 - value ,  ++counter );
	fl_addto_browser(fd_temp->Texto, blabla);
	/*	shift_values ( yy ); */
#ifdef CONTADOR_REFRESH
	fl_clear_xyplot(fd_temp->Display_Graphic);
	fl_set_xyplot_xbounds(fd_temp->Display_Graphic,0, MAX_PONTOS + 1 );
	fl_set_xyplot_ybounds(fd_temp->Display_Graphic,0, ( MAX_BIT_PORTS + 1 )*2  );
	/* fl_set_xyplot_ytics(fd_temp->Display_Graphic, 0 , 10 );
	 * fl_set_xyplot_ygrid(fd_temp->Display_Graphic, FL_GRID_MINOR); */
	/* fl_set_xyplot_xgrid(fd_temp->Display_Graphic, FL_GRID_MINOR); */
#endif
	end_value = 0;i_end_value = 0;
	for ( bit = 1; bit<=channels; bit++)
	  {
	     valor_bit = ( value >> ( bit - 1 )) & 1 ;
	     end_value = end_value  + (valor_bit << ( bit -1 ));
	     i_end_value = i_end_value + ( (1-valor_bit) << ( bit -1 ));
	     sprintf (blabla,"[Bit %d]:=%d   ~ := %d",bit,valor_bit, ! valor_bit);
	     fl_addto_browser(fd_temp->Texto, blabla);
	     for ( n = 0 ; n < MAX_PONTOS ; n++)
		  yy[n] = (( values [ n ] >> ( bit - 1 )) & 1) + bit*2;
	     if ( bit == 1 )
	       fl_set_xyplot_data ( fd_temp->Display_Graphic ,
				   xx , yy, MAX_PONTOS ,"", "", "");
	     else
	       fl_add_xyplot_overlay(fd_temp->Display_Graphic,
				     bit, xx, yy, MAX_PONTOS , bit);
	  }
	sprintf ( blabla , "\n\nValue  : %03d ( 0x%02x )\n!Value : %03d ( 0x%02x )", 
		 end_value , end_value , i_end_value , i_end_value );
	fl_addto_browser(fd_temp->Texto, blabla);
	fl_set_timer ( fd_temp->Contador, frequency );
     }
   if ( ob == fd_temp->Start ) fl_set_timer ( fd_temp->Contador, frequency );
   if ( ob == fd_temp->Resume ) fl_resume_timer ( fd_temp->Contador);
   if ( ob == fd_temp->Stop )fl_suspend_timer(fd_temp->Contador);
   if ( ob == fd_temp->Frequency ) fl_set_timer(fd_temp->Contador, frequency = fl_get_counter_value(ob));
   fl_unfreeze_form( fd_temp->LAnalyser);
}

void Version(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
   fl_show_message ( PROGRAM_NAME,
		    PROGRAM_AUTHOR,
		    AUTHOR_EMAIL);
}

void Exit(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
   if ( fl_show_question ( "Are you sure?", 0))
     {
	fl_finish();
	printf(" Program Terminated \n" );
	exit(0);
     }
}

void Sampling(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
   FD_LAnalyser *fd_temp = ob->form->fdui;
   fl_freeze_form(fd_temp->LAnalyser);
   if ( ob == fd_temp->Frequency )
     fl_set_timer(fd_temp->Contador, fl_get_counter_value(ob));
   if ( ob == fd_temp->Channels )
     channels = fl_get_counter_value(ob);
   fl_unfreeze_form(fd_temp->LAnalyser);
}


