/*
 * cliente_sock.c - Suport de rede para o cliente do IO256
 * 
 * (c) 1998 Nuno Sucena Almeida <slug@student.dee.uc.pt>
 * 
 */

#include <stdlib.h>
#include <stdio.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>

#include "config.h"
#include "cliente_sock.h"

char *V_servico;
char *V_endereco;

int cria_socket ( int *soquete , char *protocolo , char *servico ,
		 char *endereco , int tipo )
{
   struct protoent *Pprotocolo;
   struct servent *Pservico;
   struct sockaddr_in Endereco;
   int temp;
   if (( Pprotocolo = getprotobyname ( protocolo )) == NULL )
     {
	fprintf ( stderr , "Problem using protocol %s!\n" , protocolo );
	return ( ERRO);
     }
   if ( ( Pservico = getservbyname ( servico , Pprotocolo->p_name )) == NULL )
     {
	fprintf ( stderr , "Problem using service %s!\n" , servico );
	return ( ERRO);
     }
   if ( (*soquete = socket ( AF_INET , SOCK_STREAM , Pprotocolo->p_proto )) == -1 )
     {
	perror ("socket");
	return ( ERRO);
     }
   Endereco.sin_family = AF_INET;
   Endereco.sin_port = Pservico->s_port;
   Endereco.sin_addr.s_addr = inet_addr ( endereco );
   memset ( &(Endereco.sin_zero), 0 , sizeof ( Endereco.sin_zero ));
   switch ( tipo )
     {
      case BIND_TYPE:
	temp=1;
	setsockopt(*soquete, SOL_SOCKET, SO_REUSEADDR, &temp, sizeof(temp));
	if (bind( *soquete, (struct sockaddr *) &Endereco, sizeof(struct sockaddr)) == -1 )
	  {
	     perror ("bind");
	     return(ERRO);
	  }
	break;
      case CONNECT_TYPE:
	if (connect ( *soquete, (struct sockaddr *) &Endereco, sizeof(struct sockaddr)) == -1 )
	  {
	     perror ("connect");
	     return(ERRO);
	  }	
	break;
     }
   return (OK);
}

int envia_mensagem ( int soquete , char *mensagem )
{
   int comprimento;
   switch ( comprimento = send ( soquete , mensagem , strlen (mensagem) ,0 ))
     {
      case -1:
	perror("send");
	return (ERRO);
      default:
	if (comprimento == strlen(mensagem))
	  return(OK);
	else
	  return (ERRO);
     };
}

char *nome_maquina ( int soquete )
{
   struct sockaddr_in endereco;
   struct hostent *hostname;
   int comprimento = sizeof ( struct sockaddr_in );
   if ( getpeername ( soquete , (struct sockaddr *)&endereco, &comprimento))
     {
	perror("getpeername");
	return(NULL);
     }
   else
     if ( (hostname = gethostbyaddr ( (char *)&endereco.sin_addr ,sizeof(struct in_addr ),AF_INET ))==NULL)
     {
	herror(inet_ntoa(endereco.sin_addr));
	return(NULL);
     }
   else
     return((char*)strdup(hostname->h_name));
}

char *endereco_maquina ( int soquete )
{
   struct sockaddr_in endereco;
   int comprimento = sizeof ( struct sockaddr_in );
   if ( getpeername ( soquete , (struct sockaddr *)&endereco, &comprimento))
     {
	perror("getpeername");
	return(NULL);
     }
   else return ( strdup ( inet_ntoa ( endereco.sin_addr )));
}
