\name{rk.rkh.settings}
\alias{rk.rkh.settings}
\title{Create XML "settings" node for RKWard help pages}
\usage{
  rk.rkh.settings(...)
}
\arguments{
  \item{...}{Objects of class \code{XiMpLe.node}. They must
  all have the name "setting" or "caption".}
}
\value{
  An object of class \code{XiMpLe.node}.
}
\description{
  This function will create a settings node for the
  document section, with optional child nodes "setting" and
  "caption".
}
\examples{
# define a sample frame
test.dropdown <- rk.XML.dropdown("mydrop",
  options=list("First Option"=c(val="val1"),
  "Second Option"=c(val="val2", chk=TRUE)))
test.frame <- rk.XML.frame(test.dropdown, label="Some options")
# create the caption
test.caption <- rk.rkh.caption(test.frame)
test.setting <- rk.rkh.setting(test.dropdown, text="Chose one of the options.")
test.settings <- rk.rkh.settings(list(test.caption, test.setting))
}
\seealso{
  \code{\link[rkwarddev:rk.rkh.doc]{rk.rkh.doc}},
  \code{\link[rkwarddev:rk.rkh.setting]{rk.rkh.setting}},
  \code{\link[rkwarddev:rk.rkh.caption]{rk.rkh.caption}},
  and the \href{help:rkwardplugins}{Introduction to Writing
  Plugins for RKWard}
}

