\name{rk.paste.JS.graph}
\alias{rk.paste.JS.graph}
\title{Paste simple JavaScript plot code}
\usage{
  rk.paste.JS.graph(..., plotOpts = NULL,
    printoutObj = NULL, level = 2, indent.by = "\t",
    empty.e = FALSE)
}
\arguments{
  \item{...}{The actual plot code, passed through to
  \code{rk.paste.JS}.}

  \item{plotOpts}{An object generated by
  \code{rk.XML.embed} or \code{rk.plotOptions}, i.e.
  embedded plot options.}

  \item{printoutObj}{An \code{rk.JS.var} object fetching
  the \code{"code.printout"} modifier of \code{plotOpts}
  (see examples below!). If \code{NULL} and \code{plotOpts}
  is of class \code{rk.plot.opts} (as returned by
  \code{rk.plotOptions}), will be fetched from
  \code{plotOpts} automatically.}

  \item{level}{Integer, which indentation level to use,
  minimum is 1.}

  \item{indent.by}{A character string defining the
  indentation string to use.}

  \item{empty.e}{For \code{rk.JS.ite} objects only:
  Logical, if \code{TRUE} will force to add empty
  \code{else \{\}} brackets when there is no \code{else}
  statement defined, which is considered to enhance code
  readability by some.}
}
\value{
  A character string.
}
\description{
  This function is similar to \code{rk.paste.JS}, but adds
  some code parts to its output which are commonly used to
  generate plots with RKWard.
}
\details{
  The contents of the \code{...} argument are evaluated by
  \code{rk.paste.JS} and encapsulated between
  \code{if(full)\{rk.graph.on()\} try(\{} and \code{\})
  if(full)\{rk.graph.off()\}}. If generic plot options are
  supplied, their \code{"code.preprocess"} and
  \code{"code.calculate"} modifiers are also automatically
  taken care of, so you only need to include
  \code{"code.printout"} inside of \code{...}.
}
\examples{
tmp.var.selectVars <- rk.XML.varselector(label="Select data")
tmp.var.x <- rk.XML.varslot(label="My data", source=tmp.var.selectVars, required=TRUE)
# let this be the embedded generic plot options in yout plot dialog
tmp.plot.options <- rk.plotOptions()

# you can now generate the plot code using generic plot options
js.prnt <- rk.paste.JS.graph(
	echo("\\t\\tplot("),
	echo("\\n\\t\\t\\tx=", tmp.var.x),
	echo(tmp.plot.options),
	echo(")"),
	plotOpts=tmp.plot.options)

cat(js.prnt)
}
\seealso{
  \code{\link[rkwarddev:rk.paste.JS]{rk.paste.JS}}
}

