\name{rk.XML.menu}
\alias{rk.XML.menu}
\title{Create XML "menu" node for RKWard plugins}
\usage{
  rk.XML.menu(label, ..., index = -1, id.name = "auto")
}
\arguments{
  \item{label}{Character string, a label for the menu.}

  \item{...}{Eithet objects of class \code{XiMpLe.node},
  must be either "menu" or "entry", or a list of character
  strings representing the menu path, with the last element
  being the \code{component} value for
  \code{\link[rkwarddev:rk.XML.entry]{rk.XML.entry}}.}

  \item{index}{Integer number to influence the level of
  menu placement. If \code{...} is a list, \code{index} can
  also be a vector of the same length + 1, so indices will
  be set in the same order to the menu levels, the last
  value is for the entry.}

  \item{id.name}{Character, a unique ID for this plugin
  element.  If \code{"auto"}, an ID will be generated
  automatically from the label. Otherwise, if \code{...} is
  a list, \code{id.name} must have the same length and will
  be set in the same order to the menu levels.  Used to
  place the menu in the global menu hierarchy.}
}
\value{
  An object of class \code{XiMpLe.node}.
}
\description{
  This function will create a menu node for hierarchy
  sections. Use same \code{id} values to place entries in
  the same menu.
}
\examples{
test.component <- rk.XML.component("My GUI dialog", "plugins/MyGUIdialog.xml")
test.entry <- rk.XML.entry(test.component)
test.menu <- rk.XML.menu("Analysis", test.entry, id.name="analysis")
cat(pasteXML(test.menu))
# manual definition of a menu path by a list:
test.menu <- rk.XML.menu("Analysis", list("Level 1", "Level 2", test.component))
}
\seealso{
  \code{\link[rkwarddev:rk.XML.hierarchy]{rk.XML.hierarchy}},
  \code{\link[rkwarddev:rk.XML.entry]{rk.XML.entry}},
  \code{\link[rkwarddev:rk.XML.component]{rk.XML.component}},
  \code{\link[rkwarddev:rk.XML.components]{rk.XML.components}},
  and the \href{help:rkwardplugins}{Introduction to Writing
  Plugins for RKWard}
}

