/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.parfor.DataPartitioner;
import org.apache.sysds.runtime.controlprogram.parfor.util.Cell;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysds.runtime.controlprogram.parfor.util.StagingFileUtils;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixCell;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.util.FastStringTokenizer;
import org.apache.sysds.runtime.util.LocalFileUtils;

public class DataPartitionerLocal
extends DataPartitioner {
    private static final boolean PARALLEL = true;
    private IDSequence _seq = null;
    private MatrixBlock _reuseBlk = null;
    private int _par = -1;

    public DataPartitionerLocal(ParForProgramBlock.PartitionFormat dpf, int par) {
        super(dpf._dpf, dpf._N);
        if (dpf.isBlockwise()) {
            throw new DMLRuntimeException("Data partitioning formt '" + dpf + "' not supported by DataPartitionerLocal");
        }
        this._seq = new IDSequence();
        this._par = par > 0 ? par : 1;
    }

    @Override
    protected void partitionMatrix(MatrixObject in, String fnameNew, Types.FileFormat fmt, long rlen, long clen, int blen) {
        in.exportData();
        String fname = in.getFileName();
        String fnameStaging = LocalFileUtils.getUniqueWorkingDir("partitioning");
        if (fmt == Types.FileFormat.TEXT) {
            this.partitionTextCell(fname, fnameStaging, fnameNew, rlen, clen, blen);
        } else if (fmt == Types.FileFormat.BINARY) {
            this.partitionBinaryBlock(fname, fnameStaging, fnameNew, rlen, clen, blen);
        } else {
            throw new DMLRuntimeException("Cannot create data partitions of format: " + fmt.toString());
        }
        LocalFileUtils.cleanupWorkingDirectory(fnameStaging);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void partitionTextCell(String fname, String fnameStaging, String fnameNew, long rlen, long clen, int blen) {
        long row = -1L;
        long col = -1L;
        try {
            JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
            Path path = new Path(fname);
            FileInputFormat.addInputPath((JobConf)job, (Path)path);
            TextInputFormat informat = new TextInputFormat();
            informat.configure(job);
            InputSplit[] splits = informat.getSplits(job, 1);
            LinkedList<Cell> buffer = new LinkedList<Cell>();
            LongWritable key = new LongWritable();
            Text value = new Text();
            FastStringTokenizer st = new FastStringTokenizer(' ');
            for (InputSplit split : splits) {
                RecordReader reader = informat.getRecordReader(split, job, Reporter.NULL);
                try {
                    while (reader.next((Object)key, (Object)value)) {
                        st.reset(value.toString());
                        row = st.nextLong();
                        col = st.nextLong();
                        double lvalue = st.nextDouble();
                        Cell tmp = new Cell(row, col, lvalue);
                        buffer.addLast(tmp);
                        if (buffer.size() <= 100000) continue;
                        this.appendCellBufferToStagingArea(fnameStaging, buffer, blen);
                        buffer.clear();
                    }
                    if (buffer.isEmpty()) continue;
                    this.appendCellBufferToStagingArea(fnameStaging, buffer, blen);
                    buffer.clear();
                }
                finally {
                    IOUtilFunctions.closeSilently(reader);
                }
            }
            String[] fnamesPartitions = new File(fnameStaging).list();
            int len = Math.min(fnamesPartitions.length, this._par);
            Thread[] threads = new Thread[len];
            for (int i = 0; i < len; ++i) {
                int start = i * (int)Math.ceil((double)fnamesPartitions.length / (double)len);
                int end = (i + 1) * (int)Math.ceil((double)fnamesPartitions.length / (double)len) - 1;
                end = Math.min(end, fnamesPartitions.length - 1);
                threads[i] = new Thread(new DataPartitionerWorkerTextCell(job, fnameNew, fnameStaging, fnamesPartitions, start, end));
                threads[i].start();
            }
            for (Thread t : threads) {
                t.join();
            }
        }
        catch (Exception e) {
            if (row < 1L || row > rlen || col < 1L || col > clen) {
                throw new DMLRuntimeException("Matrix cell [" + row + "," + col + "] out of overall matrix range [1:" + rlen + ",1:" + clen + "].");
            }
            throw new DMLRuntimeException("Unable to partition text cell matrix.", e);
        }
    }

    private void partitionBinaryBlock(String fname, String fnameStaging, String fnameNew, long rlen, long clen, int blen) {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        try (FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);){
            this._reuseBlk = DataPartitioner.createReuseMatrixBlock(this._format, blen, blen);
            MatrixIndexes key = new MatrixIndexes();
            MatrixBlock value = new MatrixBlock();
            for (Path lpath : IOUtilFunctions.getSequenceFilePaths(fs, path)) {
                try (SequenceFile.Reader reader = new SequenceFile.Reader(fs, lpath, (Configuration)job);){
                    while (reader.next((Writable)key, (Writable)value)) {
                        long row_offset = (key.getRowIndex() - 1L) * (long)blen;
                        long col_offset = (key.getColumnIndex() - 1L) * (long)blen;
                        long rows = value.getNumRows();
                        long cols = value.getNumColumns();
                        if (row_offset + rows < 1L || row_offset + rows > rlen || col_offset + cols < 1L || col_offset + cols > clen) {
                            throw new IOException("Matrix block [" + (row_offset + 1L) + ":" + (row_offset + rows) + "," + (col_offset + 1L) + ":" + (col_offset + cols) + "] out of overall matrix range [1:" + rlen + ",1:" + clen + "].");
                        }
                        this.appendBlockToStagingArea(fnameStaging, value, row_offset, col_offset, blen);
                    }
                }
            }
            String[] fnamesPartitions = new File(fnameStaging).list();
            int len = Math.min(fnamesPartitions.length, this._par);
            Thread[] threads = new Thread[len];
            for (int i = 0; i < len; ++i) {
                int start = i * (int)Math.ceil((double)fnamesPartitions.length / (double)len);
                int end = (i + 1) * (int)Math.ceil((double)fnamesPartitions.length / (double)len) - 1;
                end = Math.min(end, fnamesPartitions.length - 1);
                threads[i] = new Thread(new DataPartitionerWorkerBinaryBlock(job, fnameNew, fnameStaging, fnamesPartitions, start, end));
                threads[i].start();
            }
            for (Thread t : threads) {
                t.join();
            }
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Unable to partition binary block matrix.", e);
        }
    }

    private void appendBlockToStagingArea(String dir, MatrixBlock mb, long row_offset, long col_offset, long blen) throws IOException {
        boolean sparse = mb.isInSparseFormat();
        long nnz = mb.getNonZeros();
        long rows = mb.getNumRows();
        long cols = mb.getNumColumns();
        double sparsity = (double)nnz / (double)(rows * cols);
        if (this._format == ParForProgramBlock.PDataPartitionFormat.ROW_WISE) {
            this._reuseBlk.reset(1, (int)cols, sparse, (int)((double)cols * sparsity));
            int i = 0;
            while ((long)i < rows) {
                String pdir = LocalFileUtils.checkAndCreateStagingDir(dir + "/" + (row_offset + 1L + (long)i));
                String pfname = pdir + "/block_" + (col_offset / blen + 1L);
                mb.slice(i, i, 0, (int)(cols - 1L), this._reuseBlk);
                LocalFileUtils.writeMatrixBlockToLocal(pfname, this._reuseBlk);
                this._reuseBlk.reset();
                ++i;
            }
        } else if (this._format == ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE) {
            String pdir = LocalFileUtils.checkAndCreateStagingDir(dir + "/" + (row_offset / blen + 1L));
            String pfname = pdir + "/block_" + (col_offset / blen + 1L);
            LocalFileUtils.writeMatrixBlockToLocal(pfname, mb);
        } else if (this._format == ParForProgramBlock.PDataPartitionFormat.COLUMN_WISE) {
            this._reuseBlk.reset((int)rows, 1, false);
            int i = 0;
            while ((long)i < cols) {
                String pdir = LocalFileUtils.checkAndCreateStagingDir(dir + "/" + (col_offset + 1L + (long)i));
                String pfname = pdir + "/block_" + (row_offset / blen + 1L);
                mb.slice(0, (int)(rows - 1L), i, i, this._reuseBlk);
                LocalFileUtils.writeMatrixBlockToLocal(pfname, this._reuseBlk);
                this._reuseBlk.reset();
                ++i;
            }
        } else if (this._format == ParForProgramBlock.PDataPartitionFormat.COLUMN_BLOCK_WISE) {
            String pdir = LocalFileUtils.checkAndCreateStagingDir(dir + "/" + (col_offset / blen + 1L));
            String pfname = pdir + "/block_" + (row_offset / blen + 1L);
            LocalFileUtils.writeMatrixBlockToLocal(pfname, mb);
        }
    }

    private void appendCellBufferToStagingArea(String dir, LinkedList<Cell> buffer, int blen) throws IOException {
        HashMap sortedBuffer = new HashMap();
        long key = -1L;
        for (Cell cell : buffer) {
            switch (this._format) {
                case ROW_WISE: {
                    key = cell.getRow();
                    cell.setRow(1L);
                    break;
                }
                case ROW_BLOCK_WISE: {
                    key = (cell.getRow() - 1L) / (long)blen + 1L;
                    cell.setRow((cell.getRow() - 1L) % (long)blen + 1L);
                    break;
                }
                case COLUMN_WISE: {
                    key = cell.getCol();
                    cell.setCol(1L);
                    break;
                }
                case COLUMN_BLOCK_WISE: {
                    key = (cell.getCol() - 1L) / (long)blen + 1L;
                    cell.setCol((cell.getCol() - 1L) % (long)blen + 1L);
                    break;
                }
            }
            if (!sortedBuffer.containsKey(key)) {
                sortedBuffer.put(key, new LinkedList());
            }
            ((LinkedList)sortedBuffer.get(key)).addLast(cell);
        }
        for (Map.Entry entry : sortedBuffer.entrySet()) {
            String pdir = LocalFileUtils.checkAndCreateStagingDir(dir + "/" + entry.getKey());
            String pfname = pdir + "/block_" + this._seq.getNextID();
            StagingFileUtils.writeCellListToLocal(pfname, (LinkedList)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBinaryBlockSequenceFileToHDFS(JobConf job, String dir, String lpdir, boolean threadsafe) throws IOException {
        long key = DataPartitionerLocal.getKeyFromFilePath(lpdir);
        Path path = new Path(dir + "/" + key);
        SequenceFile.Writer writer = IOUtilFunctions.getSeqWriter(path, (Configuration)job, 1);
        try {
            String[] fnameBlocks;
            for (String fnameBlock : fnameBlocks = new File(lpdir).list()) {
                long key2 = DataPartitionerLocal.getKey2FromFileName(fnameBlock);
                MatrixBlock tmp = null;
                tmp = threadsafe ? LocalFileUtils.readMatrixBlockFromLocal(lpdir + "/" + fnameBlock) : LocalFileUtils.readMatrixBlockFromLocal(lpdir + "/" + fnameBlock, this._reuseBlk);
                if (this._format == ParForProgramBlock.PDataPartitionFormat.ROW_WISE || this._format == ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE) {
                    writer.append((Writable)new MatrixIndexes(1L, key2), (Writable)tmp);
                    continue;
                }
                if (this._format != ParForProgramBlock.PDataPartitionFormat.COLUMN_WISE && this._format != ParForProgramBlock.PDataPartitionFormat.COLUMN_BLOCK_WISE) continue;
                writer.append((Writable)new MatrixIndexes(key2, 1L), (Writable)tmp);
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBinaryCellSequenceFileToHDFS(JobConf job, String dir, String lpdir) throws IOException {
        long key = DataPartitionerLocal.getKeyFromFilePath(lpdir);
        Path path = new Path(dir + "/" + key);
        SequenceFile.Writer writer = IOUtilFunctions.getSeqWriterCell(path, (Configuration)job, 1);
        try {
            String[] fnameBlocks;
            MatrixIndexes indexes = new MatrixIndexes();
            MatrixCell cell = new MatrixCell();
            for (String fnameBlock : fnameBlocks = new File(lpdir).list()) {
                LinkedList<Cell> tmp = StagingFileUtils.readCellListFromLocal(lpdir + "/" + fnameBlock);
                for (Cell c : tmp) {
                    indexes.setIndexes(c.getRow(), c.getCol());
                    cell.setValue(c.getValue());
                    writer.append((Writable)indexes, (Writable)cell);
                }
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
    }

    public void writeTextCellFileToHDFS(JobConf job, String dir, String lpdir) throws IOException {
        long key = DataPartitionerLocal.getKeyFromFilePath(lpdir);
        Path path = new Path(dir + "/" + key);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, true)));){
            String[] fnameBlocks;
            StringBuilder sb = new StringBuilder();
            for (String fnameBlock : fnameBlocks = new File(lpdir).list()) {
                LinkedList<Cell> tmp = StagingFileUtils.readCellListFromLocal(lpdir + "/" + fnameBlock);
                for (Cell c : tmp) {
                    sb.append(c.getRow());
                    sb.append(' ');
                    sb.append(c.getCol());
                    sb.append(' ');
                    sb.append(c.getValue());
                    sb.append('\n');
                    out.write(sb.toString());
                    sb.setLength(0);
                }
            }
        }
    }

    private static long getKeyFromFilePath(String dir) {
        String[] dirparts = dir.split("/");
        long key = Long.parseLong(dirparts[dirparts.length - 1]);
        return key;
    }

    private static long getKey2FromFileName(String fname) {
        return Long.parseLong(fname.split("_")[1]);
    }

    private class DataPartitionerWorkerBinaryBlock
    extends DataPartitionerWorker {
        public DataPartitionerWorkerBinaryBlock(JobConf job, String fnameNew, String fnameStaging, String[] fnamesPartitions, int start, int end) {
            super(job, fnameNew, fnameStaging, fnamesPartitions, start, end);
        }

        @Override
        public void writeFileToHDFS(JobConf job, String fnameNew, String stagingDir) throws IOException {
            DataPartitionerLocal.this.writeBinaryBlockSequenceFileToHDFS(job, fnameNew, stagingDir, true);
        }
    }

    private class DataPartitionerWorkerTextCell
    extends DataPartitionerWorker {
        public DataPartitionerWorkerTextCell(JobConf job, String fnameNew, String fnameStaging, String[] fnamesPartitions, int start, int end) {
            super(job, fnameNew, fnameStaging, fnamesPartitions, start, end);
        }

        @Override
        public void writeFileToHDFS(JobConf job, String fnameNew, String stagingDir) throws IOException {
            DataPartitionerLocal.this.writeTextCellFileToHDFS(job, fnameNew, stagingDir);
        }
    }

    private abstract class DataPartitionerWorker
    implements Runnable {
        private JobConf _job = null;
        private String _fnameNew = null;
        private String _fnameStaging = null;
        private String[] _fnamesPartitions = null;
        private int _start = -1;
        private int _end = -1;

        public DataPartitionerWorker(JobConf job, String fnameNew, String fnameStaging, String[] fnamesPartitions, int start, int end) {
            this._job = job;
            this._fnameNew = fnameNew;
            this._fnameStaging = fnameStaging;
            this._fnamesPartitions = fnamesPartitions;
            this._start = start;
            this._end = end;
        }

        @Override
        public void run() {
            try {
                for (int i = this._start; i <= this._end; ++i) {
                    String pdir = this._fnamesPartitions[i];
                    this.writeFileToHDFS(this._job, this._fnameNew, this._fnameStaging + "/" + pdir);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed on parallel data partitioning.", ex);
            }
        }

        public abstract void writeFileToHDFS(JobConf var1, String var2, String var3) throws IOException;
    }
}

