/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim.sample;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.estim.sample.HassAndStokes;
import org.apache.sysds.runtime.compress.estim.sample.ShlosserEstimator;
import org.apache.sysds.runtime.compress.estim.sample.ShlosserJackknifeEstimator;
import org.apache.sysds.runtime.compress.estim.sample.SmoothedJackknifeEstimator;

public class SampleEstimatorFactory {
    protected static final Log LOG = LogFactory.getLog((String)SampleEstimatorFactory.class.getName());

    public static int distinctCount(int[] frequencies, int nRows, int sampleSize, EstimationType type, HashMap<Integer, Double> solveCache) {
        int numVals = frequencies.length;
        try {
            int[] invHist = SampleEstimatorFactory.getInvertedFrequencyHistogram(frequencies);
            switch (type) {
                case HassAndStokes: {
                    return HassAndStokes.distinctCount(numVals, invHist, nRows, sampleSize, solveCache);
                }
                case ShlosserEstimator: {
                    return ShlosserEstimator.distinctCount(numVals, invHist, nRows, sampleSize);
                }
                case ShlosserJackknifeEstimator: {
                    return ShlosserJackknifeEstimator.distinctCount(numVals, frequencies, invHist, nRows, sampleSize);
                }
                case SmoothedJackknifeEstimator: {
                    return SmoothedJackknifeEstimator.distinctCount(numVals, invHist, nRows, sampleSize);
                }
            }
            throw new NotImplementedException("Type not yet supported for counting distinct: " + (Object)((Object)type));
        }
        catch (Exception e) {
            throw new DMLCompressionException("Error while estimating distinct count with arguments:\n" + numVals + " frequencies:\n" + Arrays.toString(frequencies) + "\n nrows: " + nRows + " " + sampleSize + " type: " + (Object)((Object)type), e);
        }
    }

    private static int[] getInvertedFrequencyHistogram(int[] frequencies) {
        int numVals = frequencies.length;
        int maxCount = 0;
        for (int i = 0; i < numVals; ++i) {
            int v = frequencies[i];
            if (v <= maxCount) continue;
            maxCount = v;
        }
        int[] freqCounts = new int[maxCount];
        for (int i = 0; i < numVals; ++i) {
            if (frequencies[i] == 0) continue;
            int n = frequencies[i] - 1;
            freqCounts[n] = freqCounts[n] + 1;
        }
        return freqCounts;
    }

    public static enum EstimationType {
        HassAndStokes,
        ShlosserEstimator,
        ShlosserJackknifeEstimator,
        SmoothedJackknifeEstimator;

    }
}

