/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cocode;

import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cocode.AColumnCoCoder;
import org.apache.sysds.runtime.compress.cocode.CoCodeBinPacking;
import org.apache.sysds.runtime.compress.cocode.CoCodeGreedy;
import org.apache.sysds.runtime.compress.cocode.CoCodeHybrid;
import org.apache.sysds.runtime.compress.cocode.CoCodePriorityQue;
import org.apache.sysds.runtime.compress.cocode.CoCodeStatic;
import org.apache.sysds.runtime.compress.cost.ICostEstimate;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;

public class CoCoderFactory {
    public static CompressedSizeInfo findCoCodesByPartitioning(CompressedSizeEstimator est, CompressedSizeInfo colInfos, int k, ICostEstimate costEstimator, CompressionSettings cs) {
        CompressedSizeInfo bins = CoCoderFactory.createColumnGroupPartitioner(cs.columnPartitioner, est, costEstimator, cs).coCodeColumns(colInfos, k);
        return bins;
    }

    private static AColumnCoCoder createColumnGroupPartitioner(PartitionerType type, CompressedSizeEstimator est, ICostEstimate costEstimator, CompressionSettings cs) {
        switch (type) {
            case AUTO: {
                return new CoCodeHybrid(est, costEstimator, cs);
            }
            case GREEDY: {
                return new CoCodeGreedy(est, costEstimator, cs);
            }
            case BIN_PACKING: {
                return new CoCodeBinPacking(est, costEstimator, cs);
            }
            case STATIC: {
                return new CoCodeStatic(est, costEstimator, cs);
            }
            case PRIORITY_QUE: {
                return new CoCodePriorityQue(est, costEstimator, cs);
            }
        }
        throw new RuntimeException("Unsupported column group partitioner: " + type.toString());
    }

    public static enum PartitionerType {
        BIN_PACKING,
        STATIC,
        PRIORITY_QUE,
        GREEDY,
        AUTO;

    }
}

