/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.hops.HopsException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.meta.DataCharacteristics;

public class OutputParameters {
    private boolean _blocked = true;
    private long _num_rows = -1L;
    private long _num_cols = -1L;
    private long _nnz = -1L;
    private MatrixObject.UpdateType _updateType = MatrixObject.UpdateType.COPY;
    private long _blocksize = -1L;
    private String _file_name = null;
    private String _file_label = null;
    private boolean _linCacheCandidate = true;
    private long _compressedSize = -1L;
    Types.FileFormat matrix_format = Types.FileFormat.BINARY;

    public String getFile_name() {
        return this._file_name;
    }

    public void setFile_name(String fileName) {
        this._file_name = fileName;
    }

    public String getLabel() {
        return this._file_label;
    }

    public void setLabel(String label) {
        this._file_label = label;
    }

    public void setDimensions(DataCharacteristics dc) {
        this.setDimensions(dc.getRows(), dc.getCols(), dc.getBlocksize(), dc.getNonZeros());
    }

    public void setDimensions(long rows, long cols, long blen, long nnz) {
        this.setDimensions(rows, cols, blen, nnz, -1L);
    }

    public void setDimensions(long rows, long cols, long blen, long nnz, long compressedSize) {
        this._num_rows = rows;
        this._num_cols = cols;
        this._nnz = nnz;
        this._blocksize = blen;
        this._compressedSize = compressedSize;
        if (this._blocksize == 0L || this._blocksize == -1L) {
            this._blocked = false;
        } else if (this._blocksize > 0L) {
            this._blocked = true;
        } else {
            throw new HopsException("In OutputParameters Lop, Invalid values for blocking dimensions: [" + this._blocksize + "," + this._blocksize + "].");
        }
    }

    public void setDimensions(long rows, long cols, long blen, long nnz, MatrixObject.UpdateType update) {
        this._updateType = update;
        this.setDimensions(rows, cols, blen, nnz);
    }

    public void setDimensions(long rows, long cols, long blen, long nnz, MatrixObject.UpdateType update, long compressedSize) {
        this._updateType = update;
        this.setDimensions(rows, cols, blen, nnz, compressedSize);
    }

    public void setDimensions(long rows, long cols, long blen, long nnz, boolean linCacheCand) {
        this._linCacheCandidate = linCacheCand;
        this.setDimensions(rows, cols, blen, nnz);
    }

    public void setDimensions(OutputParameters input) {
        this._num_rows = input._num_rows;
        this._num_cols = input._num_cols;
        this._blocksize = input._blocksize;
    }

    public Types.FileFormat getFormat() {
        return this.matrix_format;
    }

    public void setFormat(Types.FileFormat fmt) {
        this.matrix_format = fmt;
    }

    public boolean isBlocked() {
        return this._blocked;
    }

    public void setBlocked(boolean blocked) {
        this._blocked = blocked;
    }

    public long getNumRows() {
        return this._num_rows;
    }

    public void setNumRows(long rows) {
        this._num_rows = rows;
    }

    public long getNumCols() {
        return this._num_cols;
    }

    public void setNumCols(long cols) {
        this._num_cols = cols;
    }

    public long getNnz() {
        return this._nnz;
    }

    public void setNnz(long nnz) {
        this._nnz = nnz;
    }

    public long getCompressedSize() {
        return this._compressedSize;
    }

    public void setCompressedSize(long size) {
        this._compressedSize = size;
    }

    public MatrixObject.UpdateType getUpdateType() {
        return this._updateType;
    }

    public void setUpdateType(MatrixObject.UpdateType update) {
        this._updateType = update;
    }

    public boolean getLinCacheMarking() {
        return this._linCacheCandidate;
    }

    public long getBlocksize() {
        return this._blocksize;
    }

    public void setBlocksize(long blen) {
        this._blocksize = blen;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("rows=" + this.getNumRows() + "\u00b7");
        sb.append("cols=" + this.getNumCols() + "\u00b7");
        sb.append("nnz=" + this.getNnz() + "\u00b7");
        sb.append("updateInPlace=" + this.getUpdateType().toString() + "\u00b7");
        sb.append("blocksize=" + this.getBlocksize() + "\u00b7");
        sb.append("isBlockedRepresentation=" + this.isBlocked() + "\u00b7");
        sb.append("format=" + (Object)((Object)this.getFormat()) + "\u00b7");
        sb.append("label=" + this.getLabel() + "\u00b7");
        sb.append("filename=" + this.getFile_name() + "\u00b7");
        sb.append("compressedSize=" + this.getCompressedSize());
        return sb.toString();
    }
}

