/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cocode;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cocode.AColumnCoCoder;
import org.apache.sysds.runtime.compress.cost.ICostEstimate;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;

public class CoCodePriorityQue
extends AColumnCoCoder {
    protected CoCodePriorityQue(CompressedSizeEstimator sizeEstimator, ICostEstimate costEstimator, CompressionSettings cs) {
        super(sizeEstimator, costEstimator, cs);
    }

    @Override
    protected CompressedSizeInfo coCodeColumns(CompressedSizeInfo colInfos, int k) {
        colInfos.setInfo(CoCodePriorityQue.join(colInfos.getInfo(), this._sest, this._cest, 1));
        return colInfos;
    }

    protected static List<CompressedSizeInfoColGroup> join(List<CompressedSizeInfoColGroup> currentGroups, CompressedSizeEstimator sEst, ICostEstimate cEst, int minNumGroups) {
        Comparator<CompressedSizeInfoColGroup> comp = Comparator.comparing(x -> cEst.getCostOfColumnGroup((CompressedSizeInfoColGroup)x));
        PriorityQueue<CompressedSizeInfoColGroup> que = new PriorityQueue<CompressedSizeInfoColGroup>(currentGroups.size(), comp);
        ArrayList<CompressedSizeInfoColGroup> ret = new ArrayList<CompressedSizeInfoColGroup>();
        for (CompressedSizeInfoColGroup g : currentGroups) {
            if (g == null) continue;
            que.add(g);
        }
        CompressedSizeInfoColGroup l = null;
        l = (CompressedSizeInfoColGroup)que.poll();
        int groupNr = ret.size() + que.size();
        while (que.peek() != null && groupNr >= minNumGroups) {
            CompressedSizeInfoColGroup r = (CompressedSizeInfoColGroup)que.peek();
            CompressedSizeInfoColGroup g = sEst.estimateJoinCompressedSize(l, r);
            if (g != null) {
                double costIndividual;
                double costOfJoin = cEst.getCostOfColumnGroup(g);
                if (costOfJoin < (costIndividual = cEst.getCostOfColumnGroup(l) + cEst.getCostOfColumnGroup(r))) {
                    que.poll();
                    int numColumns = g.getColumns().length;
                    if (minNumGroups != 0 && numColumns > 8) {
                        ret.add(g);
                    } else if (numColumns > 128) {
                        ret.add(g);
                    } else {
                        que.add(g);
                    }
                } else {
                    ret.add(l);
                }
            } else {
                ret.add(l);
            }
            l = (CompressedSizeInfoColGroup)que.poll();
            groupNr = ret.size() + que.size();
        }
        if (l != null) {
            ret.add(l);
        }
        for (CompressedSizeInfoColGroup g : que) {
            ret.add(g);
        }
        return ret;
    }
}

