/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.functionobjects;

import org.apache.sysml.runtime.functionobjects.IndexFunction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;

public class OffsetColumnIndex
extends IndexFunction {
    private static final long serialVersionUID = 1523769994005450946L;
    private int offset;
    private int numRowsInOutput;
    private int numColumnsInOutput;

    private OffsetColumnIndex(int offset) {
        this.offset = offset;
    }

    public static OffsetColumnIndex getOffsetColumnIndexFnObject(int offset) {
        return new OffsetColumnIndex(offset);
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public void execute(MatrixIndexes in, MatrixIndexes out) {
        out.setIndexes(in.getRowIndex(), in.getColumnIndex() + (long)this.offset);
    }

    @Override
    public void execute(MatrixValue.CellIndex in, MatrixValue.CellIndex out) {
        out.row = in.row;
        out.column = this.offset + in.column;
    }

    @Override
    public boolean computeDimension(int row, int col, MatrixValue.CellIndex retDim) {
        retDim.set(this.numRowsInOutput, this.numColumnsInOutput);
        return false;
    }

    @Override
    public boolean computeDimension(MatrixCharacteristics in, MatrixCharacteristics out) {
        out.set(this.numRowsInOutput, this.numColumnsInOutput, in.getRowsPerBlock(), in.getColsPerBlock());
        return false;
    }
}

