/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.jmlc;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.api.ConfigurableAPI;
import org.apache.sysml.api.DMLException;
import org.apache.sysml.api.jmlc.ResultVariables;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.ipa.FunctionCallGraph;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaDataFormat;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.util.DataConverter;
import org.apache.sysml.utils.Explain;
import org.apache.sysml.utils.Statistics;

public class PreparedScript
implements ConfigurableAPI {
    private static final Log LOG = LogFactory.getLog((String)PreparedScript.class.getName());
    private final HashSet<String> _inVarnames;
    private final HashSet<String> _outVarnames;
    private final HashMap<String, Data> _inVarReuse;
    private final Program _prog;
    private final LocalVariableMap _vars;
    private final DMLConfig _dmlconf;
    private final CompilerConfig _cconf;

    private PreparedScript(PreparedScript that) {
        this._prog = that._prog.clone(false);
        this._vars = new LocalVariableMap();
        for (Map.Entry<String, Data> e : that._vars.entrySet()) {
            this._vars.put(e.getKey(), e.getValue());
        }
        this._vars.setRegisteredOutputs(that._outVarnames);
        this._inVarnames = that._inVarnames;
        this._outVarnames = that._outVarnames;
        this._inVarReuse = new HashMap<String, Data>(that._inVarReuse);
        this._dmlconf = that._dmlconf;
        this._cconf = that._cconf;
    }

    protected PreparedScript(Program prog, String[] inputs, String[] outputs, DMLConfig dmlconf, CompilerConfig cconf) {
        this._prog = prog;
        this._vars = new LocalVariableMap();
        this._inVarnames = new HashSet();
        Collections.addAll(this._inVarnames, inputs);
        this._outVarnames = new HashSet();
        Collections.addAll(this._outVarnames, outputs);
        this._inVarReuse = new HashMap();
        this._vars.setRegisteredOutputs(this._outVarnames);
        this._dmlconf = dmlconf;
        this._cconf = cconf;
    }

    @Override
    public void resetConfig() {
        this._dmlconf.set(new DMLConfig());
    }

    @Override
    public void setConfigProperty(String propertyName, String propertyValue) {
        try {
            this._dmlconf.setTextValue(propertyName, propertyValue);
        }
        catch (DMLRuntimeException e) {
            throw new RuntimeException(e);
        }
    }

    public DMLConfig getDMLConfig() {
        return this._dmlconf;
    }

    public CompilerConfig getCompilerConfig() {
        return this._cconf;
    }

    public void setScalar(String varname, boolean scalar) {
        this.setScalar(varname, scalar, false);
    }

    public void setScalar(String varname, boolean scalar, boolean reuse) {
        this.setScalar(varname, new BooleanObject(scalar), reuse);
    }

    public void setScalar(String varname, long scalar) {
        this.setScalar(varname, scalar, false);
    }

    public void setScalar(String varname, long scalar, boolean reuse) {
        this.setScalar(varname, new IntObject(scalar), reuse);
    }

    public void setScalar(String varname, double scalar) {
        this.setScalar(varname, scalar, false);
    }

    public void setScalar(String varname, double scalar, boolean reuse) {
        this.setScalar(varname, new DoubleObject(scalar), reuse);
    }

    public void setScalar(String varname, String scalar) {
        this.setScalar(varname, scalar, false);
    }

    public void setScalar(String varname, String scalar, boolean reuse) {
        this.setScalar(varname, new StringObject(scalar), reuse);
    }

    public void setScalar(String varname, ScalarObject scalar, boolean reuse) {
        if (!this._inVarnames.contains(varname)) {
            throw new DMLException("Unspecified input variable: " + varname);
        }
        this._vars.put(varname, scalar);
    }

    public void setMatrix(String varname, double[][] matrix) {
        this.setMatrix(varname, matrix, false);
    }

    public void setMatrix(String varname, double[][] matrix, boolean reuse) {
        this.setMatrix(varname, DataConverter.convertToMatrixBlock(matrix), reuse);
    }

    public void setMatrix(String varname, MatrixBlock matrix, boolean reuse) {
        if (!this._inVarnames.contains(varname)) {
            throw new DMLException("Unspecified input variable: " + varname);
        }
        int blocksize = ConfigurationManager.getBlocksize();
        MatrixCharacteristics mc = new MatrixCharacteristics(matrix.getNumRows(), matrix.getNumColumns(), blocksize, blocksize);
        MetaDataFormat meta = new MetaDataFormat(mc, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo);
        MatrixObject mo = new MatrixObject(Expression.ValueType.DOUBLE, OptimizerUtils.getUniqueTempFileName(), meta);
        mo.acquireModify(matrix);
        mo.release();
        this._vars.put(varname, mo);
        if (reuse) {
            mo.enableCleanup(false);
            this._inVarReuse.put(varname, mo);
        }
    }

    public void setFrame(String varname, String[][] frame) {
        this.setFrame(varname, frame, false);
    }

    public void setFrame(String varname, String[][] frame, List<Expression.ValueType> schema) {
        this.setFrame(varname, frame, schema, false);
    }

    public void setFrame(String varname, String[][] frame, List<Expression.ValueType> schema, List<String> colnames) {
        this.setFrame(varname, frame, schema, colnames, false);
    }

    public void setFrame(String varname, String[][] frame, boolean reuse) {
        this.setFrame(varname, DataConverter.convertToFrameBlock(frame), reuse);
    }

    public void setFrame(String varname, String[][] frame, List<Expression.ValueType> schema, boolean reuse) {
        this.setFrame(varname, DataConverter.convertToFrameBlock(frame, schema.toArray(new Expression.ValueType[0])), reuse);
    }

    public void setFrame(String varname, String[][] frame, List<Expression.ValueType> schema, List<String> colnames, boolean reuse) {
        this.setFrame(varname, DataConverter.convertToFrameBlock(frame, schema.toArray(new Expression.ValueType[0]), colnames.toArray(new String[0])), reuse);
    }

    public void setFrame(String varname, FrameBlock frame, boolean reuse) {
        if (!this._inVarnames.contains(varname)) {
            throw new DMLException("Unspecified input variable: " + varname);
        }
        MatrixCharacteristics mc = new MatrixCharacteristics(frame.getNumRows(), frame.getNumColumns(), -1, -1);
        MetaDataFormat meta = new MetaDataFormat(mc, OutputInfo.BinaryCellOutputInfo, InputInfo.BinaryCellInputInfo);
        FrameObject fo = new FrameObject(OptimizerUtils.getUniqueTempFileName(), meta);
        fo.acquireModify(frame);
        fo.release();
        this._vars.put(varname, fo);
        if (reuse) {
            fo.enableCleanup(false);
            this._inVarReuse.put(varname, fo);
        }
    }

    public void clearParameters() {
        this._vars.removeAll();
    }

    public ResultVariables executeScript() {
        this._vars.putAll(this._inVarReuse);
        ConfigurationManager.setLocalConfig(this._dmlconf);
        ConfigurationManager.setLocalConfig(this._cconf);
        ExecutionContext ec = ExecutionContextFactory.createContext(this._vars, this._prog);
        this._prog.execute(ec);
        this._vars.removeAllNotIn(this._outVarnames);
        ResultVariables rvars = new ResultVariables();
        for (String ovar : this._outVarnames) {
            Data tmpVar = this._vars.get(ovar);
            if (tmpVar == null) continue;
            rvars.addResult(ovar, tmpVar);
        }
        ConfigurationManager.clearLocalConfigs();
        return rvars;
    }

    public String explain() {
        return Explain.explain(this._prog);
    }

    public String statistics() {
        return Statistics.display();
    }

    public void enableFunctionRecompile(String fnamespace, String ... fnames) {
        if (fnamespace == null) {
            fnamespace = ".defaultNS";
        }
        CompilerConfig cconf = ConfigurationManager.getCompilerConfig();
        cconf.set(CompilerConfig.ConfigType.ALLOW_DYN_RECOMPILATION, true);
        ConfigurationManager.setLocalConfig(cconf);
        FunctionCallGraph fgraph = this._prog.getProgramBlocks().isEmpty() ? null : new FunctionCallGraph(this._prog.getProgramBlocks().get(0).getStatementBlock().getDMLProg());
        for (String fname : fnames) {
            String fkey = DMLProgram.constructFunctionKey(fnamespace, fname);
            if (fgraph != null && !fgraph.isRecursiveFunction(fkey)) {
                FunctionProgramBlock fpb = this._prog.getFunctionProgramBlock(fnamespace, fname);
                if (fpb != null) {
                    fpb.setRecompileOnce(true);
                    continue;
                }
                LOG.warn((Object)("Failed to enable function recompile for non-existing '" + fkey + "'."));
                continue;
            }
            if (fgraph == null) continue;
            LOG.warn((Object)("Failed to enable function recompile for recursive '" + fkey + "'."));
        }
    }

    public PreparedScript clone(boolean deep) {
        if (deep) {
            throw new NotImplementedException();
        }
        return new PreparedScript(this);
    }

    public Object clone() {
        return this.clone(true);
    }
}

