/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.util.LongAccumulator;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.parser.ParForStatementBlock;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.RemoteParForJobReturn;
import org.apache.sysml.runtime.controlprogram.parfor.RemoteParForSparkWorker;
import org.apache.sysml.runtime.controlprogram.parfor.RemoteParForUtils;
import org.apache.sysml.runtime.controlprogram.parfor.Task;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.utils.Statistics;

public class RemoteParForSpark {
    protected static final Log LOG = LogFactory.getLog(RemoteParForSpark.class.getName());
    private static final IDSequence _jobID = new IDSequence();

    public static RemoteParForJobReturn runJob(long pfid, String prog, HashMap<String, byte[]> clsMap, List<Task> tasks, ExecutionContext ec, ArrayList<ParForStatementBlock.ResultVar> resultVars, boolean cpCaching, int numMappers, boolean topLevelPF) {
        String jobname = "ParFor-ESP";
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        JavaSparkContext sc = sec.getSparkContext();
        LongAccumulator aTasks = sc.sc().longAccumulator("tasks");
        LongAccumulator aIters = sc.sc().longAccumulator("iterations");
        long jobid = _jobID.getNextID();
        if (InfrastructureAnalyzer.isLocalMode()) {
            RemoteParForSparkWorker.cleanupCachedVariables(jobid);
        }
        Map<String, Broadcast<CacheBlock>> brInputs = null;
        List out = sc.parallelize(tasks, tasks.size()).flatMapToPair((PairFlatMapFunction)new RemoteParForSparkWorker(jobid, prog, clsMap, cpCaching, aTasks, aIters, brInputs, topLevelPF)).collect();
        LocalVariableMap[] results = RemoteParForUtils.getResults(out, LOG);
        int numTasks = aTasks.value().intValue();
        int numIters = aIters.value().intValue();
        RemoteParForJobReturn ret = new RemoteParForJobReturn(true, numTasks, numIters, results);
        Statistics.incrementNoOfCompiledSPInst();
        Statistics.incrementNoOfExecutedSPInst();
        if (DMLScript.STATISTICS) {
            Statistics.maintainCPHeavyHitters(jobname, System.nanoTime() - t0);
        }
        return ret;
    }

    private static Map<String, Broadcast<CacheBlock>> broadcastInputs(SparkExecutionContext sec, ArrayList<ParForStatementBlock.ResultVar> resultVars) {
        LocalVariableMap inputs = sec.getVariables();
        Set retVars = resultVars.stream().map(v -> v._name).collect(Collectors.toSet());
        Set brVars = inputs.keySet().stream().filter(v -> !retVars.contains(v)).collect(Collectors.toSet());
        HashMap<String, Broadcast<CacheBlock>> result = new HashMap<String, Broadcast<CacheBlock>>();
        for (String key : brVars) {
            Data var = sec.getVariable(key);
            if (var instanceof ScalarObject || var instanceof MatrixObject && ((MatrixObject)var).isPartitioned()) continue;
            result.put(key, sec.broadcastVariable((CacheableData)var));
        }
        return result;
    }
}

