/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.recompile.Recompiler;
import org.apache.sysml.hops.rewrite.StatementBlockRewriteRule;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.parser.AssignmentStatement;
import org.apache.sysml.parser.BinaryExpression;
import org.apache.sysml.parser.BooleanExpression;
import org.apache.sysml.parser.BuiltinConstant;
import org.apache.sysml.parser.BuiltinFunctionExpression;
import org.apache.sysml.parser.ConstIdentifier;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DataExpression;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ExternalFunctionStatement;
import org.apache.sysml.parser.ForStatement;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.FunctionCallIdentifier;
import org.apache.sysml.parser.FunctionStatement;
import org.apache.sysml.parser.FunctionStatementBlock;
import org.apache.sysml.parser.Identifier;
import org.apache.sysml.parser.IfStatement;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.ImportStatement;
import org.apache.sysml.parser.IndexPair;
import org.apache.sysml.parser.IndexedIdentifier;
import org.apache.sysml.parser.IntIdentifier;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.LiveVariableAnalysis;
import org.apache.sysml.parser.MultiAssignmentStatement;
import org.apache.sysml.parser.OutputStatement;
import org.apache.sysml.parser.ParameterExpression;
import org.apache.sysml.parser.ParameterizedBuiltinFunctionExpression;
import org.apache.sysml.parser.ParseInfo;
import org.apache.sysml.parser.PathStatement;
import org.apache.sysml.parser.PrintStatement;
import org.apache.sysml.parser.RelationalExpression;
import org.apache.sysml.parser.Statement;
import org.apache.sysml.parser.StringIdentifier;
import org.apache.sysml.parser.VariableSet;
import org.apache.sysml.parser.WhileStatement;
import org.apache.sysml.parser.WhileStatementBlock;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.utils.MLContextProxy;

public class StatementBlock
extends LiveVariableAnalysis
implements ParseInfo {
    protected static final Log LOG = LogFactory.getLog(StatementBlock.class.getName());
    protected static IDSequence _seq = new IDSequence();
    protected DMLProgram _dmlProg = null;
    protected ArrayList<Statement> _statements = new ArrayList();
    ArrayList<Hop> _hops = null;
    ArrayList<Lop> _lops = null;
    HashMap<String, ConstIdentifier> _constVarsIn;
    HashMap<String, ConstIdentifier> _constVarsOut;
    private ArrayList<String> _updateInPlaceVars = null;
    private boolean _requiresRecompile = false;
    private boolean _splitDag = false;
    private String _filename = "MAIN SCRIPT";
    private int _beginLine = 0;
    private int _beginColumn = 0;
    private int _endLine = 0;
    private int _endColumn = 0;
    private String _text;

    public StatementBlock() {
        this._read = new VariableSet();
        this._updated = new VariableSet();
        this._gen = new VariableSet();
        this._kill = new VariableSet();
        this._warnSet = new VariableSet();
        this._initialized = true;
        this._constVarsIn = new HashMap();
        this._constVarsOut = new HashMap();
        this._updateInPlaceVars = new ArrayList();
    }

    public StatementBlock(StatementBlock sb) {
        this();
        this.setParseInfo(sb);
        this._dmlProg = sb._dmlProg;
    }

    public void setDMLProg(DMLProgram dmlProg) {
        this._dmlProg = dmlProg;
    }

    public DMLProgram getDMLProg() {
        return this._dmlProg;
    }

    public void addStatement(Statement s) {
        this._statements.add(s);
        if (this._statements.size() == 1) {
            this._filename = s.getFilename();
            this._beginLine = s.getBeginLine();
            this._beginColumn = s.getBeginColumn();
        }
        this._endLine = s.getEndLine();
        this._endColumn = s.getEndColumn();
    }

    public void addStatementBlock(StatementBlock s) {
        for (int i = 0; i < s.getNumStatements(); ++i) {
            this._statements.add(s.getStatement(i));
        }
        this._beginLine = this._statements.get(0).getBeginLine();
        this._beginColumn = this._statements.get(0).getBeginColumn();
        this._endLine = this._statements.get(this._statements.size() - 1).getEndLine();
        this._endColumn = this._statements.get(this._statements.size() - 1).getEndColumn();
    }

    public int getNumStatements() {
        return this._statements.size();
    }

    public Statement getStatement(int i) {
        return this._statements.get(i);
    }

    public ArrayList<Statement> getStatements() {
        return this._statements;
    }

    public void setStatements(ArrayList<Statement> s) {
        this._statements = s;
    }

    public ArrayList<Hop> getHops() {
        return this._hops;
    }

    public ArrayList<Lop> getLops() {
        return this._lops;
    }

    public void setHops(ArrayList<Hop> hops) {
        this._hops = hops;
    }

    public void setLops(ArrayList<Lop> lops) {
        this._lops = lops;
    }

    public boolean mergeable() {
        for (Statement s : this._statements) {
            if (!s.controlStatement()) continue;
            return false;
        }
        return true;
    }

    public void setSplitDag(boolean flag) {
        this._splitDag = flag;
    }

    public boolean isSplitDag() {
        return this._splitDag;
    }

    private boolean isMergeablePrintStatement(Statement stmt) {
        return stmt instanceof PrintStatement && (((PrintStatement)stmt).getType() == PrintStatement.PRINTTYPE.STOP || ((PrintStatement)stmt).getType() == PrintStatement.PRINTTYPE.ASSERT);
    }

    public boolean isMergeableFunctionCallBlock(DMLProgram dmlProg) {
        if (DMLScript.ENABLE_DEBUG_MODE) {
            return false;
        }
        Statement stmt = this.getStatement(0);
        if (stmt instanceof WhileStatement || stmt instanceof IfStatement || stmt instanceof ForStatement || stmt instanceof FunctionStatement || this.isMergeablePrintStatement(stmt)) {
            return false;
        }
        if (stmt instanceof AssignmentStatement || stmt instanceof MultiAssignmentStatement) {
            Expression sourceExpr = null;
            if (stmt instanceof AssignmentStatement) {
                AssignmentStatement astmt = (AssignmentStatement)stmt;
                if (astmt.getSource().toString().contains("format=csv") && astmt.getSource().toString().contains("read")) {
                    return false;
                }
                sourceExpr = astmt.getSource();
            } else {
                sourceExpr = ((MultiAssignmentStatement)stmt).getSource();
            }
            if (sourceExpr instanceof BuiltinFunctionExpression && ((BuiltinFunctionExpression)sourceExpr).multipleReturns() || sourceExpr instanceof ParameterizedBuiltinFunctionExpression && ((ParameterizedBuiltinFunctionExpression)sourceExpr).multipleReturns()) {
                return false;
            }
            if (sourceExpr instanceof FunctionCallIdentifier) {
                FunctionCallIdentifier fcall = (FunctionCallIdentifier)sourceExpr;
                FunctionStatementBlock fblock = dmlProg.getFunctionStatementBlock(fcall.getNamespace(), fcall.getName());
                if (fblock == null) {
                    if (".defaultNS".equals(fcall.getNamespace())) {
                        throw new LanguageException(sourceExpr.printErrorLocation() + "Function " + fcall.getName() + "() is undefined.");
                    }
                    throw new LanguageException(sourceExpr.printErrorLocation() + "Function " + fcall.getName() + "() is undefined in namespace '" + fcall.getNamespace() + "'.");
                }
                if (!this.rIsInlineableFunction(fblock, dmlProg)) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isRewritableFunctionCall(Statement stmt, DMLProgram dmlProg) {
        if (stmt instanceof AssignmentStatement || stmt instanceof MultiAssignmentStatement) {
            Expression sourceExpr = null;
            sourceExpr = stmt instanceof AssignmentStatement ? ((AssignmentStatement)stmt).getSource() : ((MultiAssignmentStatement)stmt).getSource();
            if (sourceExpr instanceof FunctionCallIdentifier) {
                FunctionCallIdentifier fcall = (FunctionCallIdentifier)sourceExpr;
                FunctionStatementBlock fblock = dmlProg.getFunctionStatementBlock(fcall.getNamespace(), fcall.getName());
                if (fblock == null) {
                    throw new LanguageException(sourceExpr.printErrorLocation() + "function " + fcall.getName() + " is undefined in namespace " + fcall.getNamespace());
                }
                if (stmt instanceof AssignmentStatement && ((AssignmentStatement)stmt).getTarget() instanceof IndexedIdentifier) {
                    return false;
                }
                if (this.rIsInlineableFunction(fblock, dmlProg)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean rIsInlineableFunction(FunctionStatementBlock fblock, DMLProgram prog) {
        boolean ret = true;
        if (fblock.getStatements().isEmpty() || fblock.getStatement(0) instanceof ExternalFunctionStatement || ((FunctionStatement)fblock.getStatement(0)).getBody().size() > 1) {
            return false;
        }
        if (!fblock.getStatements().isEmpty() && !((FunctionStatement)fblock.getStatement(0)).getBody().isEmpty()) {
            StatementBlock stmtBlock = ((FunctionStatement)fblock.getStatement(0)).getBody().get(0);
            if (stmtBlock instanceof IfStatementBlock || stmtBlock instanceof WhileStatementBlock || stmtBlock instanceof ForStatementBlock) {
                return false;
            }
            for (Statement s : stmtBlock.getStatements()) {
                MultiAssignmentStatement mas;
                FunctionStatementBlock fblock2;
                FunctionCallIdentifier fcall;
                if (s instanceof AssignmentStatement && ((AssignmentStatement)s).getSource() instanceof FunctionCallIdentifier) {
                    AssignmentStatement as = (AssignmentStatement)s;
                    fcall = (FunctionCallIdentifier)as.getSource();
                    fblock2 = prog.getFunctionStatementBlock(fcall.getNamespace(), fcall.getName());
                    ret &= this.rIsInlineableFunction(fblock2, prog);
                    if (as.getSource().toString().contains("format=csv") && as.getSource().toString().contains("read")) {
                        return false;
                    }
                    if (ret) continue;
                    return false;
                }
                if (!(s instanceof MultiAssignmentStatement) || !((mas = (MultiAssignmentStatement)s).getSource() instanceof FunctionCallIdentifier ? !(ret &= this.rIsInlineableFunction(fblock2 = prog.getFunctionStatementBlock((fcall = (FunctionCallIdentifier)((MultiAssignmentStatement)s).getSource()).getNamespace(), fcall.getName()), prog)) : mas.getSource() instanceof BuiltinFunctionExpression && ((BuiltinFunctionExpression)mas.getSource()).multipleReturns())) continue;
                return false;
            }
        }
        return ret;
    }

    public static ArrayList<StatementBlock> mergeFunctionCalls(ArrayList<StatementBlock> body, DMLProgram dmlProg) {
        for (int i = 0; i < body.size(); ++i) {
            StatementBlock currBlock = body.get(i);
            if (currBlock instanceof WhileStatementBlock) {
                WhileStatement wstmt = (WhileStatement)((WhileStatementBlock)currBlock).getStatement(0);
                wstmt.setBody(StatementBlock.mergeFunctionCalls(wstmt.getBody(), dmlProg));
                continue;
            }
            if (currBlock instanceof ForStatementBlock) {
                ForStatement fstmt = (ForStatement)((ForStatementBlock)currBlock).getStatement(0);
                fstmt.setBody(StatementBlock.mergeFunctionCalls(fstmt.getBody(), dmlProg));
                continue;
            }
            if (currBlock instanceof IfStatementBlock) {
                IfStatement ifstmt = (IfStatement)((IfStatementBlock)currBlock).getStatement(0);
                ifstmt.setIfBody(StatementBlock.mergeFunctionCalls(ifstmt.getIfBody(), dmlProg));
                ifstmt.setElseBody(StatementBlock.mergeFunctionCalls(ifstmt.getElseBody(), dmlProg));
                continue;
            }
            if (!(currBlock instanceof FunctionStatementBlock)) continue;
            FunctionStatement functStmt = (FunctionStatement)((FunctionStatementBlock)currBlock).getStatement(0);
            functStmt.setBody(StatementBlock.mergeFunctionCalls(functStmt.getBody(), dmlProg));
        }
        ArrayList<StatementBlock> result = new ArrayList<StatementBlock>();
        StatementBlock currentBlock = null;
        for (int i = 0; i < body.size(); ++i) {
            StatementBlock current = body.get(i);
            if (current.isMergeableFunctionCallBlock(dmlProg)) {
                if (currentBlock != null) {
                    currentBlock.addStatementBlock(current);
                    continue;
                }
                currentBlock = current;
                continue;
            }
            if (currentBlock != null) {
                result.add(currentBlock);
            }
            result.add(current);
            currentBlock = null;
        }
        if (currentBlock != null) {
            result.add(currentBlock);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("statements\n");
        for (Statement s : this._statements) {
            sb.append(s);
            sb.append("\n");
        }
        if (this._liveOut != null) {
            sb.append("liveout " + this._liveOut.toString() + "\n");
        }
        if (this._liveIn != null) {
            sb.append("livein " + this._liveIn.toString() + "\n");
        }
        if (this._gen != null && !this._gen.getVariables().isEmpty()) {
            sb.append("gen " + this._gen.toString() + "\n");
        }
        if (this._kill != null && !this._kill.getVariables().isEmpty()) {
            sb.append("kill " + this._kill.toString() + "\n");
        }
        if (this._read != null && !this._read.getVariables().isEmpty()) {
            sb.append("read " + this._read.toString() + "\n");
        }
        if (this._updated != null && !this._updated.getVariables().isEmpty()) {
            sb.append("updated " + this._updated.toString() + "\n");
        }
        return sb.toString();
    }

    public static ArrayList<StatementBlock> mergeStatementBlocks(ArrayList<StatementBlock> sb) {
        if (sb == null || sb.isEmpty()) {
            return new ArrayList<StatementBlock>();
        }
        ArrayList<StatementBlock> result = new ArrayList<StatementBlock>();
        StatementBlock currentBlock = null;
        for (int i = 0; i < sb.size(); ++i) {
            StatementBlock current = sb.get(i);
            if (current.mergeable()) {
                if (currentBlock != null) {
                    currentBlock.addStatementBlock(current);
                    continue;
                }
                currentBlock = current;
                continue;
            }
            if (currentBlock != null) {
                result.add(currentBlock);
            }
            result.add(current);
            currentBlock = null;
        }
        if (currentBlock != null) {
            result.add(currentBlock);
        }
        return result;
    }

    public static List<StatementBlock> rHoistFunctionCallsFromExpressions(StatementBlock current) {
        if (current instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)current;
            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
            ArrayList<StatementBlock> tmp = new ArrayList<StatementBlock>();
            for (StatementBlock statementBlock : fstmt.getBody()) {
                tmp.addAll(StatementBlock.rHoistFunctionCallsFromExpressions(statementBlock));
            }
            fstmt.setBody(tmp);
        } else if (current instanceof WhileStatementBlock) {
            WhileStatementBlock wsb = (WhileStatementBlock)current;
            WhileStatement wstmt = (WhileStatement)wsb.getStatement(0);
            ArrayList<StatementBlock> tmp = new ArrayList<StatementBlock>();
            for (StatementBlock statementBlock : wstmt.getBody()) {
                tmp.addAll(StatementBlock.rHoistFunctionCallsFromExpressions(statementBlock));
            }
            wstmt.setBody(tmp);
        } else if (current instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)current;
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            ArrayList<StatementBlock> tmp = new ArrayList<StatementBlock>();
            for (StatementBlock statementBlock : istmt.getIfBody()) {
                tmp.addAll(StatementBlock.rHoistFunctionCallsFromExpressions(statementBlock));
            }
            istmt.setIfBody(tmp);
            if (istmt.getElseBody() != null && !istmt.getElseBody().isEmpty()) {
                ArrayList<StatementBlock> tmp2 = new ArrayList<StatementBlock>();
                for (StatementBlock sb : istmt.getElseBody()) {
                    tmp2.addAll(StatementBlock.rHoistFunctionCallsFromExpressions(sb));
                }
                istmt.setElseBody(tmp2);
            }
        } else if (current instanceof ForStatementBlock) {
            ForStatementBlock fsb = (ForStatementBlock)current;
            ForStatement fstmt = (ForStatement)fsb.getStatement(0);
            ArrayList<StatementBlock> tmp = new ArrayList<StatementBlock>();
            for (StatementBlock statementBlock : fstmt.getBody()) {
                tmp.addAll(StatementBlock.rHoistFunctionCallsFromExpressions(statementBlock));
            }
            fstmt.setBody(tmp);
        } else {
            ArrayList<Statement> tmp = new ArrayList<Statement>();
            for (Statement stmt : current.getStatements()) {
                tmp.addAll(StatementBlock.rHoistFunctionCallsFromExpressions(stmt));
            }
            if (current.getStatements().size() != tmp.size()) {
                return StatementBlock.createStatementBlocks(current, tmp);
            }
        }
        return Arrays.asList(current);
    }

    public static List<Statement> rHoistFunctionCallsFromExpressions(Statement stmt) {
        ArrayList<Statement> ret;
        ArrayList<Statement> tmp = new ArrayList<Statement>();
        if (stmt instanceof AssignmentStatement) {
            AssignmentStatement astmt = (AssignmentStatement)stmt;
            boolean ix = astmt.getTargetList().get(0) instanceof IndexedIdentifier;
            StatementBlock.rHoistFunctionCallsFromExpressions(astmt.getSource(), !ix, tmp);
            if (ix && astmt.getSource() instanceof FunctionCallIdentifier) {
                AssignmentStatement lstmt = (AssignmentStatement)tmp.get(tmp.size() - 1);
                astmt.setSource(StatementBlock.copy(lstmt.getTarget()));
            }
        } else if (stmt instanceof MultiAssignmentStatement) {
            MultiAssignmentStatement mstmt = (MultiAssignmentStatement)stmt;
            StatementBlock.rHoistFunctionCallsFromExpressions(mstmt.getSource(), true, tmp);
        } else if (stmt instanceof PrintStatement) {
            PrintStatement pstmt = (PrintStatement)stmt;
            for (int i = 0; i < pstmt.expressions.size(); ++i) {
                Expression lexpr = pstmt.getExpressions().get(i);
                StatementBlock.rHoistFunctionCallsFromExpressions(lexpr, false, tmp);
                if (!(lexpr instanceof FunctionCallIdentifier)) continue;
                AssignmentStatement lstmt = (AssignmentStatement)tmp.get(tmp.size() - 1);
                pstmt.getExpressions().set(i, StatementBlock.copy(lstmt.getTarget()));
            }
        }
        List<Statement> list = ret = tmp.isEmpty() ? Arrays.asList(stmt) : tmp;
        if (!tmp.isEmpty()) {
            for (Statement ltmp : tmp) {
                ltmp.setParseInfo(stmt);
            }
            tmp.add(stmt);
        }
        return ret;
    }

    public static Expression rHoistFunctionCallsFromExpressions(Expression expr, boolean root, ArrayList<Statement> tmp) {
        if (expr == null || expr instanceof ConstIdentifier) {
            return expr;
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression lexpr = (BinaryExpression)expr;
            lexpr.setLeft(StatementBlock.rHoistFunctionCallsFromExpressions(lexpr.getLeft(), false, tmp));
            lexpr.setRight(StatementBlock.rHoistFunctionCallsFromExpressions(lexpr.getRight(), false, tmp));
        } else if (expr instanceof RelationalExpression) {
            RelationalExpression lexpr = (RelationalExpression)expr;
            lexpr.setLeft(StatementBlock.rHoistFunctionCallsFromExpressions(lexpr.getLeft(), false, tmp));
            lexpr.setRight(StatementBlock.rHoistFunctionCallsFromExpressions(lexpr.getRight(), false, tmp));
        } else if (expr instanceof BooleanExpression) {
            BooleanExpression lexpr = (BooleanExpression)expr;
            lexpr.setLeft(StatementBlock.rHoistFunctionCallsFromExpressions(lexpr.getLeft(), false, tmp));
            lexpr.setRight(StatementBlock.rHoistFunctionCallsFromExpressions(lexpr.getRight(), false, tmp));
        } else if (expr instanceof BuiltinFunctionExpression) {
            BuiltinFunctionExpression lexpr = (BuiltinFunctionExpression)expr;
            Expression[] clexpr = lexpr.getAllExpr();
            for (int i = 0; i < clexpr.length; ++i) {
                clexpr[i] = StatementBlock.rHoistFunctionCallsFromExpressions(clexpr[i], false, tmp);
            }
        } else if (expr instanceof ParameterizedBuiltinFunctionExpression) {
            ParameterizedBuiltinFunctionExpression lexpr = (ParameterizedBuiltinFunctionExpression)expr;
            HashMap<String, Expression> clexpr = lexpr.getVarParams();
            for (String key : clexpr.keySet()) {
                clexpr.put(key, StatementBlock.rHoistFunctionCallsFromExpressions(clexpr.get(key), false, tmp));
            }
        } else if (expr instanceof DataExpression) {
            DataExpression lexpr = (DataExpression)expr;
            HashMap<String, Expression> clexpr = lexpr.getVarParams();
            for (String key : clexpr.keySet()) {
                clexpr.put(key, StatementBlock.rHoistFunctionCallsFromExpressions(clexpr.get(key), false, tmp));
            }
        } else if (expr instanceof FunctionCallIdentifier) {
            FunctionCallIdentifier fexpr = (FunctionCallIdentifier)expr;
            for (ParameterExpression pexpr : fexpr.getParamExprs()) {
                pexpr.setExpr(StatementBlock.rHoistFunctionCallsFromExpressions(pexpr.getExpr(), false, tmp));
            }
            if (!root) {
                String varname = StatementBlockRewriteRule.createCutVarName(true);
                DataIdentifier di = new DataIdentifier(varname);
                di.setDataType(fexpr.getDataType());
                di.setValueType(fexpr.getValueType());
                tmp.add(new AssignmentStatement(di, (Expression)fexpr, (ParseInfo)di));
                return di;
            }
        }
        return expr;
    }

    private static DataIdentifier copy(DataIdentifier di) {
        return new DataIdentifier(di);
    }

    private static List<StatementBlock> createStatementBlocks(StatementBlock sb, List<Statement> stmts) {
        ArrayList<StatementBlock> ret = new ArrayList<StatementBlock>();
        StatementBlock current = new StatementBlock(sb);
        for (Statement stmt : stmts) {
            current.addStatement(stmt);
            if (!(stmt instanceof AssignmentStatement) || !(((AssignmentStatement)stmt).getSource() instanceof FunctionCallIdentifier)) continue;
            ret.add(current);
            current = new StatementBlock(sb);
        }
        if (current.getNumStatements() > 0) {
            ret.add(current);
        }
        return ret;
    }

    public ArrayList<Statement> rewriteFunctionCallStatements(DMLProgram dmlProg, ArrayList<Statement> statements) {
        ArrayList<Statement> newStatements = new ArrayList<Statement>();
        for (Statement current : statements) {
            if (!this.isRewritableFunctionCall(current, dmlProg)) {
                newStatements.add(current);
                continue;
            }
            Expression sourceExpr = current instanceof AssignmentStatement ? ((AssignmentStatement)current).getSource() : ((MultiAssignmentStatement)current).getSource();
            FunctionCallIdentifier fcall = (FunctionCallIdentifier)sourceExpr;
            FunctionStatementBlock fblock = dmlProg.getFunctionStatementBlock(fcall.getNamespace(), fcall.getName());
            if (fblock == null) {
                fcall.raiseValidateError("function " + fcall.getName() + " is undefined in namespace " + fcall.getNamespace(), false);
            }
            FunctionStatement fstmt = (FunctionStatement)fblock.getStatement(0);
            if (this.rIsInlineableFunction(fblock, dmlProg)) {
                fstmt.getBody().get(0).setStatements(this.rewriteFunctionCallStatements(dmlProg, fstmt.getBody().get(0).getStatements()));
            }
            String prefix = _seq.getNextID() + "_";
            if (fstmt.getBody().size() > 1) {
                sourceExpr.raiseValidateError("rewritable function can only have 1 statement block", false);
            }
            StatementBlock sblock = fstmt.getBody().get(0);
            if (fcall.getParamExprs().size() != fstmt.getInputParams().size()) {
                sourceExpr.raiseValidateError("Wrong number of function input arguments: " + fcall.getParamExprs().size() + " found, but " + fstmt.getInputParams().size() + " expected.");
            }
            for (int i = 0; i < fcall.getParamExprs().size(); ++i) {
                DataIdentifier currFormalParam;
                ParameterExpression inputArg = fcall.getParamExprs().get(i);
                DataIdentifier dataIdentifier = currFormalParam = inputArg.getName() == null ? fstmt.getInputParams().get(i) : fstmt.getInputParam(inputArg.getName());
                if (currFormalParam == null) {
                    throw new LanguageException("Non-existing named function argument '" + inputArg.getName() + "' in call to " + fcall.getName() + ".");
                }
                String newFormalParameterName = prefix + currFormalParam.getName();
                DataIdentifier newTarget = new DataIdentifier(currFormalParam);
                newTarget.setName(newFormalParameterName);
                Expression currCallParam = inputArg.getExpr();
                Expression.ValueType targetVT = newTarget.getValueType();
                if (newTarget.getDataType() == Expression.DataType.SCALAR && currCallParam.getOutput() != null && targetVT != currCallParam.getOutput().getValueType() && targetVT != Expression.ValueType.STRING) {
                    currCallParam = new BuiltinFunctionExpression(BuiltinFunctionExpression.getValueTypeCastOperator(targetVT), new Expression[]{currCallParam}, newTarget);
                }
                newStatements.add(new AssignmentStatement(newTarget, currCallParam, (ParseInfo)newTarget));
            }
            for (Statement stmt : sblock._statements) {
                Statement rewrittenStmt = stmt.rewriteStatement(prefix);
                newStatements.add(rewrittenStmt);
            }
            if (current instanceof AssignmentStatement) {
                AssignmentStatement as;
                if (fstmt.getOutputParams().size() == 0 && (as = (AssignmentStatement)current).getTargetList().size() == 1 && as.getTargetList().get(0) != null) {
                    this.raiseValidateError("Function '" + fcall.getName() + "' does not return a value but is assigned to " + as.getTargetList().get(0), true);
                }
            } else if (current instanceof MultiAssignmentStatement && fstmt.getOutputParams().size() == 0) {
                MultiAssignmentStatement mas = (MultiAssignmentStatement)current;
                this.raiseValidateError("Function '" + fcall.getName() + "' does not return a value but is assigned to " + mas.getTargetList(), true);
            }
            StatementBlock.appendOutputAssignments(current, prefix, fstmt, newStatements);
        }
        return newStatements;
    }

    private static boolean isOutputBindingViaFunctionCall(Statement last, String prefix, FunctionStatement fstmt) {
        if (last instanceof AssignmentStatement) {
            AssignmentStatement as = (AssignmentStatement)last;
            String newName = prefix + fstmt.getOutputParams().get(0).getName();
            return as.getSource() instanceof FunctionCallIdentifier && as.getTarget().getName().equals(newName);
        }
        if (last instanceof MultiAssignmentStatement) {
            MultiAssignmentStatement mas = (MultiAssignmentStatement)last;
            ArrayList<DataIdentifier> tlist1 = mas.getTargetList();
            boolean ret = mas.getSource() instanceof FunctionCallIdentifier || mas.getSource() instanceof BuiltinFunctionExpression && ((BuiltinFunctionExpression)mas.getSource()).multipleReturns();
            for (DataIdentifier di : fstmt.getOutputParams()) {
                ret &= tlist1.stream().anyMatch(d -> d.getName().equals(prefix + di.getName()));
            }
            return ret;
        }
        return false;
    }

    private static MultiAssignmentStatement createNewPartialMultiAssignment(Statement last, Statement current, String prefix, FunctionStatement fstmt) {
        MultiAssignmentStatement mas = (MultiAssignmentStatement)last;
        AssignmentStatement as = (AssignmentStatement)current;
        ArrayList<DataIdentifier> tlist = new ArrayList<DataIdentifier>();
        String tmpStr = prefix + fstmt.getOutputParams().get(0).getName();
        for (DataIdentifier di : mas.getTargetList()) {
            tlist.add(di.getName().equals(tmpStr) ? as.getTarget() : di);
        }
        return new MultiAssignmentStatement(tlist, mas.getSource());
    }

    private static void appendOutputAssignments(Statement current, String prefix, FunctionStatement fstmt, List<Statement> newStatements) {
        for (int i = 0; i < fstmt.getOutputParams().size(); ++i) {
            DataIdentifier currReturnParam = fstmt.getOutputParams().get(i);
            String newSourceName = prefix + currReturnParam.getName();
            DataIdentifier newSource = new DataIdentifier(currReturnParam);
            newSource.setName(newSourceName);
            DataIdentifier newTarget = null;
            if (current instanceof AssignmentStatement) {
                AssignmentStatement as;
                DataIdentifier targ;
                if (i > 0) {
                    fstmt.raiseValidateError("Assignment statement cannot return multiple values", false);
                }
                if ((targ = (as = (AssignmentStatement)current).getTarget()) == null) {
                    Expression exp = as.getSource();
                    FunctionCallIdentifier fci = (FunctionCallIdentifier)exp;
                    String functionName = fci.getName();
                    fstmt.raiseValidateError(functionName + " requires LHS value", false);
                } else {
                    newTarget = new DataIdentifier(((AssignmentStatement)current).getTarget());
                }
            } else {
                newTarget = new DataIdentifier(((MultiAssignmentStatement)current).getTargetList().get(i));
            }
            Expression.ValueType sourceVT = newSource.getValueType();
            if (newSource.getDataType() == Expression.DataType.SCALAR && sourceVT != Expression.ValueType.STRING) {
                newSource = new BuiltinFunctionExpression(BuiltinFunctionExpression.getValueTypeCastOperator(sourceVT), new Expression[]{newSource}, newTarget);
            }
            newStatements.add(new AssignmentStatement(newTarget, (Expression)newSource, (ParseInfo)newTarget));
        }
    }

    public VariableSet validate(DMLProgram dmlProg, VariableSet ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) {
        this._constVarsIn.putAll(constVars);
        this._statements = this.rewriteFunctionCallStatements(dmlProg, this._statements);
        this._dmlProg = dmlProg;
        HashMap<String, ConstIdentifier> currConstVars = new HashMap<String, ConstIdentifier>(constVars);
        for (Statement current : this._statements) {
            if (current instanceof OutputStatement) {
                OutputStatement os = (OutputStatement)current;
                DataIdentifier target = os.getIdentifier();
                if (ids.getVariable(target.getName()) == null) {
                    this.raiseValidateError("Undefined Variable (" + target.getName() + ") used in statement", false, "Invalid Parameters");
                }
                if (ids.getVariable(target.getName()).getDataType() == Expression.DataType.SCALAR) {
                    boolean paramsOkay = true;
                    for (String key : os.getSource().getVarParams().keySet()) {
                        if (key.equals("iofilename") || key.equals("format")) continue;
                        paramsOkay = false;
                    }
                    if (!paramsOkay) {
                        this.raiseValidateError("Invalid parameters in write statement: " + os.toString(), conditional);
                    }
                }
                DataExpression source = os.getSource();
                source.setOutput(target);
                ((Expression)source).validateExpression(ids.getVariables(), currConstVars, conditional);
                this.setStatementFormatType(os, conditional);
                target.setDimensionValueProperties(ids.getVariable(target.getName()));
                continue;
            }
            if (current instanceof AssignmentStatement) {
                this.validateAssignmentStatement(current, dmlProg, ids, currConstVars, conditional);
                continue;
            }
            if (current instanceof MultiAssignmentStatement) {
                this.validateMultiAssignmentStatement(current, dmlProg, ids, currConstVars, conditional);
                continue;
            }
            if (current instanceof ForStatement || current instanceof IfStatement || current instanceof WhileStatement) {
                this.raiseValidateError("control statement (WhileStatement, IfStatement, ForStatement) should not be in generic statement block. Likely a parsing error", conditional);
                continue;
            }
            if (current instanceof PrintStatement) {
                PrintStatement pstmt = (PrintStatement)current;
                List<Expression> expressions = pstmt.getExpressions();
                for (Expression expression : expressions) {
                    expression.validateExpression(ids.getVariables(), currConstVars, conditional);
                    if (expression.getOutput().getDataType() == Expression.DataType.SCALAR) continue;
                    if (expression.getOutput().getDataType() == Expression.DataType.MATRIX) {
                        pstmt.raiseValidateError("Print statements can only print scalars. To print a matrix, please wrap it in a toString() function.", conditional);
                        continue;
                    }
                    pstmt.raiseValidateError("Print statements can only print scalars.", conditional);
                }
                continue;
            }
            if (current instanceof PathStatement || current instanceof ImportStatement) continue;
            this.raiseValidateError("cannot process statement of type " + current.getClass().getSimpleName(), conditional);
        }
        this._constVarsOut.putAll(currConstVars);
        return ids;
    }

    private void validateAssignmentStatement(Statement current, DMLProgram dmlProg, VariableSet ids, HashMap<String, ConstIdentifier> currConstVars, boolean conditional) {
        BuiltinFunctionExpression bife;
        AssignmentStatement as = (AssignmentStatement)current;
        DataIdentifier target = as.getTarget();
        Expression source = as.getSource();
        if (target != null && BuiltinConstant.contains(target.getName())) {
            target.raiseValidateError(String.format("Cannot assign a value to the builtin constant %s.", target.getName()), false);
        }
        if (source instanceof FunctionCallIdentifier) {
            ((FunctionCallIdentifier)source).validateExpression(dmlProg, ids.getVariables(), currConstVars, conditional);
        } else {
            if (target == null) {
                this.raiseValidateError("Missing variable assignment.", false);
            }
            if (MLContextProxy.isActive()) {
                MLContextProxy.setAppropriateVarsForRead(source, target._name);
            }
            source.validateExpression(ids.getVariables(), currConstVars, conditional);
        }
        if (source instanceof DataExpression && ((DataExpression)source).getOpCode() == Expression.DataOp.READ) {
            this.setStatementFormatType(as, conditional);
        }
        if (target != null) {
            DataIdentifier diSource;
            currConstVars.remove(target.getName());
            if (source instanceof ConstIdentifier && !(target instanceof IndexedIdentifier)) {
                currConstVars.put(target.getName(), (ConstIdentifier)source);
            }
            if (source instanceof DataIdentifier && !(target instanceof IndexedIdentifier) && currConstVars.containsKey((diSource = (DataIdentifier)source).getName())) {
                currConstVars.put(target.getName(), currConstVars.get(diSource.getName()));
            }
        }
        if (source instanceof BuiltinFunctionExpression && ((bife = (BuiltinFunctionExpression)source).getOpCode() == Expression.BuiltinFunctionOp.NROW || bife.getOpCode() == Expression.BuiltinFunctionOp.NCOL)) {
            DataIdentifier id = (DataIdentifier)bife.getFirstExpr();
            DataIdentifier currVal = ids.getVariable(id.getName());
            if (currVal == null) {
                bife.raiseValidateError("Undefined Variable (" + id.getName() + ") used in statement", false, "Invalid Parameters");
            }
            IntIdentifier intid = null;
            intid = bife.getOpCode() == Expression.BuiltinFunctionOp.NROW ? new IntIdentifier(currVal instanceof IndexedIdentifier ? ((IndexedIdentifier)currVal).getOrigDim1() : currVal.getDim1(), (ParseInfo)bife) : new IntIdentifier(currVal instanceof IndexedIdentifier ? ((IndexedIdentifier)currVal).getOrigDim2() : currVal.getDim2(), (ParseInfo)bife);
            if (intid.getValue() != -1L) {
                currConstVars.put(target.getName(), intid);
            }
        }
        if (target != null) {
            if (!(target instanceof IndexedIdentifier)) {
                target.setProperties(source.getOutput());
                if (source.getOutput() instanceof IndexedIdentifier) {
                    target.setDimensions(source.getOutput().getDim1(), source.getOutput().getDim2());
                }
            } else {
                DataIdentifier targetAsSeen = ids.getVariable(target.getName());
                if (targetAsSeen == null) {
                    target.raiseValidateError("cannot assign value to indexed identifier " + target.toString() + " without first initializing " + target.getName(), conditional);
                }
                target.setProperties(targetAsSeen);
                if (((IndexedIdentifier)target).getRowLowerBound() != null) {
                    ((IndexedIdentifier)target).getRowLowerBound().validateExpression(ids.getVariables(), currConstVars, conditional);
                }
                if (((IndexedIdentifier)target).getRowUpperBound() != null) {
                    ((IndexedIdentifier)target).getRowUpperBound().validateExpression(ids.getVariables(), currConstVars, conditional);
                }
                if (((IndexedIdentifier)target).getColLowerBound() != null) {
                    ((IndexedIdentifier)target).getColLowerBound().validateExpression(ids.getVariables(), currConstVars, conditional);
                }
                if (((IndexedIdentifier)target).getColUpperBound() != null) {
                    ((IndexedIdentifier)target).getColUpperBound().validateExpression(ids.getVariables(), currConstVars, conditional);
                }
                IndexPair targetSize = ((IndexedIdentifier)target).calculateIndexedDimensions(ids.getVariables(), currConstVars, conditional);
                if (targetSize._row >= 1L && source.getOutput().getDim1() > 1L && targetSize._row != source.getOutput().getDim1()) {
                    target.raiseValidateError("Dimension mismatch. Indexed expression " + target.toString() + " can only be assigned matrix with dimensions " + targetSize._row + " rows and " + targetSize._col + " cols. Attempted to assign matrix with dimensions " + source.getOutput().getDim1() + " rows and " + source.getOutput().getDim2() + " cols ", conditional);
                }
                if (targetSize._col >= 1L && source.getOutput().getDim2() > 1L && targetSize._col != source.getOutput().getDim2()) {
                    target.raiseValidateError("Dimension mismatch. Indexed expression " + target.toString() + " can only be assigned matrix with dimensions " + targetSize._row + " rows and " + targetSize._col + " cols. Attempted to assign matrix with dimensions " + source.getOutput().getDim1() + " rows and " + source.getOutput().getDim2() + " cols ", conditional);
                }
                ((IndexedIdentifier)target).setDimensions(targetSize._row, targetSize._col);
            }
        }
        if (target != null) {
            ids.addVariable(target.getName(), target);
        }
    }

    private void validateMultiAssignmentStatement(Statement current, DMLProgram dmlProg, VariableSet ids, HashMap<String, ConstIdentifier> currConstVars, boolean conditional) {
        block12: {
            Expression source;
            ArrayList<DataIdentifier> targetList;
            block11: {
                MultiAssignmentStatement mas = (MultiAssignmentStatement)current;
                targetList = mas.getTargetList();
                source = mas.getSource();
                targetList.forEach(target -> {
                    if (target != null && BuiltinConstant.contains(target.getName())) {
                        target.raiseValidateError(String.format("Cannot assign a value to the builtin constant %s.", target.getName()), false);
                    }
                });
                if (!(source instanceof DataIdentifier) || source instanceof DataIdentifier && !((DataIdentifier)source).multipleReturns()) {
                    source.raiseValidateError("can only use user-defined functions with multi-assignment statement", conditional);
                }
                if (source instanceof FunctionCallIdentifier) {
                    FunctionCallIdentifier fci = (FunctionCallIdentifier)source;
                    fci.validateExpression(dmlProg, ids.getVariables(), currConstVars, conditional);
                } else if ((source instanceof BuiltinFunctionExpression || source instanceof ParameterizedBuiltinFunctionExpression) && ((DataIdentifier)source).multipleReturns()) {
                    source.validateExpression(mas, ids.getVariables(), currConstVars, conditional);
                } else {
                    throw new LanguageException("Unexpected error.");
                }
                if (!(source instanceof FunctionCallIdentifier)) break block11;
                for (int j = 0; j < targetList.size(); ++j) {
                    DataIdentifier target2 = targetList.get(j);
                    FunctionCallIdentifier fci = (FunctionCallIdentifier)source;
                    FunctionStatement fstmt = (FunctionStatement)this._dmlProg.getFunctionStatementBlock(fci.getNamespace(), fci.getName()).getStatement(0);
                    if (fstmt == null) {
                        fci.raiseValidateError(" function " + fci.getName() + " is undefined in namespace " + fci.getNamespace(), conditional);
                    }
                    if (!(target2 instanceof IndexedIdentifier)) {
                        target2.setProperties(fstmt.getOutputParams().get(j));
                    } else {
                        DataIdentifier targetAsSeen = ids.getVariable(target2.getName());
                        if (targetAsSeen == null) {
                            this.raiseValidateError(target2.printErrorLocation() + "cannot assign value to indexed identifier " + target2.toString() + " without first initializing " + target2.getName(), conditional);
                        }
                        target2.setProperties(targetAsSeen);
                    }
                    ids.addVariable(target2.getName(), target2);
                }
                break block12;
            }
            if (!(source instanceof BuiltinFunctionExpression) && !(source instanceof ParameterizedBuiltinFunctionExpression)) break block12;
            Identifier[] outputs = source.getOutputs();
            for (int j = 0; j < targetList.size(); ++j) {
                ids.addVariable(targetList.get(j).getName(), (DataIdentifier)outputs[j]);
            }
        }
    }

    public void setStatementFormatType(OutputStatement s, boolean conditionalValidate) {
        if (s.getExprParam("format") != null) {
            String ft;
            Expression formatTypeExpr = s.getExprParam("format");
            if (!(formatTypeExpr instanceof StringIdentifier)) {
                this.raiseValidateError("IO statement parameter format can only be a string with one of following values: binary, text, mm, csv.", false, "Invalid Parameters");
            }
            if ((ft = formatTypeExpr.toString()).equalsIgnoreCase("binary")) {
                s.getIdentifier().setFormatType(Expression.FormatType.BINARY);
            } else if (ft.equalsIgnoreCase("text")) {
                s.getIdentifier().setFormatType(Expression.FormatType.TEXT);
            } else if (ft.equalsIgnoreCase("mm")) {
                s.getIdentifier().setFormatType(Expression.FormatType.MM);
            } else if (ft.equalsIgnoreCase("csv")) {
                s.getIdentifier().setFormatType(Expression.FormatType.CSV);
            } else {
                this.raiseValidateError("IO statement parameter format can only be a string with one of following values: binary, text, mm, csv; invalid format: '" + ft + "'.", false, "Invalid Parameters");
            }
        } else {
            s.addExprParam("format", new StringIdentifier(Expression.FormatType.TEXT.toString(), s), true);
            s.getIdentifier().setFormatType(Expression.FormatType.TEXT);
        }
    }

    public void setStatementFormatType(AssignmentStatement s, boolean conditionalValidate) {
        if (!(s.getSource() instanceof DataExpression)) {
            return;
        }
        DataExpression dataExpr = (DataExpression)s.getSource();
        if (dataExpr.getVarParam("format") != null) {
            String ft;
            Expression formatTypeExpr = dataExpr.getVarParam("format");
            if (!(formatTypeExpr instanceof StringIdentifier)) {
                this.raiseValidateError("IO statement parameter format can only be a string with one of following values: binary, text", conditionalValidate, "Invalid Parameters");
            }
            if ((ft = formatTypeExpr.toString()).equalsIgnoreCase("binary")) {
                s.getTarget().setFormatType(Expression.FormatType.BINARY);
            } else if (ft.equalsIgnoreCase("text")) {
                s.getTarget().setFormatType(Expression.FormatType.TEXT);
            } else if (ft.equalsIgnoreCase("mm")) {
                s.getTarget().setFormatType(Expression.FormatType.MM);
            } else if (ft.equalsIgnoreCase("csv")) {
                s.getTarget().setFormatType(Expression.FormatType.CSV);
            } else {
                this.raiseValidateError("IO statement parameter format can only be a string with one of following values: binary, text, mm, csv", conditionalValidate, "Invalid Parameters");
            }
        } else {
            dataExpr.addVarParam("format", new StringIdentifier(Expression.FormatType.TEXT.toString(), dataExpr));
            s.getTarget().setFormatType(Expression.FormatType.TEXT);
        }
    }

    @Override
    public VariableSet initializeforwardLV(VariableSet activeIn) {
        for (Statement s : this._statements) {
            s.initializeforwardLV(activeIn);
            VariableSet read = s.variablesRead();
            VariableSet updated = s.variablesUpdated();
            if (s instanceof WhileStatement || s instanceof IfStatement || s instanceof ForStatement) {
                this.raiseValidateError("control statement (while / for / if) cannot be in generic statement block", false);
            }
            if (read != null) {
                for (String var : read.getVariableNames()) {
                    if (this._updated.containsVariable(var)) continue;
                    this._gen.addVariable(var, read.getVariable(var));
                }
            }
            this._read.addVariables(read);
            this._updated.addVariables(updated);
            if (updated == null) continue;
            for (String var : updated.getVariableNames()) {
                this._kill.addVariable(var, this._updated.getVariable(var));
            }
        }
        this._liveOut = new VariableSet();
        this._liveOut.addVariables(activeIn);
        this._liveOut.addVariables(this._updated);
        return this._liveOut;
    }

    @Override
    public VariableSet initializebackwardLV(VariableSet loPassed) {
        int numStatements = this._statements.size();
        VariableSet lo = new VariableSet(loPassed);
        for (int i = numStatements - 1; i >= 0; --i) {
            lo = this._statements.get(i).initializebackwardLV(lo);
        }
        return new VariableSet(lo);
    }

    public HashMap<String, ConstIdentifier> getConstIn() {
        return this._constVarsIn;
    }

    public HashMap<String, ConstIdentifier> getConstOut() {
        return this._constVarsOut;
    }

    @Override
    public VariableSet analyze(VariableSet loPassed) {
        VariableSet candidateLO = new VariableSet();
        candidateLO.addVariables(loPassed);
        VariableSet origLiveOut = new VariableSet();
        origLiveOut.addVariables(this._liveOut);
        this._liveOut = new VariableSet();
        for (String name : candidateLO.getVariableNames()) {
            if (!origLiveOut.containsVariable(name)) continue;
            this._liveOut.addVariable(name, candidateLO.getVariable(name));
        }
        this.initializebackwardLV(this._liveOut);
        this._liveIn = new VariableSet();
        this._liveIn.addVariables(this._liveOut);
        this._liveIn.removeVariables(this._kill);
        this._liveIn.addVariables(this._gen);
        VariableSet liveInReturn = new VariableSet();
        liveInReturn.addVariables(this._liveIn);
        return liveInReturn;
    }

    public void raiseValidateError(String msg, boolean conditional) {
        this.raiseValidateError(msg, conditional, null);
    }

    public void raiseValidateError(String msg, boolean conditional, String errorCode) {
        if (!conditional) {
            String fullMsg = this.printErrorLocation() + msg;
            if (errorCode != null) {
                throw new LanguageException(fullMsg, errorCode);
            }
            throw new LanguageException(fullMsg);
        }
        String fullMsg = this.printWarningLocation() + msg;
        LOG.warn(fullMsg);
    }

    @Override
    public void setFilename(String fname) {
        this._filename = fname;
    }

    @Override
    public void setBeginLine(int passed) {
        this._beginLine = passed;
    }

    @Override
    public void setBeginColumn(int passed) {
        this._beginColumn = passed;
    }

    @Override
    public void setEndLine(int passed) {
        this._endLine = passed;
    }

    @Override
    public void setEndColumn(int passed) {
        this._endColumn = passed;
    }

    @Override
    public void setText(String text) {
        this._text = text;
    }

    public void setParseInfo(ParseInfo parseInfo) {
        this._beginLine = parseInfo.getBeginLine();
        this._beginColumn = parseInfo.getBeginColumn();
        this._endLine = parseInfo.getEndLine();
        this._endColumn = parseInfo.getEndColumn();
        this._text = parseInfo.getText();
        this._filename = parseInfo.getFilename();
    }

    @Override
    public String getFilename() {
        return this._filename;
    }

    @Override
    public int getBeginLine() {
        return this._beginLine;
    }

    @Override
    public int getBeginColumn() {
        return this._beginColumn;
    }

    @Override
    public int getEndLine() {
        return this._endLine;
    }

    @Override
    public int getEndColumn() {
        return this._endColumn;
    }

    @Override
    public String getText() {
        return this._text;
    }

    public String printErrorLocation() {
        return "ERROR: " + this._filename + " -- line " + this._beginLine + ", column " + this._beginColumn + " -- ";
    }

    public String printBlockErrorLocation() {
        return "ERROR: " + this._filename + " -- statement block between lines " + this._beginLine + " and " + this._endLine + " -- ";
    }

    public String printWarningLocation() {
        return "WARNING: " + this._filename + " -- line " + this._beginLine + ", column " + this._beginColumn + " -- ";
    }

    public boolean updateRecompilationFlag() {
        this._requiresRecompile = ConfigurationManager.isDynamicRecompilation() && Recompiler.requiresRecompilation(this.getHops());
        return this._requiresRecompile;
    }

    public boolean requiresRecompilation() {
        return this._requiresRecompile;
    }

    public ArrayList<String> getUpdateInPlaceVars() {
        return this._updateInPlaceVars;
    }

    public void setUpdateInPlaceVars(ArrayList<String> vars) {
        this._updateInPlaceVars = vars;
    }
}

