/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.DelegationTokenRenewer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.web.ByteRangeInputStream;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.hdfs.web.TokenAspect;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.resources.AccessTimeParam;
import org.apache.hadoop.hdfs.web.resources.AclPermissionParam;
import org.apache.hadoop.hdfs.web.resources.BlockSizeParam;
import org.apache.hadoop.hdfs.web.resources.BufferSizeParam;
import org.apache.hadoop.hdfs.web.resources.ConcatSourcesParam;
import org.apache.hadoop.hdfs.web.resources.CreateParentParam;
import org.apache.hadoop.hdfs.web.resources.DelegationParam;
import org.apache.hadoop.hdfs.web.resources.DeleteOpParam;
import org.apache.hadoop.hdfs.web.resources.DestinationParam;
import org.apache.hadoop.hdfs.web.resources.DoAsParam;
import org.apache.hadoop.hdfs.web.resources.FsActionParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.GroupParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.ModificationTimeParam;
import org.apache.hadoop.hdfs.web.resources.OldSnapshotNameParam;
import org.apache.hadoop.hdfs.web.resources.OverwriteParam;
import org.apache.hadoop.hdfs.web.resources.OwnerParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PermissionParam;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.RecursiveParam;
import org.apache.hadoop.hdfs.web.resources.RenameOptionSetParam;
import org.apache.hadoop.hdfs.web.resources.ReplicationParam;
import org.apache.hadoop.hdfs.web.resources.SnapshotNameParam;
import org.apache.hadoop.hdfs.web.resources.TokenArgumentParam;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.hdfs.web.resources.XAttrEncodingParam;
import org.apache.hadoop.hdfs.web.resources.XAttrNameParam;
import org.apache.hadoop.hdfs.web.resources.XAttrSetFlagParam;
import org.apache.hadoop.hdfs.web.resources.XAttrValueParam;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSelector;
import org.apache.hadoop.util.Progressable;
import org.mortbay.util.ajax.JSON;

public class WebHdfsFileSystem
extends FileSystem
implements DelegationTokenRenewer.Renewable,
TokenAspect.TokenManagementDelegator {
    public static final Log LOG = LogFactory.getLog(WebHdfsFileSystem.class);
    public static final String SCHEME = "webhdfs";
    public static final int VERSION = 1;
    public static final String PATH_PREFIX = "/webhdfs/v1";
    protected URLConnectionFactory connectionFactory;
    public static final Text TOKEN_KIND = new Text("WEBHDFS delegation");
    @VisibleForTesting
    public static final String CANT_FALLBACK_TO_INSECURE_MSG = "The client is configured to only allow connecting to secure cluster";
    private boolean canRefreshDelegationToken;
    private UserGroupInformation ugi;
    private URI uri;
    private Token<?> delegationToken;
    protected Text tokenServiceName;
    private RetryPolicy retryPolicy = null;
    private Path workingDir;
    private InetSocketAddress[] nnAddrs;
    private int currentNNAddrIndex;
    private boolean disallowFallbackToInsecureCluster;
    TokenSelector<DelegationTokenIdentifier> tokenSelector = new AbstractDelegationTokenSelector<DelegationTokenIdentifier>(this.getTokenKind()){};
    private static final String OFFSET_PARAM_PREFIX = "offset=";

    @Override
    public String getScheme() {
        return SCHEME;
    }

    protected String getTransportScheme() {
        return "http";
    }

    protected Text getTokenKind() {
        return TOKEN_KIND;
    }

    @Override
    public synchronized void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        UserParam.setUserPattern((String)conf.get("dfs.webhdfs.user.provider.user.pattern", "^[A-Za-z_][A-Za-z0-9._-]*[$]?$"));
        this.connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory((Configuration)conf);
        this.ugi = UserGroupInformation.getCurrentUser();
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.nnAddrs = this.resolveNNAddr();
        boolean isHA = HAUtil.isClientFailoverConfigured((Configuration)conf, (URI)this.uri);
        boolean isLogicalUri = isHA && HAUtil.isLogicalUri((Configuration)conf, (URI)this.uri);
        Text text = this.tokenServiceName = isLogicalUri ? HAUtil.buildTokenServiceForLogicalUri((URI)uri, (String)this.getScheme()) : SecurityUtil.buildTokenService(this.getCanonicalUri());
        if (!isHA) {
            this.retryPolicy = RetryUtils.getDefaultRetryPolicy((Configuration)conf, (String)"dfs.http.client.retry.policy.enabled", (boolean)false, (String)"dfs.http.client.retry.policy.spec", (String)"10000,6,60000,10", SafeModeException.class);
        } else {
            int maxFailoverAttempts = conf.getInt("dfs.http.client.failover.max.attempts", 15);
            int maxRetryAttempts = conf.getInt("dfs.http.client.retry.max.attempts", 10);
            int failoverSleepBaseMillis = conf.getInt("dfs.http.client.failover.sleep.base.millis", 500);
            int failoverSleepMaxMillis = conf.getInt("dfs.http.client.failover.sleep.max.millis", 15000);
            this.retryPolicy = RetryPolicies.failoverOnNetworkException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, (int)maxFailoverAttempts, (int)maxRetryAttempts, (long)failoverSleepBaseMillis, (long)failoverSleepMaxMillis);
        }
        this.workingDir = this.getHomeDirectory();
        this.canRefreshDelegationToken = UserGroupInformation.isSecurityEnabled();
        this.disallowFallbackToInsecureCluster = !conf.getBoolean("ipc.client.fallback-to-simple-auth-allowed", false);
        this.delegationToken = null;
    }

    @Override
    public URI getCanonicalUri() {
        return super.getCanonicalUri();
    }

    public static boolean isEnabled(Configuration conf, Log log) {
        boolean b = conf.getBoolean("dfs.webhdfs.enabled", true);
        return b;
    }

    protected synchronized Token<?> getDelegationToken() throws IOException {
        if (this.canRefreshDelegationToken && this.delegationToken == null) {
            Token<DelegationTokenIdentifier> token = this.tokenSelector.selectToken(new Text(this.getCanonicalServiceName()), this.ugi.getTokens());
            if (token != null) {
                LOG.debug("Using UGI token: " + token);
                this.canRefreshDelegationToken = false;
            } else {
                token = this.getDelegationToken(null);
                if (token != null) {
                    LOG.debug("Fetched new token: " + token);
                } else {
                    this.canRefreshDelegationToken = false;
                }
            }
            this.setDelegationToken(token);
        }
        return this.delegationToken;
    }

    @VisibleForTesting
    synchronized boolean replaceExpiredDelegationToken() throws IOException {
        boolean replaced = false;
        if (this.canRefreshDelegationToken) {
            Token<DelegationTokenIdentifier> token = this.getDelegationToken(null);
            LOG.debug("Replaced expired token: " + token);
            this.setDelegationToken(token);
            replaced = token != null;
        }
        return replaced;
    }

    @Override
    @VisibleForTesting
    public int getDefaultPort() {
        return this.getConf().getInt("dfs.http.port", 50070);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    protected URI canonicalizeUri(URI uri) {
        return NetUtils.getCanonicalUri((URI)uri, (int)this.getDefaultPort());
    }

    public static String getHomeDirectoryString(UserGroupInformation ugi) {
        return "/user/" + ugi.getShortUserName();
    }

    @Override
    public Path getHomeDirectory() {
        return this.makeQualified(new Path(WebHdfsFileSystem.getHomeDirectoryString(this.ugi)));
    }

    @Override
    public synchronized Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public synchronized void setWorkingDirectory(Path dir) {
        String result = this.makeAbsolute(dir).toUri().getPath();
        if (!DFSUtil.isValidName((String)result)) {
            throw new IllegalArgumentException("Invalid DFS directory name " + result);
        }
        this.workingDir = this.makeAbsolute(dir);
    }

    private Path makeAbsolute(Path f) {
        return f.isAbsolute() ? f : new Path(this.workingDir, f);
    }

    static Map<?, ?> jsonParse(HttpURLConnection c, boolean useErrorStream) throws IOException {
        MediaType parsed;
        InputStream in;
        if (c.getContentLength() == 0) {
            return null;
        }
        InputStream inputStream = in = useErrorStream ? c.getErrorStream() : c.getInputStream();
        if (in == null) {
            throw new IOException("The " + (useErrorStream ? "error" : "input") + " stream is null.");
        }
        String contentType = c.getContentType();
        if (contentType != null && !MediaType.APPLICATION_JSON_TYPE.isCompatible(parsed = MediaType.valueOf((String)contentType))) {
            throw new IOException("Content-Type \"" + contentType + "\" is incompatible with \"" + "application/json" + "\" (parsed=\"" + parsed + "\")");
        }
        return (Map)JSON.parse((Reader)new InputStreamReader(in, Charsets.UTF_8));
    }

    private static Map<?, ?> validateResponse(HttpOpParam.Op op, HttpURLConnection conn, boolean unwrapException) throws IOException {
        int code = conn.getResponseCode();
        if (code == 401) {
            throw new AccessControlException(conn.getResponseMessage());
        }
        if (code != op.getExpectedHttpResponseCode()) {
            Map<?, ?> m;
            try {
                m = WebHdfsFileSystem.jsonParse(conn, true);
            }
            catch (Exception e) {
                throw new IOException("Unexpected HTTP response: code=" + code + " != " + op.getExpectedHttpResponseCode() + ", " + op.toQueryString() + ", message=" + conn.getResponseMessage(), e);
            }
            if (m == null) {
                throw new IOException("Unexpected HTTP response: code=" + code + " != " + op.getExpectedHttpResponseCode() + ", " + op.toQueryString() + ", message=" + conn.getResponseMessage());
            }
            if (m.get(RemoteException.class.getSimpleName()) == null) {
                return m;
            }
            IOException re = JsonUtil.toRemoteException(m);
            if (re.getMessage() != null && re.getMessage().startsWith("Failed to obtain user group information:")) {
                String[] parts = re.getMessage().split(":\\s+", 3);
                re = new RemoteException(parts[1], parts[2]);
                re = re.unwrapRemoteException(SecretManager.InvalidToken.class);
            }
            throw unwrapException ? WebHdfsFileSystem.toIOException(re) : re;
        }
        return null;
    }

    private static IOException toIOException(Exception e) {
        if (!(e instanceof IOException)) {
            return new IOException(e);
        }
        IOException ioe = (IOException)e;
        if (!(ioe instanceof RemoteException)) {
            return ioe;
        }
        return ((RemoteException)ioe).unwrapRemoteException();
    }

    private synchronized InetSocketAddress getCurrentNNAddr() {
        return this.nnAddrs[this.currentNNAddrIndex];
    }

    private synchronized void resetStateToFailOver() {
        this.currentNNAddrIndex = (this.currentNNAddrIndex + 1) % this.nnAddrs.length;
    }

    private URL getNamenodeURL(String path, String query) throws IOException {
        InetSocketAddress nnAddr = this.getCurrentNNAddr();
        URL url = new URL(this.getTransportScheme(), nnAddr.getHostName(), nnAddr.getPort(), path + '?' + query);
        if (LOG.isTraceEnabled()) {
            LOG.trace("url=" + url);
        }
        return url;
    }

    Param<?, ?>[] getAuthParameters(HttpOpParam.Op op) throws IOException {
        ArrayList<Object> authParams = Lists.newArrayList();
        Token<?> token = null;
        if (!op.getRequireAuth()) {
            token = this.getDelegationToken();
        }
        if (token != null) {
            authParams.add(new DelegationParam(token.encodeToUrlString()));
        } else {
            UserGroupInformation userUgi = this.ugi;
            UserGroupInformation realUgi = userUgi.getRealUser();
            if (realUgi != null) {
                authParams.add(new DoAsParam(userUgi.getShortUserName()));
                userUgi = realUgi;
            }
            authParams.add(new UserParam(userUgi.getShortUserName()));
        }
        return authParams.toArray(new Param[0]);
    }

    URL toUrl(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) throws IOException {
        String path = PATH_PREFIX + (fspath == null ? "/" : this.makeQualified(fspath).toUri().getRawPath());
        String query = op.toQueryString() + Param.toSortedString((String)"&", this.getAuthParameters(op)) + Param.toSortedString((String)"&", parameters);
        URL url = this.getNamenodeURL(path, query);
        if (LOG.isTraceEnabled()) {
            LOG.trace("url=" + url);
        }
        return url;
    }

    private FsPermission applyUMask(FsPermission permission) {
        if (permission == null) {
            permission = FsPermission.getDefault();
        }
        return permission.applyUMask(FsPermission.getUMask(this.getConf()));
    }

    private HdfsFileStatus getHdfsFileStatus(Path f) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETFILESTATUS;
        HdfsFileStatus status = (HdfsFileStatus)new /* Unavailable Anonymous Inner Class!! */.run();
        if (status == null) {
            throw new FileNotFoundException("File does not exist: " + f);
        }
        return status;
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        return this.makeQualified(this.getHdfsFileStatus(f), f);
    }

    private FileStatus makeQualified(HdfsFileStatus f, Path parent) {
        return new FileStatus(f.getLen(), f.isDir(), f.getReplication(), f.getBlockSize(), f.getModificationTime(), f.getAccessTime(), f.getPermission(), f.getOwner(), f.getGroup(), f.isSymlink() ? new Path(f.getSymlink()) : null, f.getFullPath(parent).makeQualified(this.getUri(), this.getWorkingDirectory()));
    }

    @Override
    public AclStatus getAclStatus(Path f) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETACLSTATUS;
        AclStatus status = (AclStatus)new /* Unavailable Anonymous Inner Class!! */.run();
        if (status == null) {
            throw new FileNotFoundException("File does not exist: " + f);
        }
        return status;
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.MKDIRS;
        return (Boolean)new FsPathBooleanRunner(this, (HttpOpParam.Op)op, f, new Param[]{new PermissionParam(this.applyUMask(permission))}).run();
    }

    @Override
    public void createSymlink(Path destination, Path f, boolean createParent) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.CREATESYMLINK;
        new FsPathRunner(this, (HttpOpParam.Op)op, f, new Param[]{new DestinationParam(this.makeQualified(destination).toUri().getPath()), new CreateParentParam(Boolean.valueOf(createParent))}).run();
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.RENAME;
        return (Boolean)new FsPathBooleanRunner(this, (HttpOpParam.Op)op, src, new Param[]{new DestinationParam(this.makeQualified(dst).toUri().getPath())}).run();
    }

    @Override
    public void rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.RENAME;
        new FsPathRunner(this, (HttpOpParam.Op)op, src, new Param[]{new DestinationParam(this.makeQualified(dst).toUri().getPath()), new RenameOptionSetParam(options)}).run();
    }

    @Override
    public void setXAttr(Path p, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETXATTR;
        if (value != null) {
            new FsPathRunner(this, (HttpOpParam.Op)op, p, new Param[]{new XAttrNameParam(name), new XAttrValueParam(XAttrCodec.encodeValue((byte[])value, (XAttrCodec)XAttrCodec.HEX)), new XAttrSetFlagParam(flag)}).run();
        } else {
            new FsPathRunner(this, (HttpOpParam.Op)op, p, new Param[]{new XAttrNameParam(name), new XAttrSetFlagParam(flag)}).run();
        }
    }

    @Override
    public byte[] getXAttr(Path p, String name) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETXATTRS;
        return (byte[])new /* Unavailable Anonymous Inner Class!! */.run();
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path p) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETXATTRS;
        return (Map)new /* Unavailable Anonymous Inner Class!! */.run();
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path p, List<String> names) throws IOException {
        Preconditions.checkArgument(names != null && !names.isEmpty(), "XAttr names cannot be null or empty.");
        Param[] parameters = new Param[names.size() + 1];
        for (int i = 0; i < parameters.length - 1; ++i) {
            parameters[i] = new XAttrNameParam(names.get(i));
        }
        parameters[parameters.length - 1] = new XAttrEncodingParam(XAttrCodec.HEX);
        GetOpParam.Op op = GetOpParam.Op.GETXATTRS;
        return (Map)new /* Unavailable Anonymous Inner Class!! */.run();
    }

    @Override
    public List<String> listXAttrs(Path p) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.LISTXATTRS;
        return (List)new /* Unavailable Anonymous Inner Class!! */.run();
    }

    @Override
    public void removeXAttr(Path p, String name) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.REMOVEXATTR;
        new FsPathRunner(this, (HttpOpParam.Op)op, p, new Param[]{new XAttrNameParam(name)}).run();
    }

    @Override
    public void setOwner(Path p, String owner, String group) throws IOException {
        if (owner == null && group == null) {
            throw new IOException("owner == null && group == null");
        }
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETOWNER;
        new FsPathRunner(this, (HttpOpParam.Op)op, p, new Param[]{new OwnerParam(owner), new GroupParam(group)}).run();
    }

    @Override
    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETPERMISSION;
        new FsPathRunner(this, (HttpOpParam.Op)op, p, new Param[]{new PermissionParam(permission)}).run();
    }

    @Override
    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.MODIFYACLENTRIES;
        new FsPathRunner(this, (HttpOpParam.Op)op, path, new Param[]{new AclPermissionParam(aclSpec)}).run();
    }

    @Override
    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.REMOVEACLENTRIES;
        new FsPathRunner(this, (HttpOpParam.Op)op, path, new Param[]{new AclPermissionParam(aclSpec)}).run();
    }

    @Override
    public void removeDefaultAcl(Path path) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.REMOVEDEFAULTACL;
        new FsPathRunner(this, (HttpOpParam.Op)op, path, new Param[0]).run();
    }

    @Override
    public void removeAcl(Path path) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.REMOVEACL;
        new FsPathRunner(this, (HttpOpParam.Op)op, path, new Param[0]).run();
    }

    @Override
    public void setAcl(Path p, List<AclEntry> aclSpec) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETACL;
        new FsPathRunner(this, (HttpOpParam.Op)op, p, new Param[]{new AclPermissionParam(aclSpec)}).run();
    }

    @Override
    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.CREATESNAPSHOT;
        Path spath = (Path)new /* Unavailable Anonymous Inner Class!! */.run();
        return spath;
    }

    @Override
    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        this.statistics.incrementWriteOps(1);
        DeleteOpParam.Op op = DeleteOpParam.Op.DELETESNAPSHOT;
        new FsPathRunner(this, (HttpOpParam.Op)op, path, new Param[]{new SnapshotNameParam(snapshotName)}).run();
    }

    @Override
    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.RENAMESNAPSHOT;
        new FsPathRunner(this, (HttpOpParam.Op)op, path, new Param[]{new OldSnapshotNameParam(snapshotOldName), new SnapshotNameParam(snapshotNewName)}).run();
    }

    @Override
    public boolean setReplication(Path p, short replication) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETREPLICATION;
        return (Boolean)new FsPathBooleanRunner(this, (HttpOpParam.Op)op, p, new Param[]{new ReplicationParam(Short.valueOf(replication))}).run();
    }

    @Override
    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETTIMES;
        new FsPathRunner(this, (HttpOpParam.Op)op, p, new Param[]{new ModificationTimeParam(Long.valueOf(mtime)), new AccessTimeParam(Long.valueOf(atime))}).run();
    }

    @Override
    public long getDefaultBlockSize() {
        return this.getConf().getLongBytes("dfs.blocksize", 0x8000000L);
    }

    @Override
    public short getDefaultReplication() {
        return (short)this.getConf().getInt("dfs.replication", 3);
    }

    @Override
    public void concat(Path trg, Path[] srcs) throws IOException {
        this.statistics.incrementWriteOps(1);
        PostOpParam.Op op = PostOpParam.Op.CONCAT;
        new FsPathRunner(this, (HttpOpParam.Op)op, trg, new Param[]{new ConcatSourcesParam(srcs)}).run();
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.CREATE;
        return (FSDataOutputStream)new FsPathOutputStreamRunner(this, (HttpOpParam.Op)op, f, bufferSize, new Param[]{new PermissionParam(this.applyUMask(permission)), new OverwriteParam(Boolean.valueOf(overwrite)), new BufferSizeParam(Integer.valueOf(bufferSize)), new ReplicationParam(Short.valueOf(replication)), new BlockSizeParam(Long.valueOf(blockSize))}).run();
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        PostOpParam.Op op = PostOpParam.Op.APPEND;
        return (FSDataOutputStream)new FsPathOutputStreamRunner(this, (HttpOpParam.Op)op, f, bufferSize, new Param[]{new BufferSizeParam(Integer.valueOf(bufferSize))}).run();
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        DeleteOpParam.Op op = DeleteOpParam.Op.DELETE;
        return (Boolean)new FsPathBooleanRunner(this, (HttpOpParam.Op)op, f, new Param[]{new RecursiveParam(Boolean.valueOf(recursive))}).run();
    }

    @Override
    public FSDataInputStream open(Path f, int buffersize) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.OPEN;
        FsPathConnectionRunner runner = new FsPathConnectionRunner(this, (HttpOpParam.Op)op, f, new Param[]{new BufferSizeParam(Integer.valueOf(buffersize))});
        return new FSDataInputStream(new OffsetUrlInputStream(new UnresolvedUrlOpener(this, runner), new OffsetUrlOpener(this, null)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        try {
            if (this.canRefreshDelegationToken && this.delegationToken != null) {
                this.cancelDelegationToken(this.delegationToken);
            }
        }
        catch (IOException ioe) {
            LOG.debug("Token cancel failed: " + ioe);
        }
        finally {
            super.close();
        }
    }

    static URL removeOffsetParam(URL url) throws MalformedURLException {
        String query = url.getQuery();
        if (query == null) {
            return url;
        }
        String lower = query.toLowerCase();
        if (!lower.startsWith(OFFSET_PARAM_PREFIX) && !lower.contains("&offset=")) {
            return url;
        }
        StringBuilder b = null;
        StringTokenizer st = new StringTokenizer(query, "&");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.toLowerCase().startsWith(OFFSET_PARAM_PREFIX)) continue;
            if (b == null) {
                b = new StringBuilder("?").append(token);
                continue;
            }
            b.append('&').append(token);
        }
        query = b == null ? "" : b.toString();
        String urlStr = url.toString();
        return new URL(urlStr.substring(0, urlStr.indexOf(63)) + query);
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.LISTSTATUS;
        return (FileStatus[])new /* Unavailable Anonymous Inner Class!! */.run();
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETDELEGATIONTOKEN;
        Token token = (Token)new /* Unavailable Anonymous Inner Class!! */.run();
        if (token != null) {
            token.setService(this.tokenServiceName);
        } else if (this.disallowFallbackToInsecureCluster) {
            throw new AccessControlException(CANT_FALLBACK_TO_INSECURE_MSG);
        }
        return token;
    }

    @Override
    public synchronized Token<?> getRenewToken() {
        return this.delegationToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends TokenIdentifier> void setDelegationToken(Token<T> token) {
        WebHdfsFileSystem webHdfsFileSystem = this;
        synchronized (webHdfsFileSystem) {
            this.delegationToken = token;
        }
    }

    @Override
    public synchronized long renewDelegationToken(Token<?> token) throws IOException {
        PutOpParam.Op op = PutOpParam.Op.RENEWDELEGATIONTOKEN;
        return (Long)new /* Unavailable Anonymous Inner Class!! */.run();
    }

    @Override
    public synchronized void cancelDelegationToken(Token<?> token) throws IOException {
        PutOpParam.Op op = PutOpParam.Op.CANCELDELEGATIONTOKEN;
        new FsPathRunner(this, (HttpOpParam.Op)op, null, new Param[]{new TokenArgumentParam(token.encodeToUrlString())}).run();
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus status, long offset, long length) throws IOException {
        if (status == null) {
            return null;
        }
        return this.getFileBlockLocations(status.getPath(), offset, length);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(Path p, long offset, long length) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.GET_BLOCK_LOCATIONS;
        return (BlockLocation[])new /* Unavailable Anonymous Inner Class!! */.run();
    }

    @Override
    public void access(Path path, FsAction mode) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.CHECKACCESS;
        new FsPathRunner(this, (HttpOpParam.Op)op, path, new Param[]{new FsActionParam(mode)}).run();
    }

    @Override
    public ContentSummary getContentSummary(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.GETCONTENTSUMMARY;
        return (ContentSummary)new /* Unavailable Anonymous Inner Class!! */.run();
    }

    @Override
    public MD5MD5CRC32FileChecksum getFileChecksum(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.GETFILECHECKSUM;
        return (MD5MD5CRC32FileChecksum)new /* Unavailable Anonymous Inner Class!! */.run();
    }

    private InetSocketAddress[] resolveNNAddr() throws IOException {
        Configuration conf = this.getConf();
        String scheme = this.uri.getScheme();
        ArrayList<InetSocketAddress> ret = new ArrayList<InetSocketAddress>();
        if (!HAUtil.isLogicalUri((Configuration)conf, (URI)this.uri)) {
            InetSocketAddress addr = NetUtils.createSocketAddr((String)this.uri.getAuthority(), (int)this.getDefaultPort());
            ret.add(addr);
        } else {
            Map addresses = DFSUtil.getHaNnWebHdfsAddresses((Configuration)conf, (String)scheme);
            Map addrs = (Map)addresses.get(this.uri.getHost());
            for (InetSocketAddress addr : addrs.values()) {
                ret.add(addr);
            }
        }
        InetSocketAddress[] r = new InetSocketAddress[ret.size()];
        return ret.toArray(r);
    }

    @Override
    public String getCanonicalServiceName() {
        return this.tokenServiceName == null ? super.getCanonicalServiceName() : this.tokenServiceName.toString();
    }

    @VisibleForTesting
    InetSocketAddress[] getResolvedNNAddr() {
        return this.nnAddrs;
    }

    static /* synthetic */ UserGroupInformation access$000(WebHdfsFileSystem x0) {
        return x0.ugi;
    }

    static /* synthetic */ Map access$200(HttpOpParam.Op x0, HttpURLConnection x1, boolean x2) throws IOException {
        return WebHdfsFileSystem.validateResponse(x0, x1, x2);
    }

    static /* synthetic */ InetSocketAddress access$300(WebHdfsFileSystem x0) {
        return x0.getCurrentNNAddr();
    }

    static /* synthetic */ RetryPolicy access$400(WebHdfsFileSystem x0) {
        return x0.retryPolicy;
    }

    static /* synthetic */ void access$500(WebHdfsFileSystem x0) {
        x0.resetStateToFailOver();
    }

    static /* synthetic */ IOException access$600(Exception x0) {
        return WebHdfsFileSystem.toIOException(x0);
    }

    static /* synthetic */ FileSystem.Statistics access$700(WebHdfsFileSystem x0) {
        return x0.statistics;
    }

    static /* synthetic */ FileStatus access$800(WebHdfsFileSystem x0, HdfsFileStatus x1, Path x2) {
        return x0.makeQualified(x1, x2);
    }

    static class OffsetUrlInputStream
    extends ByteRangeInputStream {
        OffsetUrlInputStream(UnresolvedUrlOpener o, OffsetUrlOpener r) throws IOException {
            super((ByteRangeInputStream.URLOpener)o, (ByteRangeInputStream.URLOpener)r);
        }

        @Override
        protected URL getResolvedUrl(HttpURLConnection connection) throws MalformedURLException {
            return WebHdfsFileSystem.removeOffsetParam(connection.getURL());
        }
    }
}

