/*
 * Decompiled with CFR 0.152.
 */
package kafka.shaded.tools;

import java.util.concurrent.CountDownLatch;
import kafka.shaded.api.FetchRequest;
import kafka.shaded.api.FetchRequestBuilder;
import kafka.shaded.api.FetchResponse;
import kafka.shaded.api.FetchResponsePartitionData;
import kafka.shaded.api.FetchResponsePartitionData$;
import kafka.shaded.api.Request$;
import kafka.shaded.cluster.Broker;
import kafka.shaded.common.TopicAndPartition;
import kafka.shaded.consumer.SimpleConsumer;
import kafka.shaded.message.ByteBufferMessageSet;
import kafka.shaded.message.MessageSet$;
import kafka.shaded.tools.ReplicaBuffer;
import kafka.shaded.tools.ReplicaVerificationTool$;
import kafka.shaded.utils.ShutdownableThread;
import kafka.shaded.utils.ShutdownableThread$;
import scala.Function0;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0005\u000f\tq!+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014(BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u000bU$\u0018\u000e\\:\n\u00055Q!AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012D\u0011b\u0004\u0001\u0003\u0002\u0003\u0006I\u0001\u0005\u000e\u0002\t9\fW.\u001a\t\u0003#]q!AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\ta\u0001\u0015:fI\u00164\u0017B\u0001\r\u001a\u0005\u0019\u0019FO]5oO*\u0011acE\u0005\u0003\u001f1A\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0003=\u0005j\u0011a\b\u0006\u0003A\u0011\tqa\u00197vgR,'/\u0003\u0002#?\t1!I]8lKJD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0013i>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t7\u000fE\u0002']Er!a\n\u0017\u000f\u0005!ZS\"A\u0015\u000b\u0005)2\u0011A\u0002\u001fs_>$h(C\u0001\u0015\u0013\ti3#A\u0004qC\u000e\\\u0017mZ3\n\u0005=\u0002$\u0001C%uKJ\f'\r\\3\u000b\u00055\u001a\u0002C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0005\u0003\u0019\u0019w.\\7p]&\u0011ag\r\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u001bI,\u0007\u000f\\5dC\n+hMZ3s!\tQ4(D\u0001\u0003\u0013\ta$AA\u0007SKBd\u0017nY1Ck\u001a4WM\u001d\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f\u0005i1o\\2lKR$\u0016.\\3pkR\u0004\"A\u0005!\n\u0005\u0005\u001b\"aA%oi\"A1\t\u0001B\u0001B\u0003%q(\u0001\tt_\u000e\\W\r\u001e\"vM\u001a,'oU5{K\"AQ\t\u0001B\u0001B\u0003%q(A\u0005gKR\u001c\u0007nU5{K\"Aq\t\u0001B\u0001B\u0003%q(A\u0004nCb<\u0016-\u001b;\t\u0011%\u0003!\u0011!Q\u0001\n}\n\u0001\"\\5o\u0005f$Xm\u001d\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\u0006qAm\u001c,fe&4\u0017nY1uS>t\u0007C\u0001\nN\u0013\tq5CA\u0004C_>dW-\u00198\t\u000bA\u0003A\u0011A)\u0002\rqJg.\u001b;?)-\u00116\u000bV+W/bK&l\u0017/\u0011\u0005i\u0002\u0001\"B\bP\u0001\u0004\u0001\u0002\"\u0002\u000fP\u0001\u0004i\u0002\"\u0002\u0013P\u0001\u0004)\u0003\"\u0002\u001dP\u0001\u0004I\u0004\"\u0002 P\u0001\u0004y\u0004\"B\"P\u0001\u0004y\u0004\"B#P\u0001\u0004y\u0004\"B$P\u0001\u0004y\u0004\"B%P\u0001\u0004y\u0004\"B&P\u0001\u0004a\u0005b\u00020\u0001\u0005\u0004%\taX\u0001\u000fg&l\u0007\u000f\\3D_:\u001cX/\\3s+\u0005\u0001\u0007CA1e\u001b\u0005\u0011'BA2\u0005\u0003!\u0019wN\\:v[\u0016\u0014\u0018BA3c\u00059\u0019\u0016.\u001c9mK\u000e{gn];nKJDaa\u001a\u0001!\u0002\u0013\u0001\u0017aD:j[BdWmQ8ogVlWM\u001d\u0011\t\u000f%\u0004!\u0019!C\u0001U\u0006\u0019b-\u001a;dQJ+\u0017/^3ti\n+\u0018\u000e\u001c3feV\t1\u000e\u0005\u0002m_6\tQN\u0003\u0002o\t\u0005\u0019\u0011\r]5\n\u0005Al'a\u0005$fi\u000eD'+Z9vKN$()^5mI\u0016\u0014\bB\u0002:\u0001A\u0003%1.\u0001\u000bgKR\u001c\u0007NU3rk\u0016\u001cHOQ;jY\u0012,'\u000f\t\u0005\u0006i\u0002!\t%^\u0001\u0007I><vN]6\u0015\u0003Y\u0004\"AE<\n\u0005a\u001c\"\u0001B+oSR\u0004")
public class ReplicaFetcher
extends ShutdownableThread {
    public final Broker kafka$tools$ReplicaFetcher$$sourceBroker;
    private final Iterable<TopicAndPartition> topicAndPartitions;
    public final ReplicaBuffer kafka$tools$ReplicaFetcher$$replicaBuffer;
    public final int kafka$tools$ReplicaFetcher$$fetchSize;
    private final boolean doVerification;
    private final SimpleConsumer simpleConsumer;
    private final FetchRequestBuilder fetchRequestBuilder;

    public SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    public FetchRequestBuilder fetchRequestBuilder() {
        return this.fetchRequestBuilder;
    }

    @Override
    public void doWork() {
        CountDownLatch verificationBarrier;
        CountDownLatch fetcherBarrier;
        block5: {
            FetchResponse response;
            block4: {
                fetcherBarrier = this.kafka$tools$ReplicaFetcher$$replicaBuffer.getFetcherBarrier();
                verificationBarrier = this.kafka$tools$ReplicaFetcher$$replicaBuffer.getVerificationBarrier();
                this.topicAndPartitions.foreach(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaFetcher $outer;

                    public final FetchRequestBuilder apply(TopicAndPartition topicAndPartition) {
                        return this.$outer.fetchRequestBuilder().addFetch(topicAndPartition.topic(), topicAndPartition.partition(), this.$outer.kafka$tools$ReplicaFetcher$$replicaBuffer.getOffset(topicAndPartition), this.$outer.kafka$tools$ReplicaFetcher$$fetchSize);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                FetchRequest fetchRequest = this.fetchRequestBuilder().build();
                this.debug((Function0<String>)((Object)new Serializable(this, fetchRequest){
                    public static final long serialVersionUID = 0L;
                    private final FetchRequest fetchRequest$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Issuing fetch request ").append(this.fetchRequest$1).toString();
                    }
                    {
                        this.fetchRequest$1 = fetchRequest$1;
                    }
                }));
                response = null;
                try {
                    response = this.simpleConsumer().fetch(fetchRequest);
                }
                finally {
                    if (response != null) break block4;
                }
                this.topicAndPartitions.foreach(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaFetcher $outer;

                    public final void apply(TopicAndPartition topicAndPartition) {
                        ByteBufferMessageSet x$9 = MessageSet$.MODULE$.Empty();
                        short x$10 = FetchResponsePartitionData$.MODULE$.$lessinit$greater$default$1();
                        long x$11 = FetchResponsePartitionData$.MODULE$.$lessinit$greater$default$2();
                        this.$outer.kafka$tools$ReplicaFetcher$$replicaBuffer.addFetchedData(topicAndPartition, this.$outer.kafka$tools$ReplicaFetcher$$sourceBroker.id(), new FetchResponsePartitionData(x$10, x$11, x$9));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                break block5;
            }
            response.data().foreach(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaFetcher $outer;

                public final void apply(Tuple2<TopicAndPartition, FetchResponsePartitionData> x0$9) {
                    Tuple2<TopicAndPartition, FetchResponsePartitionData> tuple2 = x0$9;
                    if (tuple2 != null) {
                        TopicAndPartition topicAndPartition = tuple2._1();
                        FetchResponsePartitionData partitionData = tuple2._2();
                        this.$outer.kafka$tools$ReplicaFetcher$$replicaBuffer.addFetchedData(topicAndPartition, this.$outer.kafka$tools$ReplicaFetcher$$sourceBroker.id(), partitionData);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        fetcherBarrier.countDown();
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Done fetching";
            }
        }));
        fetcherBarrier.await();
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Ready for verification";
            }
        }));
        if (this.doVerification) {
            this.debug((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Do verification";
                }
            }));
            this.kafka$tools$ReplicaFetcher$$replicaBuffer.verifyCheckSum();
            this.kafka$tools$ReplicaFetcher$$replicaBuffer.createNewFetcherBarrier();
            this.kafka$tools$ReplicaFetcher$$replicaBuffer.createNewVerificationBarrier();
            this.debug((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Created new barrier";
                }
            }));
            verificationBarrier.countDown();
        }
        verificationBarrier.await();
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Done verification";
            }
        }));
    }

    public ReplicaFetcher(String name, Broker sourceBroker, Iterable<TopicAndPartition> topicAndPartitions, ReplicaBuffer replicaBuffer, int socketTimeout, int socketBufferSize, int fetchSize, int maxWait, int minBytes, boolean doVerification) {
        this.kafka$tools$ReplicaFetcher$$sourceBroker = sourceBroker;
        this.topicAndPartitions = topicAndPartitions;
        this.kafka$tools$ReplicaFetcher$$replicaBuffer = replicaBuffer;
        this.kafka$tools$ReplicaFetcher$$fetchSize = fetchSize;
        this.doVerification = doVerification;
        super(name, ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        this.simpleConsumer = new SimpleConsumer(sourceBroker.host(), sourceBroker.port(), socketTimeout, socketBufferSize, ReplicaVerificationTool$.MODULE$.clientId());
        this.fetchRequestBuilder = new FetchRequestBuilder().clientId(ReplicaVerificationTool$.MODULE$.clientId()).replicaId(Request$.MODULE$.DebuggingConsumerId()).maxWait(maxWait).minBytes(minBytes);
    }
}

