/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.IOUtils;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;

public class OperationLog {
    private static final Log LOG = LogFactory.getLog((String)OperationLog.class.getName());
    private final String operationName;
    private final LogFile logFile;
    private static final ThreadLocal<OperationLog> THREAD_LOCAL_OPERATION_LOG = new ThreadLocal<OperationLog>(){

        @Override
        protected synchronized OperationLog initialValue() {
            return null;
        }
    };

    public OperationLog(String name, File file) throws FileNotFoundException {
        this.operationName = name;
        this.logFile = new LogFile(file);
    }

    public static void setCurrentOperationLog(OperationLog operationLog) {
        THREAD_LOCAL_OPERATION_LOG.set(operationLog);
    }

    public static OperationLog getCurrentOperationLog() {
        return THREAD_LOCAL_OPERATION_LOG.get();
    }

    public static void removeCurrentOperationLog() {
        THREAD_LOCAL_OPERATION_LOG.remove();
    }

    public void writeOperationLog(String operationLogMessage) {
        this.logFile.write(operationLogMessage);
    }

    public List<String> readOperationLog(FetchOrientation fetchOrientation, long maxRows) throws HiveSQLException {
        return this.logFile.read(fetchOrientation, maxRows);
    }

    public void close() {
        this.logFile.remove();
    }

    private class LogFile {
        private File file;
        private BufferedReader in;
        private PrintStream out;
        private volatile boolean isRemoved;

        LogFile(File file) throws FileNotFoundException {
            this.file = file;
            this.in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            this.out = new PrintStream(new FileOutputStream(file));
            this.isRemoved = false;
        }

        synchronized void write(String msg) {
            this.out.print(msg);
        }

        synchronized List<String> read(FetchOrientation fetchOrientation, long maxRows) throws HiveSQLException {
            if (fetchOrientation.equals((Object)FetchOrientation.FETCH_FIRST)) {
                this.resetIn();
            }
            return this.readResults(maxRows);
        }

        void remove() {
            try {
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
                FileUtils.forceDelete((File)this.file);
                this.isRemoved = true;
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to remove corresponding log file of operation: " + OperationLog.this.operationName), (Throwable)e);
            }
        }

        private void resetIn() {
            if (this.in != null) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.in});
                this.in = null;
            }
        }

        private List<String> readResults(long nLines) throws HiveSQLException {
            if (this.in == null) {
                try {
                    this.in = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));
                }
                catch (FileNotFoundException e) {
                    if (this.isRemoved) {
                        throw new HiveSQLException("The operation has been closed and its log file " + this.file.getAbsolutePath() + " has been removed.", e);
                    }
                    throw new HiveSQLException("Operation Log file " + this.file.getAbsolutePath() + " is not found.", e);
                }
            }
            ArrayList<String> logs = new ArrayList<String>();
            String line = "";
            int i = 0;
            while ((long)i < nLines || nLines <= 0L) {
                try {
                    line = this.in.readLine();
                    if (line == null) break;
                    logs.add(line);
                }
                catch (IOException e) {
                    if (this.isRemoved) {
                        throw new HiveSQLException("The operation has been closed and its log file " + this.file.getAbsolutePath() + " has been removed.", e);
                    }
                    throw new HiveSQLException("Reading operation log file encountered an exception: ", e);
                }
                ++i;
            }
            return logs;
        }
    }
}

