/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler.impl.operator;

import java.util.EnumMap;
import java.util.Map;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.UnaryOperator;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.BinaryOpGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.ComparisonOpGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.ConcatenateOpGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.EquivalenceOpGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.InOpGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.IsWhiteSpaceGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.LengthOpGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.LogicalOpGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.LongOpGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.NotOpGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.NumericOpGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.StrictEqGenOp;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.UnaryOpGen;

public class Operators {
    private static final Map<BinaryOperator, BinaryOpGen> representationMap = new EnumMap<BinaryOperator, BinaryOpGen>(BinaryOperator.class);
    private static final Map<UnaryOperator, UnaryOpGen> unaryMapping = new EnumMap<UnaryOperator, UnaryOpGen>(UnaryOperator.class);

    public static BinaryOpGen generatorFor(BinaryOperator operator) {
        return Operators.provide(representationMap, operator);
    }

    public static UnaryOpGen generatorFor(UnaryOperator operator) {
        return Operators.provide(unaryMapping, operator);
    }

    private static <K, V> V provide(Map<K, V> map, K key) {
        V v = map.get(key);
        if (v == null) {
            throw new UnsupportedOperationException("Cannot find generator for operator: " + key);
        }
        return v;
    }

    static {
        representationMap.put(BinaryOperator.AND, LogicalOpGen.AND);
        representationMap.put(BinaryOperator.OR, LogicalOpGen.OR);
        representationMap.put(BinaryOperator.CONCATENATE, ConcatenateOpGen.INSTANCE);
        representationMap.put(BinaryOperator.ADD, new NumericOpGen("+", BinaryOperator.ADD));
        representationMap.put(BinaryOperator.SUB, new NumericOpGen("-", BinaryOperator.SUB));
        representationMap.put(BinaryOperator.MUL, new NumericOpGen("*", BinaryOperator.MUL));
        representationMap.put(BinaryOperator.I_DIV, new LongOpGen("/", BinaryOperator.I_DIV));
        representationMap.put(BinaryOperator.REM, new LongOpGen("%", BinaryOperator.REM));
        representationMap.put(BinaryOperator.DIV, new NumericOpGen("/", BinaryOperator.DIV));
        representationMap.put(BinaryOperator.EQ, new EquivalenceOpGen(false));
        representationMap.put(BinaryOperator.NEQ, new EquivalenceOpGen(true));
        representationMap.put(BinaryOperator.LT, new ComparisonOpGen(BinaryOperator.LT));
        representationMap.put(BinaryOperator.LEQ, new ComparisonOpGen(BinaryOperator.LEQ));
        representationMap.put(BinaryOperator.GT, new ComparisonOpGen(BinaryOperator.GT));
        representationMap.put(BinaryOperator.GEQ, new ComparisonOpGen(BinaryOperator.GEQ));
        representationMap.put(BinaryOperator.STRICT_EQ, new StrictEqGenOp(false));
        representationMap.put(BinaryOperator.STRICT_NEQ, new StrictEqGenOp(true));
        representationMap.put(BinaryOperator.IN, new InOpGen());
        unaryMapping.put(UnaryOperator.LENGTH, LengthOpGen.INSTANCE);
        unaryMapping.put(UnaryOperator.IS_WHITESPACE, IsWhiteSpaceGen.INSTANCE);
        unaryMapping.put(UnaryOperator.NOT, NotOpGen.INSTANCE);
    }
}

