/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension.use;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.script.Bindings;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.core.ScriptNameAwareReader;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.engine.ResourceResolution;
import org.apache.sling.scripting.sightly.impl.engine.SightlyCompiledScript;
import org.apache.sling.scripting.sightly.impl.engine.SightlyScriptEngine;
import org.apache.sling.scripting.sightly.impl.engine.bundled.BundledUnitManagerImpl;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.impl.utils.ScriptDependencyResolver;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.render.RenderUnit;
import org.apache.sling.scripting.sightly.use.ProviderOutcome;
import org.apache.sling.scripting.sightly.use.UseProvider;
import org.apache.sling.scripting.spi.bundle.BundledRenderUnit;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;

@Component(service={UseProvider.class}, configurationPid={"org.apache.sling.scripting.sightly.impl.engine.extension.use.RenderUnitProvider"}, property={"service.ranking:Integer=100"})
public class RenderUnitProvider
implements UseProvider {
    @Reference
    private BundledUnitManagerImpl bundledUnitManager;
    @Reference
    private ScriptDependencyResolver scriptDependencyResolver;

    public ProviderOutcome provide(String identifier, RenderContext renderContext, Bindings arguments) {
        if (identifier.endsWith(".html")) {
            Bindings globalBindings = renderContext.getBindings();
            SlingScriptHelper sling = BindingsUtils.getHelper(globalBindings);
            SlingJakartaHttpServletRequest request = BindingsUtils.getJakartaRequest(globalBindings);
            Resource renderUnitResource = this.scriptDependencyResolver.resolveScript(renderContext, identifier);
            if (renderUnitResource == null) {
                RenderUnit renderUnit = this.bundledUnitManager.getRenderUnit(globalBindings, identifier);
                if (renderUnit != null) {
                    return ProviderOutcome.success((Object)renderUnit);
                }
                Resource caller = ResourceResolution.getResourceForJakartaRequest(request.getResourceResolver(), request);
                if (caller != null) {
                    String resourceSuperType = caller.getResourceSuperType();
                    StringBuilder errorMessage = new StringBuilder("Cannot find resource ");
                    errorMessage.append(identifier).append(" for base path ").append(caller.getPath());
                    if (StringUtils.isNotEmpty((CharSequence)resourceSuperType)) {
                        errorMessage.append(" with resource super type ").append(resourceSuperType);
                    }
                    errorMessage.append(".");
                    return ProviderOutcome.failure((Throwable)new SightlyException(errorMessage.toString()));
                }
                return ProviderOutcome.failure((Throwable)new SightlyException("Cannot resolve template " + identifier + " for script " + sling.getScript().getScriptResource().getPath()));
            }
            try {
                InputStream inputStream;
                BundledRenderUnit bundledRenderUnit;
                if ("true".equalsIgnoreCase((String)renderUnitResource.getResourceMetadata().get((Object)"sling.servlet.resource")) && (bundledRenderUnit = (BundledRenderUnit)renderUnitResource.adaptTo(BundledRenderUnit.class)) != null && bundledRenderUnit.getUnit() instanceof RenderUnit) {
                    return ProviderOutcome.success((Object)bundledRenderUnit.getUnit());
                }
                SightlyScriptEngine sightlyScriptEngine = (SightlyScriptEngine)((Object)this.bundledUnitManager.getScriptEngineFactory().getScriptEngine());
                String encoding = renderUnitResource.getResourceMetadata().getCharacterEncoding();
                if (StringUtils.isEmpty((CharSequence)encoding)) {
                    encoding = "UTF-8";
                }
                if ((inputStream = (InputStream)renderUnitResource.adaptTo(InputStream.class)) == null) {
                    return ProviderOutcome.failure();
                }
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, encoding);
                ScriptNameAwareReader reader = new ScriptNameAwareReader((Reader)inputStreamReader, renderUnitResource.getPath());
                SightlyCompiledScript compiledScript = (SightlyCompiledScript)sightlyScriptEngine.compile((Reader)reader);
                return ProviderOutcome.success((Object)compiledScript.getRenderUnit());
            }
            catch (Exception e) {
                return ProviderOutcome.failure((Throwable)e);
            }
        }
        return ProviderOutcome.failure();
    }

    static @interface Configuration {
        @AttributeDefinition(name="Service Ranking", description="The Service Ranking value acts as the priority with which this Use Provider is queried to return an Use-object. A higher value represents a higher priority.")
        public int service_ranking() default 100;
    }
}

