/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.owasp.esapi.errors.ConfigurationException;

public class ObjFactory {
    public static <T> T make(String className, String typeName) throws ConfigurationException {
        Object obj = null;
        String errMsg = null;
        try {
            if (null == className || "".equals(className)) {
                throw new IllegalArgumentException("Classname cannot be null or empty.");
            }
            if (null == typeName || "".equals(typeName)) {
                typeName = "[unknown?]";
            }
            Class<?> theClass = Class.forName(className);
            try {
                Method singleton = theClass.getMethod("getInstance", new Class[0]);
                if (!Modifier.isStatic(singleton.getModifiers())) {
                    throw new ConfigurationException("Class [" + className + "] contains a non-static getInstance method.");
                }
                obj = singleton.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                obj = theClass.newInstance();
            }
            catch (SecurityException e) {
                throw new ConfigurationException("The SecurityManager has restricted the object factory from getting a reference to the singleton implementationof the class [" + className + "]", e);
            }
            return (T)obj;
        }
        catch (IllegalArgumentException ex) {
            errMsg = ex.toString() + " " + typeName + " type name cannot be null or empty.";
            throw new ConfigurationException(errMsg, ex);
        }
        catch (ClassNotFoundException ex) {
            errMsg = ex.toString() + " " + typeName + " class (" + className + ") must be in class path.";
            throw new ConfigurationException(errMsg, ex);
        }
        catch (InstantiationException ex) {
            errMsg = ex.toString() + " " + typeName + " class (" + className + ") must be concrete.";
            throw new ConfigurationException(errMsg, ex);
        }
        catch (IllegalAccessException ex) {
            errMsg = ex.toString() + " " + typeName + " class (" + className + ") must have a public, no-arg constructor.";
            throw new ConfigurationException(errMsg, ex);
        }
        catch (ClassCastException ex) {
            errMsg = ex.toString() + " " + typeName + " class (" + className + ") must be a subtype of T in ObjFactory<T>";
            throw new ConfigurationException(errMsg, ex);
        }
        catch (Exception ex) {
            errMsg = ex.toString() + " " + typeName + " class (" + className + ") CTOR threw exception.";
            throw new ConfigurationException(errMsg, ex);
        }
    }

    private ObjFactory() {
    }
}

