/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.mapping;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.resourceresolver.impl.mapping.Interpolator;
import org.apache.sling.resourceresolver.impl.mapping.StringInterpolationProvider;
import org.apache.sling.resourceresolver.impl.mapping.StringInterpolationProviderConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=StringInterpolationProviderConfiguration.class)
@Component
public class StringInterpolationProviderImpl
implements StringInterpolationProvider {
    private static final String TYPE_ENV = "env";
    private static final String TYPE_PROP = "prop";
    private static final String TYPE_CONFIG = "config";
    private static final String DIRECTIVE_DEFAULT = "default";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, String> placeholderEntries = new HashMap<String, String>();
    private BundleContext context;

    @Activate
    protected void activate(BundleContext bundleContext, StringInterpolationProviderConfiguration config) {
        this.context = bundleContext;
        String[] valueMap = config.placeHolderKeyValuePairs();
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (String line : valueMap) {
            if (line == null || line.isEmpty() || line.charAt(0) == '#') continue;
            int index = line.indexOf(61);
            if (index <= 0) {
                this.logger.warn("Placeholder Entry does not contain a key: '{}' -> ignored", (Object)line);
                continue;
            }
            if (index > line.length() - 2) {
                this.logger.warn("Placeholder Entry does not contain a value: '{}' -> ignored", (Object)line);
                continue;
            }
            newMap.put(line.substring(0, index), line.substring(index + 1));
        }
        this.placeholderEntries = newMap;
    }

    @Modified
    protected void modified(BundleContext bundleContext, StringInterpolationProviderConfiguration config) {
        this.activate(bundleContext, config);
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        this.context = null;
        this.placeholderEntries = new HashMap<String, String>();
    }

    @Override
    public String substitute(String text) {
        this.logger.trace("Substitute: '{}'", (Object)text);
        Object result = Interpolator.replace(text, (type, name, dir) -> {
            String v = null;
            if (TYPE_ENV.equals(type)) {
                v = this.getVariableFromEnvironment(name);
            } else if (TYPE_PROP.equals(type)) {
                v = this.getVariableFromProperty(name);
            } else if (TYPE_CONFIG.equals(type)) {
                v = this.getVariableFromBundleConfiguration(name);
            }
            if (v == null) {
                v = (String)dir.get(DIRECTIVE_DEFAULT);
            }
            this.logger.trace("Return substitution value: '{}'", (Object)v);
            return v;
        });
        this.logger.trace("Substitute result: '{}'", result);
        return result == null ? null : result.toString();
    }

    String getVariableFromEnvironment(String name) {
        return System.getenv(name);
    }

    String getVariableFromProperty(String name) {
        return this.context == null ? null : this.context.getProperty(name);
    }

    String getVariableFromBundleConfiguration(String name) {
        return this.placeholderEntries.get(name);
    }
}

