/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.BinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.BooleanPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DecimalPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DoublePropertyState;
import org.apache.jackrabbit.oak.plugins.memory.GenericPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.LongPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiGenericPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiStringPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStateValue;
import org.apache.jackrabbit.oak.plugins.memory.StringPropertyState;

public final class PropertyValues {
    private PropertyValues() {
    }

    @CheckForNull
    public static PropertyValue create(@CheckForNull PropertyState property) {
        if (property == null) {
            return null;
        }
        return PropertyValues.newValue(property);
    }

    @Nonnull
    private static PropertyValue newValue(@Nonnull PropertyState property) {
        return new PropertyStateValue(property);
    }

    @CheckForNull
    public static PropertyState create(@CheckForNull PropertyValue value) {
        if (value == null) {
            return null;
        }
        if (value instanceof PropertyStateValue) {
            return ((PropertyStateValue)value).unwrap();
        }
        return null;
    }

    @Nonnull
    public static PropertyValue newString(@Nonnull String value) {
        return new PropertyStateValue(StringPropertyState.stringProperty("", value));
    }

    @Nonnull
    public static PropertyValue newString(@Nonnull Iterable<String> value) {
        return new PropertyStateValue(MultiStringPropertyState.stringProperty("", value));
    }

    @Nonnull
    public static PropertyValue newLong(@Nonnull Long value) {
        return new PropertyStateValue(LongPropertyState.createLongProperty("", value));
    }

    @Nonnull
    public static PropertyValue newDouble(@Nonnull Double value) {
        return new PropertyStateValue(DoublePropertyState.doubleProperty("", value));
    }

    @Nonnull
    public static PropertyValue newDecimal(@Nonnull BigDecimal value) {
        return new PropertyStateValue(DecimalPropertyState.decimalProperty("", value));
    }

    @Nonnull
    public static PropertyValue newBoolean(boolean value) {
        return new PropertyStateValue(BooleanPropertyState.booleanProperty("", value));
    }

    @Nonnull
    public static PropertyValue newDate(@Nonnull String value) {
        return new PropertyStateValue(GenericPropertyState.dateProperty("", value));
    }

    @Nonnull
    public static PropertyValue newName(@Nonnull String value) {
        return new PropertyStateValue(GenericPropertyState.nameProperty("", value));
    }

    @Nonnull
    public static PropertyValue newName(@Nonnull Iterable<String> value) {
        return new PropertyStateValue(MultiGenericPropertyState.nameProperty("", value));
    }

    @Nonnull
    public static PropertyValue newPath(@Nonnull String value) {
        return new PropertyStateValue(GenericPropertyState.pathProperty("", value));
    }

    @Nonnull
    public static PropertyValue newReference(@Nonnull String value) {
        return new PropertyStateValue(GenericPropertyState.referenceProperty("", value));
    }

    @Nonnull
    public static PropertyValue newWeakReference(@Nonnull String value) {
        return new PropertyStateValue(GenericPropertyState.weakreferenceProperty("", value));
    }

    @Nonnull
    public static PropertyValue newUri(@Nonnull String value) {
        return new PropertyStateValue(GenericPropertyState.uriProperty("", value));
    }

    @Nonnull
    public static PropertyValue newBinary(@Nonnull byte[] value) {
        return new PropertyStateValue(BinaryPropertyState.binaryProperty("", value));
    }

    @Nonnull
    public static PropertyValue newBinary(@Nonnull Blob value) {
        return new PropertyStateValue(BinaryPropertyState.binaryProperty("", value));
    }

    public static boolean match(@Nonnull PropertyValue p1, @Nonnull PropertyState p2) {
        return PropertyValues.match(p1, PropertyValues.newValue(p2));
    }

    public static boolean match(@Nonnull PropertyState p1, @Nonnull PropertyValue p2) {
        return PropertyValues.match(PropertyValues.newValue(p1), p2);
    }

    public static boolean match(@Nonnull PropertyValue p1, @Nonnull PropertyValue p2) {
        if (p1.getType().tag() != p2.getType().tag()) {
            return false;
        }
        switch (p1.getType().tag()) {
            case 2: {
                if (p1.isArray() && !p2.isArray()) {
                    return Iterables.contains((Iterable)((Iterable)p1.getValue(Type.BINARIES)), (Object)p2.getValue(Type.BINARY));
                }
                if (p1.isArray() || !p2.isArray()) break;
                return Iterables.contains((Iterable)((Iterable)p2.getValue(Type.BINARIES)), (Object)p1.getValue(Type.BINARY));
            }
            default: {
                if (p1.isArray() && !p2.isArray()) {
                    return Iterables.contains((Iterable)((Iterable)p1.getValue(Type.STRINGS)), (Object)p2.getValue(Type.STRING));
                }
                if (p1.isArray() || !p2.isArray()) break;
                return Iterables.contains((Iterable)((Iterable)p2.getValue(Type.STRINGS)), (Object)p1.getValue(Type.STRING));
            }
        }
        return p1.compareTo((Object)p2) == 0;
    }

    public static boolean notMatch(@Nonnull PropertyValue p1, @Nonnull PropertyValue p2) {
        if (p1.getType().tag() != p2.getType().tag()) {
            return true;
        }
        switch (p1.getType().tag()) {
            case 2: {
                if (p1.isArray() && !p2.isArray()) {
                    if (p1.count() > 1) {
                        return true;
                    }
                    return !Iterables.contains((Iterable)((Iterable)p1.getValue(Type.BINARIES)), (Object)p2.getValue(Type.BINARY));
                }
                if (p1.isArray() || !p2.isArray()) break;
                if (p2.count() > 1) {
                    return true;
                }
                return !Iterables.contains((Iterable)((Iterable)p2.getValue(Type.BINARIES)), (Object)p1.getValue(Type.BINARY));
            }
            default: {
                if (p1.isArray() && !p2.isArray()) {
                    if (p1.count() > 1) {
                        return true;
                    }
                    return !Iterables.contains((Iterable)((Iterable)p1.getValue(Type.STRINGS)), (Object)p2.getValue(Type.STRING));
                }
                if (p1.isArray() || !p2.isArray()) break;
                if (p2.count() > 1) {
                    return true;
                }
                return !Iterables.contains((Iterable)((Iterable)p2.getValue(Type.STRINGS)), (Object)p1.getValue(Type.STRING));
            }
        }
        return p1.compareTo((Object)p2) != 0;
    }
}

