/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.json;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.json.BlobSerializer;
import org.apache.jackrabbit.oak.json.TypeCodes;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class JsonSerializer {
    public static final String DEFAULT_FILTER_EXPRESSION = "{\"properties\":[\"*\", \"-:childNodeCount\"]}";
    private static final JsonFilter DEFAULT_FILTER = new JsonFilter("{\"properties\":[\"*\", \"-:childNodeCount\"]}");
    private final JsopWriter json;
    private final int depth;
    private final long offset;
    private final int maxChildNodes;
    private final JsonFilter filter;
    private final BlobSerializer blobs;

    private JsonSerializer(JsopWriter json, int depth, long offset, int maxChildNodes, JsonFilter filter, BlobSerializer blobs) {
        this.json = (JsopWriter)Preconditions.checkNotNull((Object)json);
        this.depth = depth;
        this.offset = offset;
        this.maxChildNodes = maxChildNodes;
        this.filter = (JsonFilter)Preconditions.checkNotNull((Object)filter);
        this.blobs = (BlobSerializer)Preconditions.checkNotNull((Object)blobs);
    }

    public JsonSerializer(int depth, long offset, int maxChildNodes, String filter, BlobSerializer blobs) {
        this((JsopWriter)new JsopBuilder(), depth, offset, maxChildNodes, new JsonFilter(filter), blobs);
    }

    public JsonSerializer(JsopWriter json, int depth, long offset, int maxChildNodes, String filter, BlobSerializer blobs) {
        this(json, depth, offset, maxChildNodes, new JsonFilter(filter), blobs);
    }

    public JsonSerializer(JsopWriter json, BlobSerializer blobs) {
        this(json, Integer.MAX_VALUE, 0L, Integer.MAX_VALUE, DEFAULT_FILTER, blobs);
    }

    public JsonSerializer(JsopWriter json, String filter, BlobSerializer blobs) {
        this(json, Integer.MAX_VALUE, 0L, Integer.MAX_VALUE, new JsonFilter(filter), blobs);
    }

    protected JsonSerializer getChildSerializer() {
        return new JsonSerializer(this.json, this.depth - 1, 0L, this.maxChildNodes, this.filter, this.blobs);
    }

    /*
     * WARNING - void declaration
     */
    public void serialize(NodeState node) {
        this.json.object();
        for (PropertyState propertyState : node.getProperties()) {
            String name = propertyState.getName();
            if (!this.filter.includeProperty(name)) continue;
            this.json.key(name);
            this.serialize(propertyState);
        }
        int index = 0;
        boolean bl = false;
        for (ChildNodeEntry childNodeEntry : this.getChildNodeEntries(node)) {
            void var3_6;
            String name = childNodeEntry.getName();
            if (!this.filter.includeNode(name) || (long)index++ < this.offset) continue;
            if (++var3_6 >= this.maxChildNodes) break;
            this.json.key(name);
            if (this.depth > 0) {
                this.getChildSerializer().serialize(childNodeEntry.getNodeState());
                continue;
            }
            this.json.object();
            this.json.endObject();
        }
        this.json.endObject();
    }

    private Iterable<? extends ChildNodeEntry> getChildNodeEntries(NodeState node) {
        PropertyState order = node.getProperty(":childOrder");
        if (order != null) {
            ImmutableList names = ImmutableList.copyOf((Iterable)((Iterable)order.getValue(Type.NAMES)));
            ArrayList entries = Lists.newArrayListWithCapacity((int)names.size());
            for (String name : names) {
                entries.add(new MemoryChildNodeEntry(name, node.getChildNode(name)));
            }
            return entries;
        }
        return node.getChildNodeEntries();
    }

    public void serialize(PropertyState property) {
        Type type = property.getType();
        if (!type.isArray()) {
            this.serialize(property, type, 0);
        } else {
            Type base = type.getBaseType();
            int count = property.count();
            if (base == Type.STRING || count > 0) {
                this.json.array();
                for (int i = 0; i < count; ++i) {
                    this.serialize(property, base, i);
                }
                this.json.endArray();
            } else {
                this.json.value("[0]:" + PropertyType.nameFromValue((int)type.tag()));
            }
        }
    }

    public void serialize(PropertyState property, Type<?> type, int index) {
        if (type == Type.BOOLEAN) {
            this.json.value(((Boolean)property.getValue(Type.BOOLEAN, index)).booleanValue());
        } else if (type == Type.LONG) {
            this.json.value(((Long)property.getValue(Type.LONG, index)).longValue());
        } else if (type == Type.DOUBLE) {
            Double value = (Double)property.getValue(Type.DOUBLE, index);
            if (value.isNaN() || value.isInfinite()) {
                this.json.value(TypeCodes.encode(type.tag(), value.toString()));
            } else {
                this.json.encodedValue(value.toString());
            }
        } else if (type == Type.BINARY) {
            Blob blob = (Blob)property.getValue(Type.BINARY, index);
            this.json.value(TypeCodes.encode(type.tag(), this.blobs.serialize(blob)));
        } else {
            String value = (String)property.getValue(Type.STRING, index);
            if (type != Type.STRING || TypeCodes.split(value) != -1) {
                value = TypeCodes.encode(type.tag(), value);
            }
            this.json.value(value);
        }
    }

    public String toString() {
        return this.json.toString();
    }

    private static class JsonFilter {
        private static final Pattern EVERYTHING = Pattern.compile(".*");
        private final List<Pattern> nodeIncludes = Lists.newArrayList((Object[])new Pattern[]{EVERYTHING});
        private final List<Pattern> nodeExcludes = Lists.newArrayList();
        private final List<Pattern> propertyIncludes = Lists.newArrayList((Object[])new Pattern[]{EVERYTHING});
        private final List<Pattern> propertyExcludes = Lists.newArrayList();

        JsonFilter(String filter) {
            JsopTokenizer tokenizer = new JsopTokenizer(filter);
            tokenizer.read(123);
            boolean first = true;
            while (!tokenizer.matches(125)) {
                if (!first) {
                    tokenizer.read(44);
                }
                String key = tokenizer.readString();
                tokenizer.read(58);
                ArrayList includes = Lists.newArrayList();
                ArrayList excludes = Lists.newArrayList();
                JsonFilter.readPatterns(tokenizer, includes, excludes);
                if (key.equals("nodes")) {
                    this.nodeIncludes.clear();
                    this.nodeIncludes.addAll(includes);
                    this.nodeExcludes.clear();
                    this.nodeExcludes.addAll(excludes);
                } else if (key.equals("properties")) {
                    this.propertyIncludes.clear();
                    this.propertyIncludes.addAll(includes);
                    this.propertyExcludes.clear();
                    this.propertyExcludes.addAll(excludes);
                } else {
                    throw new IllegalStateException(key);
                }
                first = false;
            }
        }

        private static void readPatterns(JsopTokenizer tokenizer, List<Pattern> includes, List<Pattern> excludes) {
            tokenizer.read(91);
            boolean first = true;
            while (!tokenizer.matches(93)) {
                String pattern;
                if (!first) {
                    tokenizer.read(44);
                }
                if ((pattern = tokenizer.readString()).startsWith("-")) {
                    excludes.add(JsonFilter.glob(pattern.substring(1)));
                } else if (pattern.startsWith("\\-")) {
                    includes.add(JsonFilter.glob(pattern.substring(1)));
                } else {
                    includes.add(JsonFilter.glob(pattern));
                }
                first = false;
            }
        }

        private static Pattern glob(String pattern) {
            StringBuilder builder = new StringBuilder();
            int star = pattern.indexOf(42);
            while (star != -1) {
                if (star > 0 && pattern.charAt(star - 1) == '\\') {
                    builder.append(Pattern.quote(pattern.substring(0, star - 1)));
                    builder.append(Pattern.quote("*"));
                } else {
                    builder.append(Pattern.quote(pattern.substring(0, star)));
                    builder.append(".*");
                }
                pattern = pattern.substring(star + 1);
                star = pattern.indexOf(42);
            }
            builder.append(Pattern.quote(pattern));
            return Pattern.compile(builder.toString());
        }

        boolean includeNode(String name) {
            return JsonFilter.include(name, this.nodeIncludes, this.nodeExcludes);
        }

        boolean includeProperty(String name) {
            return JsonFilter.include(name, this.propertyIncludes, this.propertyExcludes);
        }

        private static boolean include(String name, List<Pattern> includes, List<Pattern> excludes) {
            for (Pattern include : includes) {
                if (!include.matcher(name).matches()) continue;
                for (Pattern exclude : excludes) {
                    if (!exclude.matcher(name).matches()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

