/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.auth.Authenticator;
import org.apache.sling.api.auth.NoAuthenticationHandlerException;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.auth.core.AuthUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={Servlet.class})
@Properties(value={@Property(name="service.description", value={"Authenticator Login Servlet"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="sling.servlet.methods", value={"GET", "POST"})})
public class LoginServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -8797082194403667968L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private volatile Authenticator authenticator;
    @Property(name="sling.servlet.paths")
    public static final String SERVLET_PATH = "/system/sling/login";

    protected void service(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String resourcePath;
        if (request.getAuthType() != null && this.isSelf(resourcePath = AuthUtil.getLoginResource((HttpServletRequest)request, null))) {
            String redirectTarget = request.getContextPath() + "/";
            this.log.warn("doGet: Redirecting to {} to prevent login loop for resource {}", (Object)redirectTarget, (Object)resourcePath);
            response.sendRedirect(redirectTarget);
            return;
        }
        Authenticator authenticator = this.authenticator;
        if (authenticator != null) {
            try {
                AuthUtil.setLoginResourceAttribute((HttpServletRequest)request, null);
                authenticator.login((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            catch (IllegalStateException ise) {
                this.log.error("doGet: Response already committed, cannot login");
                return;
            }
            catch (NoAuthenticationHandlerException nahe) {
                this.log.error("doGet: No AuthenticationHandler to login registered");
            }
        } else {
            this.log.error("doGet: Authenticator service missing, cannot login");
        }
        response.sendError(403, "Cannot login");
    }

    private boolean isSelf(String resourcePath) {
        if (resourcePath == null) {
            return true;
        }
        return resourcePath.startsWith(SERVLET_PATH);
    }

    protected void bindAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    protected void unbindAuthenticator(Authenticator authenticator) {
        if (this.authenticator == authenticator) {
            this.authenticator = null;
        }
    }
}

