/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.resource.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationResourceResolvingStrategyMultiplexer;
import org.apache.sling.caconfig.management.multiplexer.ContextPathStrategyMultiplexer;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.caconfig.resource.impl.util.ConfigNameUtil;
import org.apache.sling.caconfig.resource.spi.ContextResource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConfigurationResourceResolver.class}, immediate=true)
public class ConfigurationResourceResolverImpl
implements ConfigurationResourceResolver {
    @Reference
    private ContextPathStrategyMultiplexer contextPathStrategy;
    @Reference
    private ConfigurationResourceResolvingStrategyMultiplexer configurationResourceResolvingStrategy;

    public Resource getResource(Resource resource, String bucketName, String configName) {
        ConfigNameUtil.ensureValidConfigName(configName);
        return this.configurationResourceResolvingStrategy.getResource(resource, Collections.singleton(bucketName), configName);
    }

    public Collection<Resource> getResourceCollection(Resource resource, String bucketName, String configName) {
        ConfigNameUtil.ensureValidConfigName(configName);
        return this.configurationResourceResolvingStrategy.getResourceCollection(resource, Collections.singleton(bucketName), configName);
    }

    public String getContextPath(Resource resource) {
        Iterator it = this.contextPathStrategy.findContextResources(resource);
        if (it.hasNext()) {
            return ((ContextResource)it.next()).getResource().getPath();
        }
        return null;
    }

    public Collection<String> getAllContextPaths(Resource resource) {
        ArrayList<String> contextPaths = new ArrayList<String>();
        Iterator contextResources = this.contextPathStrategy.findContextResources(resource);
        while (contextResources.hasNext()) {
            contextPaths.add(((ContextResource)contextResources.next()).getResource().getPath());
        }
        return contextPaths;
    }
}

