/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.impl.override;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.caconfig.spi.ConfigurationOverrideProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ConfigurationOverrideProvider.class}, immediate=true)
@Designate(ocd=Config.class)
public final class SystemPropertyConfigurationOverrideProvider
implements ConfigurationOverrideProvider {
    public static final String SYSTEM_PROPERTY_PREFIX = "sling.caconfig.override.";
    private Collection<String> overrideStrings;

    @Activate
    void activate(Config config) {
        ArrayList<String> overrides = new ArrayList<String>();
        if (config.enabled()) {
            Properties properties = System.getProperties();
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key;
                Object keyObject = keys.nextElement();
                if (!(keyObject instanceof String) || !StringUtils.startsWith((CharSequence)(key = (String)keyObject), (CharSequence)SYSTEM_PROPERTY_PREFIX)) continue;
                overrides.add(StringUtils.substringAfter((String)key, (String)SYSTEM_PROPERTY_PREFIX) + "=" + System.getProperty(key));
            }
        }
        this.overrideStrings = overrides;
    }

    public Collection<String> getOverrideStrings() {
        return this.overrideStrings;
    }

    @ObjectClassDefinition(name="Apache Sling Context-Aware Configuration Override Provider: System Properties", description="Allows to override configuration property values from system environment properties.")
    public static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enable this override provider.")
        public boolean enabled() default false;

        @AttributeDefinition(name="Service Ranking", description="Priority of configuration override providers (higher = higher priority).")
        public int service_ranking() default 200;
    }
}

