/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.impl.override;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.caconfig.impl.override.OverrideItem;
import org.apache.sling.caconfig.spi.metadata.PropertyMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OverrideStringParser {
    private static final Logger log = LoggerFactory.getLogger(OverrideStringParser.class);
    private static final Pattern OVERRIDE_PATTERN = Pattern.compile("^(\\[([^\\[\\]=]+)\\])?([^\\[\\]=]+)=(.*)$");
    private static final JsonReaderFactory JSON_READER_FACTORY = Json.createReaderFactory(Collections.emptyMap());

    private OverrideStringParser() {
    }

    public static Collection<OverrideItem> parse(Collection<String> overrideStrings) {
        ArrayList<OverrideItem> result = new ArrayList<OverrideItem>();
        for (String overrideString : overrideStrings) {
            OverrideItem item;
            Matcher matcher = OVERRIDE_PATTERN.matcher(StringUtils.defaultString((String)overrideString));
            if (!matcher.matches()) {
                log.warn("Ignore config override string - invalid syntax: {}", (Object)overrideString);
                continue;
            }
            String path = StringUtils.trim((String)matcher.group(2));
            String configName = StringUtils.trim((String)matcher.group(3));
            String value = StringUtils.trim((String)StringUtils.defaultString((String)matcher.group(4)));
            try {
                JsonObject json = OverrideStringParser.toJson(value);
                if (json != null) {
                    item = new OverrideItem(path, configName, OverrideStringParser.toMap(json), true);
                } else {
                    String propertyName = StringUtils.substringAfterLast((String)configName, (String)"/");
                    if (StringUtils.isEmpty((CharSequence)propertyName)) {
                        log.warn("Ignore config override string - missing property name: {}", (Object)overrideString);
                        continue;
                    }
                    configName = StringUtils.substringBeforeLast((String)configName, (String)"/");
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put(propertyName, OverrideStringParser.convertJsonValue(value));
                    item = new OverrideItem(path, configName, props, false);
                }
            }
            catch (JsonException ex) {
                log.warn("Ignore config override string - invalid JSON syntax ({}): {}", (Object)ex.getMessage(), (Object)overrideString);
                continue;
            }
            if (!OverrideStringParser.isValid(item, overrideString)) continue;
            if (!item.isAllProperties()) {
                boolean foundMatchingItem = false;
                for (OverrideItem existingItem : result) {
                    if (existingItem.isAllProperties() || !StringUtils.equals((CharSequence)item.getPath(), (CharSequence)existingItem.getPath()) || !StringUtils.equals((CharSequence)item.getConfigName(), (CharSequence)existingItem.getConfigName())) continue;
                    existingItem.getProperties().putAll(item.getProperties());
                    foundMatchingItem = true;
                    break;
                }
                if (foundMatchingItem) continue;
            }
            result.add(item);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private static JsonObject toJson(String value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Map<String, Object> toMap(JsonObject json) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String key : json.keySet()) {
            props.put(key, OverrideStringParser.convertJsonValue((JsonValue)json.get((Object)key)));
        }
        return props;
    }

    private static Object convertJsonValue(String jsonValue) {
        String jsonString = "{\"value\":" + jsonValue + "}";
        JsonObject json = OverrideStringParser.toJson(jsonString);
        return OverrideStringParser.convertJsonValue((JsonValue)json.get((Object)"value"));
    }

    private static Object convertJsonValue(JsonValue jsonValue) {
        switch (jsonValue.getValueType()) {
            case STRING: {
                return ((JsonString)jsonValue).getString();
            }
            case NUMBER: {
                JsonNumber number = (JsonNumber)jsonValue;
                if (number.isIntegral()) {
                    return number.longValue();
                }
                return number.doubleValue();
            }
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case NULL: {
                return null;
            }
            case ARRAY: {
                return OverrideStringParser.convertJsonArray((JsonArray)jsonValue);
            }
        }
        throw new RuntimeException("Unexpected JSON value type: " + jsonValue.getValueType() + ": " + jsonValue);
    }

    private static Object convertJsonArray(JsonArray jsonArray) {
        Object firstValue;
        if (jsonArray.size() > 0 && (firstValue = OverrideStringParser.convertJsonValue((JsonValue)jsonArray.get(0))) != null) {
            Class<?> firstType = firstValue.getClass();
            Object convertedArray = Array.newInstance(firstType, jsonArray.size());
            for (int i = 0; i < jsonArray.size(); ++i) {
                Array.set(convertedArray, i, OverrideStringParser.convertJsonValue((JsonValue)jsonArray.get(i)));
            }
            return convertedArray;
        }
        return new String[0];
    }

    private static boolean isValid(OverrideItem item, String overrideString) {
        if (item.getPath() != null && (!StringUtils.startsWith((CharSequence)item.getPath(), (CharSequence)"/") || StringUtils.contains((CharSequence)item.getPath(), (CharSequence)".."))) {
            log.warn("Ignore config override string - invalid path: {}", (Object)overrideString);
            return false;
        }
        if (StringUtils.startsWith((CharSequence)item.getConfigName(), (CharSequence)"/") || StringUtils.contains((CharSequence)item.getConfigName(), (CharSequence)"..")) {
            log.warn("Ignore config override string - invalid configName: {}", (Object)overrideString);
            return false;
        }
        for (Map.Entry<String, Object> entry : item.getProperties().entrySet()) {
            String propertyName = entry.getKey();
            if (StringUtils.isEmpty((CharSequence)propertyName) || StringUtils.contains((CharSequence)propertyName, (CharSequence)"/")) {
                log.warn("Ignore config override string - invalid property name ({}): {}", (Object)propertyName, (Object)overrideString);
                return false;
            }
            Object value = entry.getValue();
            if (value != null && OverrideStringParser.isSupportedType(value)) continue;
            log.warn("Ignore config override string - invalid property value ({} - {}): {}", new Object[]{value, value != null ? value.getClass().getName() : "", overrideString});
            return false;
        }
        return true;
    }

    private static boolean isSupportedType(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        for (Class type : PropertyMetadata.SUPPORTED_TYPES) {
            if (type.equals(clazz)) {
                return true;
            }
            if (!type.isPrimitive() || !ClassUtils.primitiveToWrapper((Class)type).equals(clazz)) continue;
            return true;
        }
        return false;
    }
}

