/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.ListIteratorWrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.caconfig.ConfigurationBuilder;
import org.apache.sling.caconfig.ConfigurationResolveException;
import org.apache.sling.caconfig.ConfigurationResolver;
import org.apache.sling.caconfig.impl.ConfigurationProxy;
import org.apache.sling.caconfig.impl.ConfigurationResourceWrapper;
import org.apache.sling.caconfig.impl.metadata.AnnotationClassParser;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationOverrideMultiplexer;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationPersistenceStrategyMultiplexer;
import org.apache.sling.caconfig.resource.impl.util.ConfigNameUtil;
import org.apache.sling.caconfig.resource.impl.util.MapUtil;
import org.apache.sling.caconfig.resource.spi.ConfigurationResourceResolvingStrategy;
import org.apache.sling.caconfig.spi.ConfigurationInheritanceStrategy;
import org.apache.sling.caconfig.spi.ConfigurationMetadataProvider;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;
import org.apache.sling.caconfig.spi.metadata.PropertyMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigurationBuilderImpl
implements ConfigurationBuilder {
    private final Resource contentResource;
    private final ConfigurationResolver configurationResolver;
    private final ConfigurationResourceResolvingStrategy configurationResourceResolvingStrategy;
    private final ConfigurationPersistenceStrategyMultiplexer configurationPersistenceStrategy;
    private final ConfigurationInheritanceStrategy configurationInheritanceStrategy;
    private final ConfigurationOverrideMultiplexer configurationOverrideMultiplexer;
    private final ConfigurationMetadataProvider configurationMetadataProvider;
    private final Collection<String> configBucketNames;
    private final String configName;
    private static final Logger log = LoggerFactory.getLogger(ConfigurationBuilderImpl.class);

    public ConfigurationBuilderImpl(Resource resource, ConfigurationResolver configurationResolver, ConfigurationResourceResolvingStrategy configurationResourceResolvingStrategy, ConfigurationPersistenceStrategyMultiplexer configurationPersistenceStrategy, ConfigurationInheritanceStrategy configurationInheritanceStrategy, ConfigurationOverrideMultiplexer configurationOverrideMultiplexer, ConfigurationMetadataProvider configurationMetadataProvider, Collection<String> configBucketNames) {
        this(resource, configurationResolver, configurationResourceResolvingStrategy, configurationPersistenceStrategy, configurationInheritanceStrategy, configurationOverrideMultiplexer, configurationMetadataProvider, configBucketNames, null);
    }

    private ConfigurationBuilderImpl(Resource resource, ConfigurationResolver configurationResolver, ConfigurationResourceResolvingStrategy configurationResourceResolvingStrategy, ConfigurationPersistenceStrategyMultiplexer configurationPersistenceStrategy, ConfigurationInheritanceStrategy configurationInheritanceStrategy, ConfigurationOverrideMultiplexer configurationOverrideMultiplexer, ConfigurationMetadataProvider configurationMetadataProvider, Collection<String> configBucketNames, String configName) {
        this.contentResource = resource;
        this.configurationResolver = configurationResolver;
        this.configurationResourceResolvingStrategy = configurationResourceResolvingStrategy;
        this.configurationPersistenceStrategy = configurationPersistenceStrategy;
        this.configurationInheritanceStrategy = configurationInheritanceStrategy;
        this.configurationOverrideMultiplexer = configurationOverrideMultiplexer;
        this.configurationMetadataProvider = configurationMetadataProvider;
        this.configBucketNames = configBucketNames;
        this.configName = configName;
    }

    public ConfigurationBuilder name(String configName) {
        ConfigNameUtil.ensureValidConfigName(configName);
        return new ConfigurationBuilderImpl(this.contentResource, this.configurationResolver, this.configurationResourceResolvingStrategy, this.configurationPersistenceStrategy, this.configurationInheritanceStrategy, this.configurationOverrideMultiplexer, this.configurationMetadataProvider, this.configBucketNames, configName);
    }

    private void validateConfigurationName(String name) {
        if (name == null) {
            throw new ConfigurationResolveException("Configuration name is required.");
        }
    }

    private <T> T getConfigResource(String configName, Class<T> clazz, Converter<T> converter) {
        Iterator resourceInheritanceChain = null;
        if (this.contentResource != null) {
            this.validateConfigurationName(configName);
            resourceInheritanceChain = this.configurationResourceResolvingStrategy.getResourceInheritanceChain(this.contentResource, this.configBucketNames, configName);
        }
        return this.convert(resourceInheritanceChain, clazz, converter, configName, false);
    }

    private <T> Collection<T> getConfigResourceCollection(String configName, Class<T> clazz, Converter<T> converter) {
        if (this.contentResource != null) {
            this.validateConfigurationName(configName);
            Collection<String> collectionParentConfigNames = this.configurationPersistenceStrategy.getAllCollectionParentConfigNames(configName);
            ArrayList resourceInheritanceChains = new ArrayList();
            for (String collectionParentConfigName : collectionParentConfigNames) {
                Collection result = this.configurationResourceResolvingStrategy.getResourceCollectionInheritanceChain(this.contentResource, this.configBucketNames, collectionParentConfigName);
                if (result == null) continue;
                resourceInheritanceChains.addAll(result);
            }
            ArrayList<T> result = new ArrayList<T>();
            if (resourceInheritanceChains != null) {
                for (Iterator resourceInheritanceChain : resourceInheritanceChains) {
                    T obj = this.convert(resourceInheritanceChain, clazz, converter, configName, true);
                    if (obj == null) continue;
                    result.add(obj);
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    private <T> T convert(Iterator<Resource> resourceInhertianceChain, Class<T> clazz, Converter<T> converter, String name, final boolean isCollection) {
        Resource configResource = null;
        String conversionName = name;
        if (resourceInhertianceChain != null) {
            ListIteratorWrapper resettableResourceInhertianceChain = new ListIteratorWrapper(resourceInhertianceChain);
            Iterator transformedResources = IteratorUtils.transformedIterator((Iterator)resettableResourceInhertianceChain, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    if (isCollection) {
                        return ConfigurationBuilderImpl.this.configurationPersistenceStrategy.getCollectionItemResource((Resource)input);
                    }
                    return ConfigurationBuilderImpl.this.configurationPersistenceStrategy.getResource((Resource)input);
                }
            });
            configResource = this.configurationInheritanceStrategy.getResource(transformedResources);
            configResource = this.configurationOverrideMultiplexer.overrideProperties(this.contentResource.getPath(), name, configResource, this.contentResource.getResourceResolver());
            if (isCollection) {
                resettableResourceInhertianceChain.reset();
                Resource untransformedConfigResource = this.configurationInheritanceStrategy.getResource((Iterator)resettableResourceInhertianceChain);
                if (untransformedConfigResource != null && configResource != null) {
                    conversionName = this.configurationPersistenceStrategy.getCollectionParentConfigName(conversionName, configResource.getPath()) + "/" + untransformedConfigResource.getName();
                }
            }
        }
        if (log.isTraceEnabled() && configResource != null) {
            log.trace("+ Found config resource for context path " + this.contentResource.getPath() + ": " + configResource.getPath() + " " + MapUtil.traceOutput((Map<String, Object>)configResource.getValueMap()));
        }
        if (configResource == null && this.contentResource != null) {
            configResource = this.configurationOverrideMultiplexer.overrideProperties(this.contentResource.getPath(), name, null, this.contentResource.getResourceResolver());
        }
        return converter.convert(configResource, clazz, conversionName, isCollection);
    }

    private Resource applyDefaultValues(Resource resource, String configName) {
        if (resource == null) {
            return null;
        }
        Map<String, Object> updatedMap = this.applyDefaultValues((Map<String, Object>)resource.getValueMap(), configName);
        if (updatedMap == null) {
            return resource;
        }
        return new ConfigurationResourceWrapper(resource, (ValueMap)new ValueMapDecorator(updatedMap));
    }

    private Map<String, Object> applyDefaultValues(Map<String, Object> props, String configName) {
        ConfigurationMetadata metadata = this.configurationMetadataProvider.getConfigurationMetadata(configName);
        if (metadata == null) {
            if (StringUtils.contains((CharSequence)configName, (CharSequence)"/")) {
                String partialConfigName = StringUtils.substringBeforeLast((String)configName, (String)"/");
                metadata = this.configurationMetadataProvider.getConfigurationMetadata(partialConfigName);
            }
            if (metadata == null) {
                return null;
            }
        }
        HashMap<String, Object> updatedMap = new HashMap<String, Object>();
        for (PropertyMetadata propertyMetadata : metadata.getPropertyMetadata().values()) {
            if (propertyMetadata.getDefaultValue() == null) continue;
            updatedMap.put(propertyMetadata.getName(), propertyMetadata.getDefaultValue());
        }
        if (updatedMap.isEmpty()) {
            return null;
        }
        updatedMap.putAll(props);
        return updatedMap;
    }

    public <T> T as(Class<T> clazz) {
        String name = this.getConfigurationNameForAnnotationClass(clazz);
        if (log.isDebugEnabled()) {
            log.debug("Get configuration for context path {}, name '{}', class {}", new Object[]{this.contentResource.getPath(), name, clazz.getName()});
        }
        return this.getConfigResource(name, clazz, new AnnotationConverter());
    }

    public <T> Collection<T> asCollection(Class<T> clazz) {
        String name = this.getConfigurationNameForAnnotationClass(clazz);
        if (log.isDebugEnabled()) {
            log.debug("Get configuration collection for context path {}, name '{}', class {}", new Object[]{this.contentResource.getPath(), name, clazz.getName()});
        }
        return this.getConfigResourceCollection(name, clazz, new AnnotationConverter());
    }

    private String getConfigurationNameForAnnotationClass(Class<?> clazz) {
        if (this.configName != null) {
            return this.configName;
        }
        return AnnotationClassParser.getConfigurationName(clazz);
    }

    public ValueMap asValueMap() {
        if (log.isDebugEnabled()) {
            log.debug("Get ValueMap for context path {}, name '{}'", (Object)this.contentResource.getPath(), (Object)this.configName);
        }
        return this.getConfigResource(this.configName, ValueMap.class, new ValueMapConverter());
    }

    public Collection<ValueMap> asValueMapCollection() {
        if (log.isDebugEnabled()) {
            log.debug("Get ValueMap collection for context path {}, name '{}'", (Object)this.contentResource.getPath(), (Object)this.configName);
        }
        return this.getConfigResourceCollection(this.configName, ValueMap.class, new ValueMapConverter());
    }

    public <T> T asAdaptable(Class<T> clazz) {
        if (log.isDebugEnabled()) {
            log.debug("Get adaptable for context path {}, name '{}', class {}", new Object[]{this.contentResource.getPath(), this.configName, clazz});
        }
        return this.getConfigResource(this.configName, clazz, new AdaptableConverter());
    }

    public <T> Collection<T> asAdaptableCollection(Class<T> clazz) {
        if (log.isDebugEnabled()) {
            log.debug("Get adaptable collection for context path {}, name '{}', class {}", new Object[]{this.contentResource.getPath(), this.configName, clazz});
        }
        return this.getConfigResourceCollection(this.configName, clazz, new AdaptableConverter());
    }

    private class AdaptableConverter<T>
    implements Converter<T> {
        private AdaptableConverter() {
        }

        @Override
        public T convert(Resource resource, Class<T> clazz, String configName, boolean isCollection) {
            if (resource == null || clazz == ConfigurationBuilder.class) {
                return null;
            }
            return (T)ConfigurationBuilderImpl.this.applyDefaultValues(resource, configName).adaptTo(clazz);
        }
    }

    private class ValueMapConverter
    implements Converter<ValueMap> {
        private ValueMapConverter() {
        }

        @Override
        public ValueMap convert(Resource resource, Class<ValueMap> clazz, String configName, boolean isCollection) {
            ValueMap props = ResourceUtil.getValueMap((Resource)resource);
            Map updatedMap = ConfigurationBuilderImpl.this.applyDefaultValues((Map)props, configName);
            if (updatedMap != null) {
                return new ValueMapDecorator(updatedMap);
            }
            return props;
        }
    }

    private class AnnotationConverter<T>
    implements Converter<T> {
        private AnnotationConverter() {
        }

        @Override
        public T convert(final Resource resource, Class<T> clazz, final String configName, final boolean isCollection) {
            return ConfigurationProxy.get(resource, clazz, new ConfigurationProxy.ChildResolver(){

                private ConfigurationBuilder getConfiguration(String nestedConfigName) {
                    String relatedConfigPath = resource != null ? resource.getPath() : null;
                    String childName = isCollection ? ConfigurationBuilderImpl.this.configurationPersistenceStrategy.getCollectionItemConfigName(configName, relatedConfigPath) + "/" + nestedConfigName : ConfigurationBuilderImpl.this.configurationPersistenceStrategy.getConfigName(configName, relatedConfigPath) + "/" + nestedConfigName;
                    return ConfigurationBuilderImpl.this.configurationResolver.get(ConfigurationBuilderImpl.this.contentResource).name(childName);
                }

                public <C> C getChild(String configName2, Class<C> clazz) {
                    return (C)this.getConfiguration(configName2).as(clazz);
                }

                public <C> Collection<C> getChildren(String configName2, Class<C> clazz) {
                    return this.getConfiguration(configName2).asCollection(clazz);
                }
            });
        }
    }

    private static interface Converter<T> {
        public T convert(Resource var1, Class<T> var2, String var3, boolean var4);
    }
}

