/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.ConfigurationBuilder;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationMetadataProviderMultiplexer;
import org.apache.sling.caconfig.spi.ConfigurationMetadataProvider;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(immediate=true, service={BindingsValuesProvider.class}, property={"javax.script.name=sightly", "service.ranking=100"})
@Designate(ocd=Config.class)
public class ConfigurationBindingsValueProvider
implements BindingsValuesProvider {
    public static final String BINDING_VARIABLE = "caconfig";
    @Reference
    private ConfigurationMetadataProviderMultiplexer configMetadataProvider;
    private boolean enabled;

    public void addBindings(Bindings bindings) {
        if (!this.enabled || !bindings.containsKey("request")) {
            return;
        }
        SlingHttpServletRequest request = (SlingHttpServletRequest)bindings.get("request");
        Resource resource = request.getResource();
        if (resource == null) {
            return;
        }
        ConfigMap configMap = new ConfigMap(resource, this.configMetadataProvider);
        bindings.put(BINDING_VARIABLE, (Object)configMap);
    }

    @Activate
    void activate(Config config) {
        this.enabled = config.enabled();
    }

    private static class ConfigMap
    implements Map<String, Object> {
        private final Resource resource;
        private final ConfigurationMetadataProvider configMetadataProvider;
        private Set<String> configNamesCache;
        private Map<String, Object> valuesCache = new HashMap<String, Object>();

        ConfigMap(Resource resource, ConfigurationMetadataProvider configMetadataProvider) {
            this.resource = resource;
            this.configMetadataProvider = configMetadataProvider;
        }

        private Set<String> getConfigNames() {
            if (this.configNamesCache == null) {
                this.configNamesCache = this.configMetadataProvider.getConfigurationNames();
            }
            return this.configNamesCache;
        }

        @Override
        public int size() {
            return this.getConfigNames().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getConfigNames().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.getConfigNames().contains(key);
        }

        @Override
        public Object get(Object key) {
            Object value = this.valuesCache.get(key);
            if (value == null && (value = this.getConfigValue((String)key)) != null) {
                this.valuesCache.put((String)key, value);
            }
            return value;
        }

        private Object getConfigValue(String configName) {
            ConfigurationBuilder configBuilder = ((ConfigurationBuilder)this.resource.adaptTo(ConfigurationBuilder.class)).name(configName);
            if (this.isCollection(configName)) {
                return configBuilder.asValueMapCollection();
            }
            return configBuilder.asValueMap();
        }

        private boolean isCollection(String configName) {
            ConfigurationMetadata configMetadata = this.configMetadataProvider.getConfigurationMetadata(configName);
            if (configMetadata != null) {
                return configMetadata.isCollection();
            }
            return false;
        }

        @Override
        public Set<String> keySet() {
            return this.getConfigNames();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Object> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }

    @ObjectClassDefinition(name="Apache Sling Context-Aware Configuration HTL Binding Values Provider", description="Binds a script variable 'caconfig' to the HTL/Sightly scripting context.")
    static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enable provider.")
        public boolean enabled() default true;
    }
}

