/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.query;

import javax.annotation.Nonnull;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.oak.commons.QueryUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.user.query.RelationOp;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;

public final class QueryUtil {
    private QueryUtil() {
    }

    @Nonnull
    public static String getSearchRoot(AuthorizableType type, ConfigurationParameters config) {
        String path = UserUtil.getAuthorizableRootPath((ConfigurationParameters)config, (AuthorizableType)type);
        return "/jcr:root" + path;
    }

    @Nonnull
    public static String getNodeTypeName(@Nonnull AuthorizableType type) {
        if (type == AuthorizableType.USER) {
            return "rep:User";
        }
        if (type == AuthorizableType.GROUP) {
            return "rep:Group";
        }
        return "rep:Authorizable";
    }

    @Nonnull
    public static String escapeNodeName(@Nonnull String string) {
        return QueryUtils.escapeNodeName((String)string);
    }

    @Nonnull
    public static String format(@Nonnull Value value) throws RepositoryException {
        switch (value.getType()) {
            case 1: 
            case 6: {
                return '\'' + QueryUtil.escapeForQuery(value.getString()) + '\'';
            }
            case 3: 
            case 4: {
                return value.getString();
            }
            case 5: {
                return "xs:dateTime('" + value.getString() + "')";
            }
        }
        throw new RepositoryException("Property of type " + PropertyType.nameFromValue((int)value.getType()) + " not supported");
    }

    @Nonnull
    public static String escapeForQuery(@Nonnull String oakName, @Nonnull NamePathMapper namePathMapper) {
        return QueryUtil.escapeForQuery(namePathMapper.getJcrName(oakName));
    }

    @Nonnull
    public static String escapeForQuery(@Nonnull String value) {
        return QueryUtils.escapeForQuery((String)value);
    }

    @Nonnull
    public static RelationOp getCollation(@Nonnull QueryBuilder.Direction direction) throws RepositoryException {
        switch (direction) {
            case ASCENDING: {
                return RelationOp.GT;
            }
            case DESCENDING: {
                return RelationOp.LT;
            }
        }
        throw new RepositoryException("Unknown sort order " + direction);
    }
}

