/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import javax.annotation.Nonnull;
import javax.jcr.AccessDeniedException;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.util.Text;

class Utils {
    private Utils() {
    }

    @Nonnull
    static Tree getOrAddTree(@Nonnull Tree tree, @Nonnull String relativePath, @Nonnull String primaryTypeName) throws AccessDeniedException {
        if (PathUtils.denotesCurrent((String)relativePath)) {
            return tree;
        }
        if (PathUtils.denotesParent((String)relativePath)) {
            return tree.getParent();
        }
        if (relativePath.indexOf(47) == -1) {
            return TreeUtil.getOrAddChild((Tree)tree, (String)relativePath, (String)primaryTypeName);
        }
        Tree t = TreeUtil.getTree((Tree)tree, (String)relativePath);
        if (t == null || !t.exists()) {
            Tree target = tree;
            for (String segment : Text.explode((String)relativePath, (int)47)) {
                if (PathUtils.denotesParent((String)segment)) {
                    target = target.getParent();
                    continue;
                }
                if (target.hasChild(segment)) {
                    target = target.getChild(segment);
                    continue;
                }
                if (PathUtils.denotesCurrent((String)segment)) continue;
                target = TreeUtil.addChild((Tree)target, (String)segment, (String)primaryTypeName);
            }
            if (!target.exists()) {
                throw new AccessDeniedException();
            }
            return target;
        }
        return t;
    }
}

