/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.security.user.MembershipProvider;
import org.apache.jackrabbit.oak.security.user.UserValidator;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class UserValidatorProvider
extends ValidatorProvider {
    private final ConfigurationParameters config;
    private final RootProvider rootProvider;
    private final TreeProvider treeProvider;
    private MembershipProvider membershipProvider;

    UserValidatorProvider(@Nonnull ConfigurationParameters config, @Nonnull RootProvider rootProvider, @Nonnull TreeProvider treeProvider) {
        this.config = config;
        this.rootProvider = rootProvider;
        this.treeProvider = treeProvider;
    }

    @Nonnull
    public Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        this.membershipProvider = new MembershipProvider(this.rootProvider.createReadOnlyRoot(after), this.config);
        return new UserValidator(this.treeProvider.createReadOnlyTree(before), this.treeProvider.createReadOnlyTree(after), this);
    }

    @Nonnull
    ConfigurationParameters getConfig() {
        return this.config;
    }

    @Nonnull
    MembershipProvider getMembershipProvider() {
        return this.membershipProvider;
    }
}

