/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class RepMembersConflictHandler
implements ThreeWayConflictHandler {
    @Nonnull
    public ThreeWayConflictHandler.Resolution addExistingProperty(@Nonnull NodeBuilder parent, @Nonnull PropertyState ours, @Nonnull PropertyState theirs) {
        if (RepMembersConflictHandler.isRepMembersProperty(theirs)) {
            RepMembersConflictHandler.mergeChange(parent, ours, theirs, Sets.newHashSet());
            return ThreeWayConflictHandler.Resolution.MERGED;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Nonnull
    public ThreeWayConflictHandler.Resolution changeDeletedProperty(@Nonnull NodeBuilder parent, @Nonnull PropertyState ours, @Nonnull PropertyState base) {
        if (RepMembersConflictHandler.isRepMembersProperty(ours)) {
            return ThreeWayConflictHandler.Resolution.THEIRS;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Nonnull
    public ThreeWayConflictHandler.Resolution changeChangedProperty(@Nonnull NodeBuilder parent, @Nonnull PropertyState ours, @Nonnull PropertyState theirs, @Nonnull PropertyState base) {
        if (RepMembersConflictHandler.isRepMembersProperty(theirs)) {
            HashSet baseMembers = Sets.newHashSet((Iterable)((Iterable)base.getValue(Type.STRINGS)));
            RepMembersConflictHandler.mergeChange(parent, ours, theirs, baseMembers);
            return ThreeWayConflictHandler.Resolution.MERGED;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Nonnull
    public ThreeWayConflictHandler.Resolution deleteDeletedProperty(@Nonnull NodeBuilder parent, @Nonnull PropertyState base) {
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Nonnull
    public ThreeWayConflictHandler.Resolution deleteChangedProperty(@Nonnull NodeBuilder parent, @Nonnull PropertyState theirs, @Nonnull PropertyState base) {
        if (RepMembersConflictHandler.isRepMembersProperty(theirs)) {
            return ThreeWayConflictHandler.Resolution.OURS;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Nonnull
    public ThreeWayConflictHandler.Resolution addExistingNode(@Nonnull NodeBuilder parent, @Nonnull String name, @Nonnull NodeState ours, @Nonnull NodeState theirs) {
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Nonnull
    public ThreeWayConflictHandler.Resolution changeDeletedNode(@Nonnull NodeBuilder parent, @Nonnull String name, @Nonnull NodeState ours, @Nonnull NodeState base) {
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Nonnull
    public ThreeWayConflictHandler.Resolution deleteChangedNode(@Nonnull NodeBuilder parent, @Nonnull String name, @Nonnull NodeState theirs, @Nonnull NodeState base) {
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Nonnull
    public ThreeWayConflictHandler.Resolution deleteDeletedNode(@Nonnull NodeBuilder parent, @Nonnull String name, @Nonnull NodeState base) {
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    private static void mergeChange(NodeBuilder parent, PropertyState ours, PropertyState theirs, Set<String> base) {
        PropertyBuilder merged = PropertyBuilder.array((Type)Type.STRING);
        merged.setName("rep:members");
        HashSet theirMembers = Sets.newHashSet((Iterable)((Iterable)theirs.getValue(Type.STRINGS)));
        HashSet ourMembers = Sets.newHashSet((Iterable)((Iterable)ours.getValue(Type.STRINGS)));
        HashSet combined = Sets.newHashSet((Iterable)Sets.intersection((Set)ourMembers, (Set)theirMembers));
        for (String m : Sets.difference((Set)ourMembers, (Set)theirMembers)) {
            if (base.contains(m)) continue;
            combined.add(m);
        }
        for (String m : Sets.difference((Set)theirMembers, (Set)ourMembers)) {
            if (base.contains(m)) continue;
            combined.add(m);
        }
        merged.addValues((Iterable)combined);
        parent.setProperty(merged.getPropertyState());
    }

    private static boolean isRepMembersProperty(PropertyState p) {
        return "rep:members".equals(p.getName());
    }
}

