/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.security.SecureRandom;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableNodeName;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={AuthorizableNodeName.class}, property={"oak.security.name=org.apache.jackrabbit.oak.security.user.RandomAuthorizableNodeName"})
@Designate(ocd=Configuration.class)
public class RandomAuthorizableNodeName
implements AuthorizableNodeName {
    private static final char[] VALID_CHARS;
    public static final int DEFAULT_LENGTH = 21;
    private int length = 21;

    @Nonnull
    public String generateNodeName(@Nonnull String authorizableId) {
        SecureRandom random = new SecureRandom();
        char[] chars = new char[this.length];
        for (int i = 0; i < this.length; ++i) {
            chars[i] = VALID_CHARS[random.nextInt(VALID_CHARS.length)];
        }
        return new String(chars);
    }

    @Activate
    private void activate(Configuration config) {
        this.length = config.length();
    }

    static {
        char i;
        StringBuilder sb = new StringBuilder();
        for (i = 'a'; i <= 'z'; i = (char)(i + '\u0001')) {
            sb.append(i);
        }
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            sb.append(i);
        }
        for (i = '0'; i <= '9'; i = (char)(i + '\u0001')) {
            sb.append(i);
        }
        sb.append("-_");
        VALID_CHARS = sb.toString().toCharArray();
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak Random Authorizable Node Name", description="Generates a random name for the authorizable node.")
    static @interface Configuration {
        @AttributeDefinition(name="Name Length", description="Length of the generated node name.")
        public int length() default 21;
    }
}

