/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.security.user.AbstractGroupPrincipal;
import org.apache.jackrabbit.oak.security.user.AuthorizableImpl;
import org.apache.jackrabbit.oak.security.user.AuthorizableIterator;
import org.apache.jackrabbit.oak.security.user.MembershipProvider;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.apache.jackrabbit.oak.spi.xml.ImportBehavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GroupImpl
extends AuthorizableImpl
implements Group {
    private static final Logger log = LoggerFactory.getLogger(GroupImpl.class);

    GroupImpl(String id, Tree tree, UserManagerImpl userManager) throws RepositoryException {
        super(id, tree, userManager);
    }

    @Override
    void checkValidTree(@Nonnull Tree tree) throws RepositoryException {
        if (!UserUtil.isType((Tree)tree, (AuthorizableType)AuthorizableType.GROUP)) {
            throw new IllegalArgumentException("Invalid group node: node type rep:Group expected.");
        }
    }

    public boolean isGroup() {
        return true;
    }

    public Principal getPrincipal() throws RepositoryException {
        return new GroupPrincipal(this.getPrincipalName(), this.getTree());
    }

    public Iterator<Authorizable> getDeclaredMembers() throws RepositoryException {
        return this.getMembers(false);
    }

    public Iterator<Authorizable> getMembers() throws RepositoryException {
        return this.getMembers(true);
    }

    public boolean isDeclaredMember(Authorizable authorizable) throws RepositoryException {
        return this.isMember(authorizable, false);
    }

    public boolean isMember(Authorizable authorizable) throws RepositoryException {
        return this.isMember(authorizable, true);
    }

    public boolean addMember(Authorizable authorizable) throws RepositoryException {
        boolean success;
        if (!GroupImpl.isValidAuthorizableImpl(authorizable)) {
            log.warn("Invalid Authorizable: {}", (Object)authorizable);
            return false;
        }
        AuthorizableImpl authorizableImpl = (AuthorizableImpl)authorizable;
        if (this.isEveryone() || authorizableImpl.isEveryone()) {
            return false;
        }
        String memberID = authorizable.getID();
        if (authorizableImpl.isGroup()) {
            if (this.getID().equals(memberID)) {
                String msg = "Attempt to add a group as member of itself (" + this.getID() + ").";
                log.debug(msg);
                return false;
            }
            if (this.isCyclicMembership((Group)authorizable)) {
                String msg = "Cyclic group membership detected for group " + this.getID() + " and member " + authorizable.getID();
                throw new ConstraintViolationException(msg);
            }
        }
        if (success = this.getMembershipProvider().addMember(this.getTree(), authorizableImpl.getTree())) {
            this.getUserManager().onGroupUpdate(this, false, authorizable);
        }
        return success;
    }

    public Set<String> addMembers(String ... memberIds) throws RepositoryException {
        return this.updateMembers(false, memberIds);
    }

    public boolean removeMember(Authorizable authorizable) throws RepositoryException {
        if (!GroupImpl.isValidAuthorizableImpl(authorizable)) {
            log.warn("Invalid Authorizable: {}", (Object)authorizable);
            return false;
        }
        if (this.isEveryone()) {
            return false;
        }
        Tree memberTree = ((AuthorizableImpl)authorizable).getTree();
        boolean success = this.getMembershipProvider().removeMember(this.getTree(), memberTree);
        if (success) {
            this.getUserManager().onGroupUpdate(this, true, authorizable);
        }
        return success;
    }

    public Set<String> removeMembers(String ... memberIds) throws RepositoryException {
        return this.updateMembers(true, memberIds);
    }

    private Iterator<Authorizable> getMembers(boolean includeInherited) throws RepositoryException {
        UserManagerImpl userMgr = this.getUserManager();
        if (this.isEveryone()) {
            String propName = this.getUserManager().getNamePathMapper().getJcrName("rep:principalName");
            return Iterators.filter(userMgr.findAuthorizables(propName, null, 3), (Predicate)new Predicate<Authorizable>(){

                public boolean apply(@Nullable Authorizable authorizable) {
                    if (authorizable == null) {
                        return false;
                    }
                    if (authorizable.isGroup()) {
                        try {
                            return !((GroupImpl)authorizable).isEveryone();
                        }
                        catch (RepositoryException e) {
                            log.warn("Unable to evaluate if authorizable is the 'everyone' group.", (Throwable)e);
                        }
                    }
                    return true;
                }
            });
        }
        Iterator<String> oakPaths = this.getMembershipProvider().getMembers(this.getTree(), includeInherited);
        if (oakPaths.hasNext()) {
            AuthorizableIterator iterator = AuthorizableIterator.create(oakPaths, userMgr, AuthorizableType.AUTHORIZABLE);
            return new RangeIteratorAdapter((Iterator)iterator, iterator.getSize());
        }
        return RangeIteratorAdapter.EMPTY;
    }

    private boolean isMember(Authorizable authorizable, boolean includeInherited) throws RepositoryException {
        if (!GroupImpl.isValidAuthorizableImpl(authorizable)) {
            return false;
        }
        if (this.getID().equals(authorizable.getID())) {
            return false;
        }
        if (this.isEveryone()) {
            return true;
        }
        if (((AuthorizableImpl)authorizable).isEveryone()) {
            return false;
        }
        Tree authorizableTree = ((AuthorizableImpl)authorizable).getTree();
        MembershipProvider mgr = this.getUserManager().getMembershipProvider();
        if (includeInherited) {
            return mgr.isMember(this.getTree(), authorizableTree);
        }
        return mgr.isDeclaredMember(this.getTree(), authorizableTree);
    }

    private Set<String> updateMembers(boolean isRemove, String ... memberIds) throws RepositoryException {
        HashSet failedIds = Sets.newHashSet((Object[])memberIds);
        int importBehavior = UserUtil.getImportBehavior((ConfigurationParameters)this.getUserManager().getConfig());
        if (this.isEveryone()) {
            String msg = "Attempt to add or remove from everyone group.";
            log.debug(msg);
            return failedIds;
        }
        HashMap updateMap = Maps.newHashMapWithExpectedSize((int)memberIds.length);
        MembershipProvider mp = this.getMembershipProvider();
        for (String memberId : memberIds) {
            if (Strings.isNullOrEmpty((String)memberId)) {
                throw new ConstraintViolationException("MemberId must not be null or empty.");
            }
            if (this.getID().equals(memberId)) {
                String msg = "Attempt to add or remove a group as member of itself (" + this.getID() + ").";
                log.debug(msg);
                continue;
            }
            if (2 != importBehavior) {
                Authorizable member = this.getUserManager().getAuthorizable(memberId);
                String msg = null;
                if (member == null) {
                    msg = "Attempt to add or remove a non-existing member '" + memberId + "' with ImportBehavior = " + ImportBehavior.nameFromValue((int)importBehavior);
                } else if (member.isGroup()) {
                    if (((AuthorizableImpl)member).isEveryone()) {
                        log.debug("Attempt to add everyone group as member.");
                        continue;
                    }
                    if (this.isCyclicMembership((Group)member)) {
                        msg = "Cyclic group membership detected for group " + this.getID() + " and member " + member.getID();
                    }
                }
                if (msg != null) {
                    if (3 == importBehavior) {
                        throw new ConstraintViolationException(msg);
                    }
                    log.debug(msg);
                    continue;
                }
            }
            failedIds.remove(memberId);
            updateMap.put(mp.getContentID(memberId), memberId);
        }
        HashSet processedIds = Sets.newHashSet(updateMap.values());
        if (!updateMap.isEmpty()) {
            Set<String> result = isRemove ? mp.removeMembers(this.getTree(), updateMap) : mp.addMembers(this.getTree(), updateMap);
            failedIds.addAll(result);
            processedIds.removeAll(result);
        }
        this.getUserManager().onGroupUpdate(this, isRemove, false, processedIds, failedIds);
        return failedIds;
    }

    private boolean isCyclicMembership(@Nonnull Group member) throws RepositoryException {
        return member.isMember((Authorizable)this);
    }

    private final class GroupPrincipal
    extends AbstractGroupPrincipal {
        private GroupPrincipal(String principalName, Tree groupTree) {
            super(principalName, groupTree, GroupImpl.this.getUserManager().getNamePathMapper());
        }

        @Override
        UserManager getUserManager() {
            return GroupImpl.this.getUserManager();
        }

        @Override
        boolean isEveryone() throws RepositoryException {
            return GroupImpl.this.isEveryone();
        }

        @Override
        boolean isMember(@Nonnull Authorizable authorizable) throws RepositoryException {
            return GroupImpl.this.isMember(authorizable);
        }

        @Override
        @Nonnull
        Iterator<Authorizable> getMembers() throws RepositoryException {
            return GroupImpl.this.getMembers();
        }
    }
}

