/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AuthorizableIterator
implements Iterator {
    private static final Logger log = LoggerFactory.getLogger(AuthorizableIterator.class);
    private final Iterator<Authorizable> authorizables;
    private final long size;

    static AuthorizableIterator create(Iterator<String> authorizableOakPaths, UserManagerImpl userManager, AuthorizableType authorizableType) {
        Iterator it = Iterators.transform(authorizableOakPaths, (Function)new PathToAuthorizable(userManager, authorizableType));
        long size = AuthorizableIterator.getSize(authorizableOakPaths);
        return new AuthorizableIterator((Iterator<Authorizable>)Iterators.filter((Iterator)it, (Predicate)Predicates.notNull()), size);
    }

    private AuthorizableIterator(Iterator<Authorizable> authorizables, long size) {
        this.authorizables = authorizables;
        this.size = size;
    }

    @Override
    public boolean hasNext() {
        return this.authorizables.hasNext();
    }

    public Authorizable next() {
        return this.authorizables.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    long getSize() {
        return this.size;
    }

    private static long getSize(Iterator it) {
        if (it instanceof RangeIterator) {
            return ((RangeIterator)it).getSize();
        }
        return -1L;
    }

    private static class AuthorizableTypePredicate
    implements Predicate<Authorizable> {
        private final AuthorizableType authorizableType;

        AuthorizableTypePredicate(AuthorizableType authorizableType) {
            this.authorizableType = authorizableType;
        }

        public boolean apply(Authorizable authorizable) {
            return this.authorizableType.isType(authorizable);
        }
    }

    private static class PathToAuthorizable
    implements Function<String, Authorizable> {
        private final UserManagerImpl userManager;
        private final Predicate predicate;

        public PathToAuthorizable(UserManagerImpl userManager, AuthorizableType type) {
            this.userManager = userManager;
            this.predicate = new AuthorizableTypePredicate(type);
        }

        public Authorizable apply(String oakPath) {
            try {
                Authorizable a = this.userManager.getAuthorizableByOakPath(oakPath);
                if (this.predicate.apply((Object)a)) {
                    return a;
                }
            }
            catch (RepositoryException e) {
                log.debug("Failed to access authorizable " + oakPath);
            }
            return null;
        }
    }
}

